/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.message;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.MessageHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.OpenObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.message.OpenMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.OpenBuilder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OpenMessageBuilder {
    private Open _open;
    private ProtocolVersion _version;
    Map<Class<? extends Augmentation<OpenMessage>>, Augmentation<OpenMessage>> augmentation = Map.of();

    public OpenMessageBuilder() {
    }

    public OpenMessageBuilder(MessageHeader arg) {
        this._version = arg.getVersion();
    }

    public OpenMessageBuilder(OpenObject arg) {
        this._open = arg.getOpen();
    }

    public OpenMessageBuilder(OpenMessage base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OpenMessage>>, Augmentation<OpenMessage>>(aug);
        }
        this._open = base.getOpen();
        this._version = base.getVersion();
    }

    public void fieldsFrom(DataObject arg) {
        Object castArg;
        boolean isValidArg = false;
        if (arg instanceof OpenObject) {
            castArg = (OpenObject)arg;
            this._open = castArg.getOpen();
            isValidArg = true;
        }
        if (arg instanceof MessageHeader) {
            castArg = (MessageHeader)arg;
            this._version = castArg.getVersion();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[OpenObject, MessageHeader]");
    }

    public static @NonNull OpenMessage empty() {
        return LazyEmpty.INSTANCE;
    }

    public Open getOpen() {
        return this._open;
    }

    public ProtocolVersion getVersion() {
        return this._version;
    }

    public <E$$ extends Augmentation<OpenMessage>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public OpenMessageBuilder setOpen(Open value) {
        this._open = value;
        return this;
    }

    public OpenMessageBuilder setVersion(ProtocolVersion value) {
        this._version = value;
        return this;
    }

    public OpenMessageBuilder addAugmentation(Augmentation<OpenMessage> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OpenMessage>>, Augmentation<OpenMessage>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public OpenMessageBuilder removeAugmentation(Class<? extends Augmentation<OpenMessage>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull OpenMessage build() {
        return new OpenMessageImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull OpenMessage INSTANCE = new OpenMessageBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class OpenMessageImpl
    extends AbstractAugmentable<OpenMessage>
    implements OpenMessage {
        private final Open _open;
        private final ProtocolVersion _version;
        private int hash = 0;
        private volatile boolean hashValid = false;

        OpenMessageImpl(OpenMessageBuilder base) {
            super(base.augmentation);
            this._open = base.getOpen();
            this._version = base.getVersion();
        }

        @Override
        public Open getOpen() {
            return this._open;
        }

        @Override
        public ProtocolVersion getVersion() {
            return this._version;
        }

        @Override
        public Open nonnullOpen() {
            return Objects.requireNonNullElse(this.getOpen(), OpenBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = OpenMessage.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return OpenMessage.bindingEquals(this, obj);
        }

        public String toString() {
            return OpenMessage.bindingToString(this);
        }
    }
}

