/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcep.error.object;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcep.error.object.ErrorObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcep.error.object.error.object.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcep.error.object.error.object.TlvsBuilder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

public class ErrorObjectBuilder {
    private Boolean _ignore;
    private Boolean _processingRule;
    private Tlvs _tlvs;
    private Uint8 _type;
    private Uint8 _value;
    Map<Class<? extends Augmentation<ErrorObject>>, Augmentation<ErrorObject>> augmentation = Map.of();

    public ErrorObjectBuilder() {
    }

    public ErrorObjectBuilder(Object arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public ErrorObjectBuilder(ObjectHeader arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public ErrorObjectBuilder(ErrorObject base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ErrorObject>>, Augmentation<ErrorObject>>(aug);
        }
        this._ignore = base.getIgnore();
        this._processingRule = base.getProcessingRule();
        this._tlvs = base.getTlvs();
        this._type = base.getType();
        this._value = base.getValue();
    }

    public void fieldsFrom(DataObject arg) {
        ObjectHeader castArg;
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            castArg = (ObjectHeader)arg;
            this._processingRule = castArg.getProcessingRule();
            this._ignore = castArg.getIgnore();
            isValidArg = true;
        }
        if (arg instanceof Object) {
            castArg = (Object)arg;
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (java.lang.Object)arg, (String)"[ObjectHeader, Object]");
    }

    public static @NonNull ErrorObject empty() {
        return LazyEmpty.INSTANCE;
    }

    public Boolean getIgnore() {
        return this._ignore;
    }

    public Boolean getProcessingRule() {
        return this._processingRule;
    }

    public Tlvs getTlvs() {
        return this._tlvs;
    }

    public Uint8 getType() {
        return this._type;
    }

    public Uint8 getValue() {
        return this._value;
    }

    public <E$$ extends Augmentation<ErrorObject>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ErrorObjectBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public ErrorObjectBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public ErrorObjectBuilder setTlvs(Tlvs value) {
        this._tlvs = value;
        return this;
    }

    public ErrorObjectBuilder setType(Uint8 value) {
        this._type = value;
        return this;
    }

    public ErrorObjectBuilder setValue(Uint8 value) {
        this._value = value;
        return this;
    }

    public ErrorObjectBuilder addAugmentation(Augmentation<ErrorObject> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ErrorObject>>, Augmentation<ErrorObject>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public ErrorObjectBuilder removeAugmentation(Class<? extends Augmentation<ErrorObject>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull ErrorObject build() {
        return new ErrorObjectImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull ErrorObject INSTANCE = new ErrorObjectBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class ErrorObjectImpl
    extends AbstractAugmentable<ErrorObject>
    implements ErrorObject {
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private final Tlvs _tlvs;
        private final Uint8 _type;
        private final Uint8 _value;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ErrorObjectImpl(ErrorObjectBuilder base) {
            super(base.augmentation);
            this._ignore = base.getIgnore();
            this._processingRule = base.getProcessingRule();
            this._tlvs = base.getTlvs();
            this._type = base.getType();
            this._value = base.getValue();
        }

        @Override
        public Boolean getIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean getProcessingRule() {
            return this._processingRule;
        }

        @Override
        public Tlvs getTlvs() {
            return this._tlvs;
        }

        @Override
        public Uint8 getType() {
            return this._type;
        }

        @Override
        public Uint8 getValue() {
            return this._value;
        }

        @Override
        public Tlvs nonnullTlvs() {
            return Objects.requireNonNullElse(this.getTlvs(), TlvsBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = ErrorObject.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(java.lang.Object obj) {
            return ErrorObject.bindingEquals(this, obj);
        }

        public String toString() {
            return ErrorObject.bindingToString(this);
        }
    }
}

