/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.RpObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.VendorInformationObjects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.Requests;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.PathKeyExpansion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.PathKeyExpansionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.SegmentComputation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.SegmentComputationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.Rp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.RpBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.objects.VendorInformationObject;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RequestsBuilder {
    private PathKeyExpansion _pathKeyExpansion;
    private Rp _rp;
    private SegmentComputation _segmentComputation;
    private List<VendorInformationObject> _vendorInformationObject;
    Map<Class<? extends Augmentation<Requests>>, Augmentation<Requests>> augmentation = Map.of();

    public RequestsBuilder() {
    }

    public RequestsBuilder(RpObject arg) {
        this._rp = arg.getRp();
    }

    public RequestsBuilder(VendorInformationObjects arg) {
        this._vendorInformationObject = arg.getVendorInformationObject();
    }

    public RequestsBuilder(Requests base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Requests>>, Augmentation<Requests>>(aug);
        }
        this._pathKeyExpansion = base.getPathKeyExpansion();
        this._rp = base.getRp();
        this._segmentComputation = base.getSegmentComputation();
        this._vendorInformationObject = base.getVendorInformationObject();
    }

    public void fieldsFrom(DataObject arg) {
        Object castArg;
        boolean isValidArg = false;
        if (arg instanceof RpObject) {
            castArg = (RpObject)arg;
            this._rp = castArg.getRp();
            isValidArg = true;
        }
        if (arg instanceof VendorInformationObjects) {
            castArg = (VendorInformationObjects)arg;
            this._vendorInformationObject = castArg.getVendorInformationObject();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[RpObject, VendorInformationObjects]");
    }

    public PathKeyExpansion getPathKeyExpansion() {
        return this._pathKeyExpansion;
    }

    public Rp getRp() {
        return this._rp;
    }

    public SegmentComputation getSegmentComputation() {
        return this._segmentComputation;
    }

    public List<VendorInformationObject> getVendorInformationObject() {
        return this._vendorInformationObject;
    }

    public <E$$ extends Augmentation<Requests>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public RequestsBuilder setPathKeyExpansion(PathKeyExpansion value) {
        this._pathKeyExpansion = value;
        return this;
    }

    public RequestsBuilder setRp(Rp value) {
        this._rp = value;
        return this;
    }

    public RequestsBuilder setSegmentComputation(SegmentComputation value) {
        this._segmentComputation = value;
        return this;
    }

    public RequestsBuilder setVendorInformationObject(List<VendorInformationObject> values) {
        this._vendorInformationObject = values;
        return this;
    }

    public RequestsBuilder addAugmentation(Augmentation<Requests> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Requests>>, Augmentation<Requests>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public RequestsBuilder removeAugmentation(Class<? extends Augmentation<Requests>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Requests build() {
        return new RequestsImpl(this);
    }

    private static final class RequestsImpl
    extends AbstractAugmentable<Requests>
    implements Requests {
        private final PathKeyExpansion _pathKeyExpansion;
        private final Rp _rp;
        private final SegmentComputation _segmentComputation;
        private final List<VendorInformationObject> _vendorInformationObject;
        private int hash = 0;
        private volatile boolean hashValid = false;

        RequestsImpl(RequestsBuilder base) {
            super(base.augmentation);
            this._pathKeyExpansion = base.getPathKeyExpansion();
            this._rp = base.getRp();
            this._segmentComputation = base.getSegmentComputation();
            this._vendorInformationObject = CodeHelpers.emptyToNull(base.getVendorInformationObject());
        }

        @Override
        public PathKeyExpansion getPathKeyExpansion() {
            return this._pathKeyExpansion;
        }

        @Override
        public Rp getRp() {
            return this._rp;
        }

        @Override
        public SegmentComputation getSegmentComputation() {
            return this._segmentComputation;
        }

        @Override
        public List<VendorInformationObject> getVendorInformationObject() {
            return this._vendorInformationObject;
        }

        @Override
        public PathKeyExpansion nonnullPathKeyExpansion() {
            return Objects.requireNonNullElse(this.getPathKeyExpansion(), PathKeyExpansionBuilder.empty());
        }

        @Override
        public Rp nonnullRp() {
            return Objects.requireNonNullElse(this.getRp(), RpBuilder.empty());
        }

        @Override
        public SegmentComputation nonnullSegmentComputation() {
            return Objects.requireNonNullElse(this.getSegmentComputation(), SegmentComputationBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Requests.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Requests.bindingEquals(this, obj);
        }

        public String toString() {
            return Requests.bindingToString(this);
        }
    }
}

