/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.BandwidthObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.LoadBalancingObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.LspaObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.OfObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bandwidth.object.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bandwidth.object.BandwidthBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.load.balancing.object.LoadBalancing;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.load.balancing.object.LoadBalancingBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.Lspa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.LspaBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.object.Of;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.object.OfBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.P2mp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.EndpointRroPair;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.IroBncChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.Metric;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class P2mpBuilder {
    private Bandwidth _bandwidth;
    private List<EndpointRroPair> _endpointRroPair;
    private IroBncChoice _iroBncChoice;
    private LoadBalancing _loadBalancing;
    private Lspa _lspa;
    private List<Metric> _metric;
    private Of _of;
    Map<Class<? extends Augmentation<P2mp>>, Augmentation<P2mp>> augmentation = Map.of();

    public P2mpBuilder() {
    }

    public P2mpBuilder(OfObject arg) {
        this._of = arg.getOf();
    }

    public P2mpBuilder(LspaObject arg) {
        this._lspa = arg.getLspa();
    }

    public P2mpBuilder(BandwidthObject arg) {
        this._bandwidth = arg.getBandwidth();
    }

    public P2mpBuilder(LoadBalancingObject arg) {
        this._loadBalancing = arg.getLoadBalancing();
    }

    public P2mpBuilder(P2mp base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<P2mp>>, Augmentation<P2mp>>(aug);
        }
        this._bandwidth = base.getBandwidth();
        this._endpointRroPair = base.getEndpointRroPair();
        this._iroBncChoice = base.getIroBncChoice();
        this._loadBalancing = base.getLoadBalancing();
        this._lspa = base.getLspa();
        this._metric = base.getMetric();
        this._of = base.getOf();
    }

    public void fieldsFrom(DataObject arg) {
        Object castArg;
        boolean isValidArg = false;
        if (arg instanceof BandwidthObject) {
            castArg = (BandwidthObject)arg;
            this._bandwidth = castArg.getBandwidth();
            isValidArg = true;
        }
        if (arg instanceof OfObject) {
            castArg = (OfObject)arg;
            this._of = castArg.getOf();
            isValidArg = true;
        }
        if (arg instanceof LoadBalancingObject) {
            castArg = (LoadBalancingObject)arg;
            this._loadBalancing = castArg.getLoadBalancing();
            isValidArg = true;
        }
        if (arg instanceof LspaObject) {
            castArg = (LspaObject)arg;
            this._lspa = castArg.getLspa();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[BandwidthObject, OfObject, LoadBalancingObject, LspaObject]");
    }

    public static @NonNull P2mp empty() {
        return LazyEmpty.INSTANCE;
    }

    public Bandwidth getBandwidth() {
        return this._bandwidth;
    }

    public List<EndpointRroPair> getEndpointRroPair() {
        return this._endpointRroPair;
    }

    public IroBncChoice getIroBncChoice() {
        return this._iroBncChoice;
    }

    public LoadBalancing getLoadBalancing() {
        return this._loadBalancing;
    }

    public Lspa getLspa() {
        return this._lspa;
    }

    public List<Metric> getMetric() {
        return this._metric;
    }

    public Of getOf() {
        return this._of;
    }

    public <E$$ extends Augmentation<P2mp>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public P2mpBuilder setBandwidth(Bandwidth value) {
        this._bandwidth = value;
        return this;
    }

    public P2mpBuilder setEndpointRroPair(List<EndpointRroPair> values) {
        this._endpointRroPair = values;
        return this;
    }

    public P2mpBuilder setIroBncChoice(IroBncChoice value) {
        this._iroBncChoice = value;
        return this;
    }

    public P2mpBuilder setLoadBalancing(LoadBalancing value) {
        this._loadBalancing = value;
        return this;
    }

    public P2mpBuilder setLspa(Lspa value) {
        this._lspa = value;
        return this;
    }

    public P2mpBuilder setMetric(List<Metric> values) {
        this._metric = values;
        return this;
    }

    public P2mpBuilder setOf(Of value) {
        this._of = value;
        return this;
    }

    public P2mpBuilder addAugmentation(Augmentation<P2mp> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<P2mp>>, Augmentation<P2mp>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public P2mpBuilder removeAugmentation(Class<? extends Augmentation<P2mp>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull P2mp build() {
        return new P2mpImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull P2mp INSTANCE = new P2mpBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class P2mpImpl
    extends AbstractAugmentable<P2mp>
    implements P2mp {
        private final Bandwidth _bandwidth;
        private final List<EndpointRroPair> _endpointRroPair;
        private final IroBncChoice _iroBncChoice;
        private final LoadBalancing _loadBalancing;
        private final Lspa _lspa;
        private final List<Metric> _metric;
        private final Of _of;
        private int hash = 0;
        private volatile boolean hashValid = false;

        P2mpImpl(P2mpBuilder base) {
            super(base.augmentation);
            this._bandwidth = base.getBandwidth();
            this._endpointRroPair = CodeHelpers.emptyToNull(base.getEndpointRroPair());
            this._iroBncChoice = base.getIroBncChoice();
            this._loadBalancing = base.getLoadBalancing();
            this._lspa = base.getLspa();
            this._metric = CodeHelpers.emptyToNull(base.getMetric());
            this._of = base.getOf();
        }

        @Override
        public Bandwidth getBandwidth() {
            return this._bandwidth;
        }

        @Override
        public List<EndpointRroPair> getEndpointRroPair() {
            return this._endpointRroPair;
        }

        @Override
        public IroBncChoice getIroBncChoice() {
            return this._iroBncChoice;
        }

        @Override
        public LoadBalancing getLoadBalancing() {
            return this._loadBalancing;
        }

        @Override
        public Lspa getLspa() {
            return this._lspa;
        }

        @Override
        public List<Metric> getMetric() {
            return this._metric;
        }

        @Override
        public Of getOf() {
            return this._of;
        }

        @Override
        public Bandwidth nonnullBandwidth() {
            return Objects.requireNonNullElse(this.getBandwidth(), BandwidthBuilder.empty());
        }

        @Override
        public LoadBalancing nonnullLoadBalancing() {
            return Objects.requireNonNullElse(this.getLoadBalancing(), LoadBalancingBuilder.empty());
        }

        @Override
        public Lspa nonnullLspa() {
            return Objects.requireNonNullElse(this.getLspa(), LspaBuilder.empty());
        }

        @Override
        public Of nonnullOf() {
            return Objects.requireNonNullElse(this.getOf(), OfBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = P2mp.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return P2mp.bindingEquals(this, obj);
        }

        public String toString() {
            return P2mp.bindingToString(this);
        }
    }
}

