/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.RequestId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.Rp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.rp.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.rp.TlvsBuilder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

public class RpBuilder {
    private Boolean _biDirectional;
    private Boolean _eroCompression;
    private Boolean _fragmentation;
    private Boolean _ignore;
    private Boolean _loose;
    private Boolean _makeBeforeBreak;
    private Boolean _order;
    private Boolean _p2mp;
    private Boolean _pathKey;
    private Uint8 _priority;
    private Boolean _processingRule;
    private Boolean _reoptimization;
    private RequestId _requestId;
    private Boolean _supplyOf;
    private Tlvs _tlvs;
    Map<Class<? extends Augmentation<Rp>>, Augmentation<Rp>> augmentation = Map.of();

    public RpBuilder() {
    }

    public RpBuilder(Object arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public RpBuilder(ObjectHeader arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public RpBuilder(Rp base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Rp>>, Augmentation<Rp>>(aug);
        }
        this._biDirectional = base.getBiDirectional();
        this._eroCompression = base.getEroCompression();
        this._fragmentation = base.getFragmentation();
        this._ignore = base.getIgnore();
        this._loose = base.getLoose();
        this._makeBeforeBreak = base.getMakeBeforeBreak();
        this._order = base.getOrder();
        this._p2mp = base.getP2mp();
        this._pathKey = base.getPathKey();
        this._priority = base.getPriority();
        this._processingRule = base.getProcessingRule();
        this._reoptimization = base.getReoptimization();
        this._requestId = base.getRequestId();
        this._supplyOf = base.getSupplyOf();
        this._tlvs = base.getTlvs();
    }

    public void fieldsFrom(DataObject arg) {
        ObjectHeader castArg;
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            castArg = (ObjectHeader)arg;
            this._processingRule = castArg.getProcessingRule();
            this._ignore = castArg.getIgnore();
            isValidArg = true;
        }
        if (arg instanceof Object) {
            castArg = (Object)arg;
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (java.lang.Object)arg, (String)"[ObjectHeader, Object]");
    }

    public static @NonNull Rp empty() {
        return LazyEmpty.INSTANCE;
    }

    public Boolean getBiDirectional() {
        return this._biDirectional;
    }

    public Boolean getEroCompression() {
        return this._eroCompression;
    }

    public Boolean getFragmentation() {
        return this._fragmentation;
    }

    public Boolean getIgnore() {
        return this._ignore;
    }

    public Boolean getLoose() {
        return this._loose;
    }

    public Boolean getMakeBeforeBreak() {
        return this._makeBeforeBreak;
    }

    public Boolean getOrder() {
        return this._order;
    }

    public Boolean getP2mp() {
        return this._p2mp;
    }

    public Boolean getPathKey() {
        return this._pathKey;
    }

    public Uint8 getPriority() {
        return this._priority;
    }

    public Boolean getProcessingRule() {
        return this._processingRule;
    }

    public Boolean getReoptimization() {
        return this._reoptimization;
    }

    public RequestId getRequestId() {
        return this._requestId;
    }

    public Boolean getSupplyOf() {
        return this._supplyOf;
    }

    public Tlvs getTlvs() {
        return this._tlvs;
    }

    public <E$$ extends Augmentation<Rp>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public RpBuilder setBiDirectional(Boolean value) {
        this._biDirectional = value;
        return this;
    }

    public RpBuilder setEroCompression(Boolean value) {
        this._eroCompression = value;
        return this;
    }

    public RpBuilder setFragmentation(Boolean value) {
        this._fragmentation = value;
        return this;
    }

    public RpBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public RpBuilder setLoose(Boolean value) {
        this._loose = value;
        return this;
    }

    public RpBuilder setMakeBeforeBreak(Boolean value) {
        this._makeBeforeBreak = value;
        return this;
    }

    public RpBuilder setOrder(Boolean value) {
        this._order = value;
        return this;
    }

    public RpBuilder setP2mp(Boolean value) {
        this._p2mp = value;
        return this;
    }

    public RpBuilder setPathKey(Boolean value) {
        this._pathKey = value;
        return this;
    }

    private static void checkPriorityRange(short value) {
        if (value >= 1 && value <= 7) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[1..7]]", (int)value);
    }

    public RpBuilder setPriority(Uint8 value) {
        if (value != null) {
            RpBuilder.checkPriorityRange(value.shortValue());
        }
        this._priority = value;
        return this;
    }

    public RpBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public RpBuilder setReoptimization(Boolean value) {
        this._reoptimization = value;
        return this;
    }

    public RpBuilder setRequestId(RequestId value) {
        this._requestId = value;
        return this;
    }

    public RpBuilder setSupplyOf(Boolean value) {
        this._supplyOf = value;
        return this;
    }

    public RpBuilder setTlvs(Tlvs value) {
        this._tlvs = value;
        return this;
    }

    public RpBuilder addAugmentation(Augmentation<Rp> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Rp>>, Augmentation<Rp>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public RpBuilder removeAugmentation(Class<? extends Augmentation<Rp>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Rp build() {
        return new RpImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull Rp INSTANCE = new RpBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class RpImpl
    extends AbstractAugmentable<Rp>
    implements Rp {
        private final Boolean _biDirectional;
        private final Boolean _eroCompression;
        private final Boolean _fragmentation;
        private final Boolean _ignore;
        private final Boolean _loose;
        private final Boolean _makeBeforeBreak;
        private final Boolean _order;
        private final Boolean _p2mp;
        private final Boolean _pathKey;
        private final Uint8 _priority;
        private final Boolean _processingRule;
        private final Boolean _reoptimization;
        private final RequestId _requestId;
        private final Boolean _supplyOf;
        private final Tlvs _tlvs;
        private int hash = 0;
        private volatile boolean hashValid = false;

        RpImpl(RpBuilder base) {
            super(base.augmentation);
            this._biDirectional = base.getBiDirectional();
            this._eroCompression = base.getEroCompression();
            this._fragmentation = base.getFragmentation();
            this._ignore = base.getIgnore();
            this._loose = base.getLoose();
            this._makeBeforeBreak = base.getMakeBeforeBreak();
            this._order = base.getOrder();
            this._p2mp = base.getP2mp();
            this._pathKey = base.getPathKey();
            this._priority = base.getPriority();
            this._processingRule = base.getProcessingRule();
            this._reoptimization = base.getReoptimization();
            this._requestId = base.getRequestId();
            this._supplyOf = base.getSupplyOf();
            this._tlvs = base.getTlvs();
        }

        @Override
        public Boolean getBiDirectional() {
            return this._biDirectional;
        }

        @Override
        public Boolean getEroCompression() {
            return this._eroCompression;
        }

        @Override
        public Boolean getFragmentation() {
            return this._fragmentation;
        }

        @Override
        public Boolean getIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean getLoose() {
            return this._loose;
        }

        @Override
        public Boolean getMakeBeforeBreak() {
            return this._makeBeforeBreak;
        }

        @Override
        public Boolean getOrder() {
            return this._order;
        }

        @Override
        public Boolean getP2mp() {
            return this._p2mp;
        }

        @Override
        public Boolean getPathKey() {
            return this._pathKey;
        }

        @Override
        public Uint8 getPriority() {
            return this._priority;
        }

        @Override
        public Boolean getProcessingRule() {
            return this._processingRule;
        }

        @Override
        public Boolean getReoptimization() {
            return this._reoptimization;
        }

        @Override
        public RequestId getRequestId() {
            return this._requestId;
        }

        @Override
        public Boolean getSupplyOf() {
            return this._supplyOf;
        }

        @Override
        public Tlvs getTlvs() {
            return this._tlvs;
        }

        @Override
        public Tlvs nonnullTlvs() {
            return Objects.requireNonNullElse(this.getTlvs(), TlvsBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Rp.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(java.lang.Object obj) {
            return Rp.bindingEquals(this, obj);
        }

        public String toString() {
            return Rp.bindingToString(this);
        }
    }
}

