package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.rev130409;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.ServiceType;


/**
 * Service representing a PCEP session proposal factory service. The service 
 * provides initial session attributes given by the user.
 * <p>This class represents the following YANG schema fragment defined in module <b>odl-pcep-api-cfg</b>
 * <br />(Source path: <i>META-INF/yang/odl-pcep-api-cfg.yang</i>):
 * <pre>
 * identity pcep-session-proposal-factory {
 *     base "()IdentitySchemaNodeImpl[base=null, qname=(urn:opendaylight:params:xml:ns:yang:controller:config?revision=2013-04-05)service-type]";
 *     description
 *         "Service representing a PCEP session proposal factory service. The service
 *                      provides initial session attributes given by the user.";
 *     status CURRENT;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>odl-pcep-api-cfg/pcep-session-proposal-factory</i>
 */
public abstract class PcepSessionProposalFactory extends ServiceType
 {
    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:pcep","2013-04-09","pcep-session-proposal-factory");;

    public PcepSessionProposalFactory() {
    
    
    }
    








}
