package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.CloseMessage;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Notification;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-message</b>
 * <br />(Source path: <i>META-INF/yang/pcep-message.yang</i>):
 * <pre>
 * notification close {
 *     container c-close-message {
 *         container c-close {
 *             leaf processing-rule {
 *                 type boolean;
 *             }
 *             leaf ignore {
 *                 type boolean;
 *             }
 *             leaf reason {
 *                 type uint8;
 *             }
 *             container tlvs {
 *                 list vendor-information-tlv {
 *                     key     leaf enterprise-number {
 *                         type enterprise-number;
 *                     }
 *                     choice enterprise-specific-information {
 *                     }
 *                     uses vendor-information;
 *                     uses tlv;
 *                 }
 *                 uses vendor-information-tlvs;
 *             }
 *             uses object;
 *         }
 *         leaf version {
 *             type protocol-version;
 *         }
 *         uses close-object;
 *         uses message-header;
 *     }
 *     uses close-message;
 *     status CURRENT;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-message/close</i>
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.CloseBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.CloseBuilder
 */
public interface Close
    extends
    ChildOf<DataObject>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.Close>,
    CloseMessage,
    Notification
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:message","2013-10-07","close");;


}

