package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.Close;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.Pcerr;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.Keepalive;
import org.opendaylight.yangtools.yang.binding.NotificationListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.Pcreq;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.Pcntf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.Pcrep;


/**
 * Interface for receiving the following YANG notifications defined in module <b>pcep-message</b>
 * <br />(Source path: <i>META-INF/yang/pcep-message.yang</i>):
 * <pre>
 * notification close {
 *     container c-close-message {
 *         container c-close {
 *             leaf processing-rule {
 *                 type boolean;
 *             }
 *             leaf ignore {
 *                 type boolean;
 *             }
 *             leaf reason {
 *                 type uint8;
 *             }
 *             container tlvs {
 *                 list vendor-information-tlv {
 *                     key     leaf enterprise-number {
 *                         type enterprise-number;
 *                     }
 *                     choice enterprise-specific-information {
 *                     }
 *                     uses vendor-information;
 *                     uses tlv;
 *                 }
 *                 uses vendor-information-tlvs;
 *             }
 *             uses object;
 *         }
 *         leaf version {
 *             type protocol-version;
 *         }
 *         uses close-object;
 *         uses message-header;
 *     }
 *     uses close-message;
 *     status CURRENT;
 * }
 * notification keepalive {
 *     container keepalive-message {
 *         leaf version {
 *             type protocol-version;
 *         }
 *         uses message-header;
 *     }
 *     uses keepalive-message;
 *     status CURRENT;
 * }
 * notification open {
 *     container open-message {
 *         container open {
 *             leaf processing-rule {
 *                 type boolean;
 *             }
 *             leaf ignore {
 *                 type boolean;
 *             }
 *             container tlvs {
 *                 container of-list {
 *                     leaf-list codes {
 *                         type of-id;
 *                     }
 *                     uses tlv;
 *                 }
 *                 list vendor-information-tlv {
 *                     key     leaf enterprise-number {
 *                         type enterprise-number;
 *                     }
 *                     choice enterprise-specific-information {
 *                     }
 *                     uses vendor-information;
 *                     uses tlv;
 *                 }
 *                 uses of-list-tlv;
 *                 uses vendor-information-tlvs;
 *             }
 *             leaf version {
 *                 type protocol-version;
 *             }
 *             leaf keepalive {
 *                 type uint8;
 *             }
 *             leaf dead-timer {
 *                 type uint8;
 *             }
 *             leaf session-id {
 *                 type uint8;
 *             }
 *             uses object;
 *         }
 *         leaf version {
 *             type protocol-version;
 *         }
 *         uses message-header;
 *         uses open-object;
 *     }
 *     uses open-message;
 *     status CURRENT;
 * }
 * notification pcerr {
 *     container pcerr-message {
 *         leaf version {
 *             type protocol-version;
 *         }
 *         list errors {
 *             key     container error-object {
 *                 leaf processing-rule {
 *                     type boolean;
 *                 }
 *                 leaf ignore {
 *                     type boolean;
 *                 }
 *                 container tlvs {
 *                     container req-missing {
 *                         leaf request-id {
 *                             type request-id;
 *                         }
 *                         uses tlv;
 *                     }
 *                     list vendor-information-tlv {
 *                         key     leaf enterprise-number {
 *                             type enterprise-number;
 *                         }
 *                         choice enterprise-specific-information {
 *                         }
 *                         uses vendor-information;
 *                         uses tlv;
 *                     }
 *                     uses vendor-information-tlvs;
 *                     uses req-missing-tlv;
 *                 }
 *                 leaf type {
 *                     type uint8;
 *                 }
 *                 leaf value {
 *                     type uint8;
 *                 }
 *                 uses object;
 *             }
 *             uses pcep-error-object;
 *         }
 *         choice error-type {
 *             case request-case {
 *                 container request {
 *                     list rps {
 *                         key     container rp {
 *                             leaf processing-rule {
 *                                 type boolean;
 *                             }
 *                             leaf ignore {
 *                                 type boolean;
 *                             }
 *                             container tlvs {
 *                                 list vendor-information-tlv {
 *                                     key     leaf enterprise-number {
 *                                         type enterprise-number;
 *                                     }
 *                                     choice enterprise-specific-information {
 *                                     }
 *                                     uses vendor-information;
 *                                     uses tlv;
 *                                 }
 *                                 container order {
 *                                     leaf delete {
 *                                         type uint32;
 *                                     }
 *                                     leaf setup {
 *                                         type uint32;
 *                                     }
 *                                     uses tlv;
 *                                 }
 *                                 uses vendor-information-tlvs;
 *                                 uses order-tlv;
 *                             }
 *                             leaf priority {
 *                                 type uint8;
 *                             }
 *                             leaf request-id {
 *                                 type request-id;
 *                             }
 *                             leaf reoptimization {
 *                                 type boolean;
 *                             }
 *                             leaf bi-directional {
 *                                 type boolean;
 *                             }
 *                             leaf loose {
 *                                 type boolean;
 *                             }
 *                             leaf path-key {
 *                                 type boolean;
 *                             }
 *                             leaf fragmentation {
 *                                 type boolean;
 *                             }
 *                             leaf p2mp {
 *                                 type boolean;
 *                             }
 *                             leaf ero-compression {
 *                                 type boolean;
 *                             }
 *                             leaf supply-of {
 *                                 type boolean;
 *                             }
 *                             leaf order {
 *                                 type boolean;
 *                             }
 *                             leaf make-before-break {
 *                                 type boolean;
 *                             }
 *                             uses object;
 *                         }
 *                         uses rp-object;
 *                     }
 *                 }
 *             }
 *             case session-case {
 *                 container session {
 *                     container open {
 *                         leaf processing-rule {
 *                             type boolean;
 *                         }
 *                         leaf ignore {
 *                             type boolean;
 *                         }
 *                         container tlvs {
 *                             container of-list {
 *                                 leaf-list codes {
 *                                     type of-id;
 *                                 }
 *                                 uses tlv;
 *                             }
 *                             list vendor-information-tlv {
 *                                 key     leaf enterprise-number {
 *                                     type enterprise-number;
 *                                 }
 *                                 choice enterprise-specific-information {
 *                                 }
 *                                 uses vendor-information;
 *                                 uses tlv;
 *                             }
 *                             uses of-list-tlv;
 *                             uses vendor-information-tlvs;
 *                         }
 *                         leaf version {
 *                             type protocol-version;
 *                         }
 *                         leaf keepalive {
 *                             type uint8;
 *                         }
 *                         leaf dead-timer {
 *                             type uint8;
 *                         }
 *                         leaf session-id {
 *                             type uint8;
 *                         }
 *                         uses object;
 *                     }
 *                     uses open-object;
 *                 }
 *             }
 *         }
 *         uses message-header;
 *     }
 *     uses pcerr-message;
 *     status CURRENT;
 * }
 * notification pcntf {
 *     container pcntf-message {
 *         leaf version {
 *             type protocol-version;
 *         }
 *         list notifications {
 *             key     list rps {
 *                 key     container rp {
 *                     leaf processing-rule {
 *                         type boolean;
 *                     }
 *                     leaf ignore {
 *                         type boolean;
 *                     }
 *                     container tlvs {
 *                         list vendor-information-tlv {
 *                             key     leaf enterprise-number {
 *                                 type enterprise-number;
 *                             }
 *                             choice enterprise-specific-information {
 *                             }
 *                             uses vendor-information;
 *                             uses tlv;
 *                         }
 *                         container order {
 *                             leaf delete {
 *                                 type uint32;
 *                             }
 *                             leaf setup {
 *                                 type uint32;
 *                             }
 *                             uses tlv;
 *                         }
 *                         uses vendor-information-tlvs;
 *                         uses order-tlv;
 *                     }
 *                     leaf priority {
 *                         type uint8;
 *                     }
 *                     leaf request-id {
 *                         type request-id;
 *                     }
 *                     leaf reoptimization {
 *                         type boolean;
 *                     }
 *                     leaf bi-directional {
 *                         type boolean;
 *                     }
 *                     leaf loose {
 *                         type boolean;
 *                     }
 *                     leaf path-key {
 *                         type boolean;
 *                     }
 *                     leaf fragmentation {
 *                         type boolean;
 *                     }
 *                     leaf p2mp {
 *                         type boolean;
 *                     }
 *                     leaf ero-compression {
 *                         type boolean;
 *                     }
 *                     leaf supply-of {
 *                         type boolean;
 *                     }
 *                     leaf order {
 *                         type boolean;
 *                     }
 *                     leaf make-before-break {
 *                         type boolean;
 *                     }
 *                     uses object;
 *                 }
 *                 uses rp-object;
 *             }
 *             list notifications {
 *                 key     container c-notification {
 *                     leaf processing-rule {
 *                         type boolean;
 *                     }
 *                     leaf ignore {
 *                         type boolean;
 *                     }
 *                     container tlvs {
 *                         container overload-duration {
 *                             leaf duration {
 *                                 type uint32;
 *                             }
 *                             uses tlv;
 *                         }
 *                         list vendor-information-tlv {
 *                             key     leaf enterprise-number {
 *                                 type enterprise-number;
 *                             }
 *                             choice enterprise-specific-information {
 *                             }
 *                             uses vendor-information;
 *                             uses tlv;
 *                         }
 *                         uses overload-duration-tlv;
 *                         uses vendor-information-tlvs;
 *                     }
 *                     leaf type {
 *                         type uint8;
 *                     }
 *                     leaf value {
 *                         type uint8;
 *                     }
 *                     uses object;
 *                 }
 *                 uses notification-object;
 *             }
 *         }
 *         uses message-header;
 *     }
 *     uses pcntf-message;
 *     status CURRENT;
 * }
 * notification pcrep {
 *     container pcrep-message {
 *         leaf version {
 *             type protocol-version;
 *         }
 *         list replies {
 *             key     list vendor-information-object {
 *                 key     leaf processing-rule {
 *                     type boolean;
 *                 }
 *                 leaf ignore {
 *                     type boolean;
 *                 }
 *                 leaf enterprise-number {
 *                     type enterprise-number;
 *                 }
 *                 choice enterprise-specific-information {
 *                 }
 *                 uses object;
 *                 uses vendor-information;
 *             }
 *             container rp {
 *                 leaf processing-rule {
 *                     type boolean;
 *                 }
 *                 leaf ignore {
 *                     type boolean;
 *                 }
 *                 container tlvs {
 *                     list vendor-information-tlv {
 *                         key     leaf enterprise-number {
 *                             type enterprise-number;
 *                         }
 *                         choice enterprise-specific-information {
 *                         }
 *                         uses vendor-information;
 *                         uses tlv;
 *                     }
 *                     container order {
 *                         leaf delete {
 *                             type uint32;
 *                         }
 *                         leaf setup {
 *                             type uint32;
 *                         }
 *                         uses tlv;
 *                     }
 *                     uses vendor-information-tlvs;
 *                     uses order-tlv;
 *                 }
 *                 leaf priority {
 *                     type uint8;
 *                 }
 *                 leaf request-id {
 *                     type request-id;
 *                 }
 *                 leaf reoptimization {
 *                     type boolean;
 *                 }
 *                 leaf bi-directional {
 *                     type boolean;
 *                 }
 *                 leaf loose {
 *                     type boolean;
 *                 }
 *                 leaf path-key {
 *                     type boolean;
 *                 }
 *                 leaf fragmentation {
 *                     type boolean;
 *                 }
 *                 leaf p2mp {
 *                     type boolean;
 *                 }
 *                 leaf ero-compression {
 *                     type boolean;
 *                 }
 *                 leaf supply-of {
 *                     type boolean;
 *                 }
 *                 leaf order {
 *                     type boolean;
 *                 }
 *                 leaf make-before-break {
 *                     type boolean;
 *                 }
 *                 uses object;
 *             }
 *             choice result {
 *                 case failure-case {
 *                     container no-path {
 *                         leaf processing-rule {
 *                             type boolean;
 *                         }
 *                         leaf ignore {
 *                             type boolean;
 *                         }
 *                         leaf nature-of-issue {
 *                             type uint8;
 *                         }
 *                         leaf unsatisfied-constraints {
 *                             type boolean;
 *                         }
 *                         container tlvs {
 *                             list vendor-information-tlv {
 *                                 key     leaf enterprise-number {
 *                                     type enterprise-number;
 *                                 }
 *                                 choice enterprise-specific-information {
 *                                 }
 *                                 uses vendor-information;
 *                                 uses tlv;
 *                             }
 *                             container no-path-vector {
 *                                 leaf flags {
 *                                     type bits;
 *                                 }
 *                                 uses no-path-vector-tlv;
 *                             }
 *                             uses vendor-information-tlvs;
 *                         }
 *                         uses no-path-object;
 *                     }
 *                     container lspa {
 *                         leaf processing-rule {
 *                             type boolean;
 *                         }
 *                         leaf ignore {
 *                             type boolean;
 *                         }
 *                         leaf hold-priority {
 *                             type uint8;
 *                         }
 *                         leaf setup-priority {
 *                             type uint8;
 *                         }
 *                         leaf local-protection-desired {
 *                             type boolean;
 *                         }
 *                         leaf include-any {
 *                             type attribute-filter;
 *                         }
 *                         leaf exclude-any {
 *                             type attribute-filter;
 *                         }
 *                         leaf include-all {
 *                             type attribute-filter;
 *                         }
 *                         container tlvs {
 *                             list vendor-information-tlv {
 *                                 key     leaf enterprise-number {
 *                                     type enterprise-number;
 *                                 }
 *                                 choice enterprise-specific-information {
 *                                 }
 *                                 uses vendor-information;
 *                                 uses tlv;
 *                             }
 *                             uses vendor-information-tlvs;
 *                         }
 *                         uses tunnel-attributes;
 *                         uses object;
 *                     }
 *                     container bandwidth {
 *                         leaf processing-rule {
 *                             type boolean;
 *                         }
 *                         leaf ignore {
 *                             type boolean;
 *                         }
 *                         leaf bandwidth {
 *                             type bandwidth;
 *                         }
 *                         uses object;
 *                     }
 *                     list metrics {
 *                         key     container metric {
 *                             leaf processing-rule {
 *                                 type boolean;
 *                             }
 *                             leaf ignore {
 *                                 type boolean;
 *                             }
 *                             leaf metric-type {
 *                                 type uint8;
 *                             }
 *                             leaf bound {
 *                                 type boolean;
 *                             }
 *                             leaf computed {
 *                                 type boolean;
 *                             }
 *                             leaf value {
 *                                 type float32;
 *                             }
 *                             uses object;
 *                         }
 *                         uses metric-object;
 *                     }
 *                     container of {
 *                         leaf processing-rule {
 *                             type boolean;
 *                         }
 *                         leaf ignore {
 *                             type boolean;
 *                         }
 *                         leaf code {
 *                             type of-id;
 *                         }
 *                         container tlvs {
 *                             list vendor-information-tlv {
 *                                 key     leaf enterprise-number {
 *                                     type enterprise-number;
 *                                 }
 *                                 choice enterprise-specific-information {
 *                                 }
 *                                 uses vendor-information;
 *                                 uses tlv;
 *                             }
 *                             uses vendor-information-tlvs;
 *                         }
 *                         uses object;
 *                     }
 *                     container xro {
 *                         leaf processing-rule {
 *                             type boolean;
 *                         }
 *                         leaf ignore {
 *                             type boolean;
 *                         }
 *                         leaf flags {
 *                             type bits;
 *                         }
 *                         list subobject {
 *                             key     leaf mandatory {
 *                                 type boolean;
 *                             }
 *                             leaf attribute {
 *                                 type enumeration;
 *                             }
 *                             choice subobject-type {
 *                                 case as-number-case {
 *                                     container as-number {
 *                                         leaf as-number {
 *                                             type as-number;
 *                                         }
 *                                         uses as-number-subobject;
 *                                     }
 *                                 }
 *                                 case ip-prefix-case {
 *                                     container ip-prefix {
 *                                         leaf ip-prefix {
 *                                             type ip-prefix;
 *                                         }
 *                                         uses ip-prefix-subobject;
 *                                     }
 *                                 }
 *                                 case label-case {
 *                                     container label {
 *                                         leaf uni-directional {
 *                                             type boolean;
 *                                         }
 *                                         choice label-type {
 *                                             case generalized-label-case {
 *                                                 container generalized-label {
 *                                                     leaf generalized-label {
 *                                                         type binary;
 *                                                     }
 *                                                     uses generalized-label;
 *                                                 }
 *                                             }
 *                                             case type1-label-case {
 *                                                 container type1-label {
 *                                                     leaf type1-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses type1-label;
 *                                                 }
 *                                             }
 *                                             case waveband-switching-label-case {
 *                                                 container waveband-switching-label {
 *                                                     leaf end-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf start-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf waveband-id {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses waveband-switching-label;
 *                                                 }
 *                                             }
 *                                         }
 *                                         uses label-subobject;
 *                                     }
 *                                 }
 *                                 case srlg-case {
 *                                     container srlg {
 *                                         leaf srlg-id {
 *                                             type srlg-id;
 *                                         }
 *                                         uses srlg-subobject;
 *                                     }
 *                                 }
 *                                 case unnumbered-case {
 *                                     container unnumbered {
 *                                         leaf router-id {
 *                                             type uint32;
 *                                         }
 *                                         leaf interface-id {
 *                                             type uint32;
 *                                         }
 *                                         uses unnumbered-subobject;
 *                                     }
 *                                 }
 *                             }
 *                             uses exclude-route-subobjects;
 *                         }
 *                         uses object;
 *                     }
 *                     container class-type {
 *                         leaf processing-rule {
 *                             type boolean;
 *                         }
 *                         leaf ignore {
 *                             type boolean;
 *                         }
 *                         leaf class-type {
 *                             type class-type;
 *                         }
 *                         uses object;
 *                     }
 *                     container iro {
 *                         leaf processing-rule {
 *                             type boolean;
 *                         }
 *                         leaf ignore {
 *                             type boolean;
 *                         }
 *                         list subobject {
 *                             key     choice subobject-type {
 *                                 case as-number-case {
 *                                     container as-number {
 *                                         leaf as-number {
 *                                             type as-number;
 *                                         }
 *                                         uses as-number-subobject;
 *                                     }
 *                                 }
 *                                 case exrs-case {
 *                                     container exrs {
 *                                         list exrs {
 *                                             key     leaf mandatory {
 *                                                 type boolean;
 *                                             }
 *                                             leaf attribute {
 *                                                 type enumeration;
 *                                             }
 *                                             choice subobject-type {
 *                                                 case as-number-case {
 *                                                     container as-number {
 *                                                         leaf as-number {
 *                                                             type as-number;
 *                                                         }
 *                                                         uses as-number-subobject;
 *                                                     }
 *                                                 }
 *                                                 case ip-prefix-case {
 *                                                     container ip-prefix {
 *                                                         leaf ip-prefix {
 *                                                             type ip-prefix;
 *                                                         }
 *                                                         uses ip-prefix-subobject;
 *                                                     }
 *                                                 }
 *                                                 case label-case {
 *                                                     container label {
 *                                                         leaf uni-directional {
 *                                                             type boolean;
 *                                                         }
 *                                                         choice label-type {
 *                                                             case generalized-label-case {
 *                                                                 container generalized-label {
 *                                                                     leaf generalized-label {
 *                                                                         type binary;
 *                                                                     }
 *                                                                     uses generalized-label;
 *                                                                 }
 *                                                             }
 *                                                             case type1-label-case {
 *                                                                 container type1-label {
 *                                                                     leaf type1-label {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     uses type1-label;
 *                                                                 }
 *                                                             }
 *                                                             case waveband-switching-label-case {
 *                                                                 container waveband-switching-label {
 *                                                                     leaf end-label {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     leaf start-label {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     leaf waveband-id {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     uses waveband-switching-label;
 *                                                                 }
 *                                                             }
 *                                                         }
 *                                                         uses label-subobject;
 *                                                     }
 *                                                 }
 *                                                 case srlg-case {
 *                                                     container srlg {
 *                                                         leaf srlg-id {
 *                                                             type srlg-id;
 *                                                         }
 *                                                         uses srlg-subobject;
 *                                                     }
 *                                                 }
 *                                                 case unnumbered-case {
 *                                                     container unnumbered {
 *                                                         leaf router-id {
 *                                                             type uint32;
 *                                                         }
 *                                                         leaf interface-id {
 *                                                             type uint32;
 *                                                         }
 *                                                         uses unnumbered-subobject;
 *                                                     }
 *                                                 }
 *                                             }
 *                                             uses exclude-route-subobjects;
 *                                         }
 *                                     }
 *                                 }
 *                                 case ip-prefix-case {
 *                                     container ip-prefix {
 *                                         leaf ip-prefix {
 *                                             type ip-prefix;
 *                                         }
 *                                         uses ip-prefix-subobject;
 *                                     }
 *                                 }
 *                                 case label-case {
 *                                     container label {
 *                                         leaf uni-directional {
 *                                             type boolean;
 *                                         }
 *                                         choice label-type {
 *                                             case generalized-label-case {
 *                                                 container generalized-label {
 *                                                     leaf generalized-label {
 *                                                         type binary;
 *                                                     }
 *                                                     uses generalized-label;
 *                                                 }
 *                                             }
 *                                             case type1-label-case {
 *                                                 container type1-label {
 *                                                     leaf type1-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses type1-label;
 *                                                 }
 *                                             }
 *                                             case waveband-switching-label-case {
 *                                                 container waveband-switching-label {
 *                                                     leaf end-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf start-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf waveband-id {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses waveband-switching-label;
 *                                                 }
 *                                             }
 *                                         }
 *                                         uses label-subobject;
 *                                     }
 *                                 }
 *                                 case srlg-case {
 *                                     container srlg {
 *                                         leaf srlg-id {
 *                                             type srlg-id;
 *                                         }
 *                                         uses srlg-subobject;
 *                                     }
 *                                 }
 *                                 case unnumbered-case {
 *                                     container unnumbered {
 *                                         leaf router-id {
 *                                             type uint32;
 *                                         }
 *                                         leaf interface-id {
 *                                             type uint32;
 *                                         }
 *                                         uses unnumbered-subobject;
 *                                     }
 *                                 }
 *                             }
 *                             uses explicit-route-subobjects;
 *                         }
 *                         uses object;
 *                     }
 *                     container rro {
 *                         leaf processing-rule {
 *                             type boolean;
 *                         }
 *                         leaf ignore {
 *                             type boolean;
 *                         }
 *                         list subobject {
 *                             key     leaf protection-available {
 *                                 type boolean;
 *                             }
 *                             leaf protection-in-use {
 *                                 type boolean;
 *                             }
 *                             choice subobject-type {
 *                                 case ip-prefix-case {
 *                                     container ip-prefix {
 *                                         leaf ip-prefix {
 *                                             type ip-prefix;
 *                                         }
 *                                         uses ip-prefix-subobject;
 *                                     }
 *                                 }
 *                                 case label-case {
 *                                     container label {
 *                                         leaf uni-directional {
 *                                             type boolean;
 *                                         }
 *                                         choice label-type {
 *                                             case generalized-label-case {
 *                                                 container generalized-label {
 *                                                     leaf generalized-label {
 *                                                         type binary;
 *                                                     }
 *                                                     uses generalized-label;
 *                                                 }
 *                                             }
 *                                             case type1-label-case {
 *                                                 container type1-label {
 *                                                     leaf type1-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses type1-label;
 *                                                 }
 *                                             }
 *                                             case waveband-switching-label-case {
 *                                                 container waveband-switching-label {
 *                                                     leaf end-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf start-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf waveband-id {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses waveband-switching-label;
 *                                                 }
 *                                             }
 *                                         }
 *                                         leaf global {
 *                                             type boolean;
 *                                         }
 *                                         uses label-subobject;
 *                                     }
 *                                 }
 *                                 case path-key-case {
 *                                     container path-key {
 *                                         leaf pce-id {
 *                                             type pce-id;
 *                                         }
 *                                         leaf path-key {
 *                                             type path-key;
 *                                         }
 *                                         uses path-key-subobject;
 *                                     }
 *                                 }
 *                                 case unnumbered-case {
 *                                     container unnumbered {
 *                                         leaf router-id {
 *                                             type uint32;
 *                                         }
 *                                         leaf interface-id {
 *                                             type uint32;
 *                                         }
 *                                         uses unnumbered-subobject;
 *                                     }
 *                                 }
 *                             }
 *                             uses record-route-subobjects;
 *                         }
 *                         uses object;
 *                     }
 *                 }
 *                 case success-case {
 *                     container success {
 *                         list paths {
 *                             key     container lspa {
 *                                 leaf processing-rule {
 *                                     type boolean;
 *                                 }
 *                                 leaf ignore {
 *                                     type boolean;
 *                                 }
 *                                 leaf hold-priority {
 *                                     type uint8;
 *                                 }
 *                                 leaf setup-priority {
 *                                     type uint8;
 *                                 }
 *                                 leaf local-protection-desired {
 *                                     type boolean;
 *                                 }
 *                                 leaf include-any {
 *                                     type attribute-filter;
 *                                 }
 *                                 leaf exclude-any {
 *                                     type attribute-filter;
 *                                 }
 *                                 leaf include-all {
 *                                     type attribute-filter;
 *                                 }
 *                                 container tlvs {
 *                                     list vendor-information-tlv {
 *                                         key     leaf enterprise-number {
 *                                             type enterprise-number;
 *                                         }
 *                                         choice enterprise-specific-information {
 *                                         }
 *                                         uses vendor-information;
 *                                         uses tlv;
 *                                     }
 *                                     uses vendor-information-tlvs;
 *                                 }
 *                                 uses tunnel-attributes;
 *                                 uses object;
 *                             }
 *                             container bandwidth {
 *                                 leaf processing-rule {
 *                                     type boolean;
 *                                 }
 *                                 leaf ignore {
 *                                     type boolean;
 *                                 }
 *                                 leaf bandwidth {
 *                                     type bandwidth;
 *                                 }
 *                                 uses object;
 *                             }
 *                             list metrics {
 *                                 key     container metric {
 *                                     leaf processing-rule {
 *                                         type boolean;
 *                                     }
 *                                     leaf ignore {
 *                                         type boolean;
 *                                     }
 *                                     leaf metric-type {
 *                                         type uint8;
 *                                     }
 *                                     leaf bound {
 *                                         type boolean;
 *                                     }
 *                                     leaf computed {
 *                                         type boolean;
 *                                     }
 *                                     leaf value {
 *                                         type float32;
 *                                     }
 *                                     uses object;
 *                                 }
 *                                 uses metric-object;
 *                             }
 *                             container of {
 *                                 leaf processing-rule {
 *                                     type boolean;
 *                                 }
 *                                 leaf ignore {
 *                                     type boolean;
 *                                 }
 *                                 leaf code {
 *                                     type of-id;
 *                                 }
 *                                 container tlvs {
 *                                     list vendor-information-tlv {
 *                                         key     leaf enterprise-number {
 *                                             type enterprise-number;
 *                                         }
 *                                         choice enterprise-specific-information {
 *                                         }
 *                                         uses vendor-information;
 *                                         uses tlv;
 *                                     }
 *                                     uses vendor-information-tlvs;
 *                                 }
 *                                 uses object;
 *                             }
 *                             container xro {
 *                                 leaf processing-rule {
 *                                     type boolean;
 *                                 }
 *                                 leaf ignore {
 *                                     type boolean;
 *                                 }
 *                                 leaf flags {
 *                                     type bits;
 *                                 }
 *                                 list subobject {
 *                                     key     leaf mandatory {
 *                                         type boolean;
 *                                     }
 *                                     leaf attribute {
 *                                         type enumeration;
 *                                     }
 *                                     choice subobject-type {
 *                                         case as-number-case {
 *                                             container as-number {
 *                                                 leaf as-number {
 *                                                     type as-number;
 *                                                 }
 *                                                 uses as-number-subobject;
 *                                             }
 *                                         }
 *                                         case ip-prefix-case {
 *                                             container ip-prefix {
 *                                                 leaf ip-prefix {
 *                                                     type ip-prefix;
 *                                                 }
 *                                                 uses ip-prefix-subobject;
 *                                             }
 *                                         }
 *                                         case label-case {
 *                                             container label {
 *                                                 leaf uni-directional {
 *                                                     type boolean;
 *                                                 }
 *                                                 choice label-type {
 *                                                     case generalized-label-case {
 *                                                         container generalized-label {
 *                                                             leaf generalized-label {
 *                                                                 type binary;
 *                                                             }
 *                                                             uses generalized-label;
 *                                                         }
 *                                                     }
 *                                                     case type1-label-case {
 *                                                         container type1-label {
 *                                                             leaf type1-label {
 *                                                                 type uint32;
 *                                                             }
 *                                                             uses type1-label;
 *                                                         }
 *                                                     }
 *                                                     case waveband-switching-label-case {
 *                                                         container waveband-switching-label {
 *                                                             leaf end-label {
 *                                                                 type uint32;
 *                                                             }
 *                                                             leaf start-label {
 *                                                                 type uint32;
 *                                                             }
 *                                                             leaf waveband-id {
 *                                                                 type uint32;
 *                                                             }
 *                                                             uses waveband-switching-label;
 *                                                         }
 *                                                     }
 *                                                 }
 *                                                 uses label-subobject;
 *                                             }
 *                                         }
 *                                         case srlg-case {
 *                                             container srlg {
 *                                                 leaf srlg-id {
 *                                                     type srlg-id;
 *                                                 }
 *                                                 uses srlg-subobject;
 *                                             }
 *                                         }
 *                                         case unnumbered-case {
 *                                             container unnumbered {
 *                                                 leaf router-id {
 *                                                     type uint32;
 *                                                 }
 *                                                 leaf interface-id {
 *                                                     type uint32;
 *                                                 }
 *                                                 uses unnumbered-subobject;
 *                                             }
 *                                         }
 *                                     }
 *                                     uses exclude-route-subobjects;
 *                                 }
 *                                 uses object;
 *                             }
 *                             container class-type {
 *                                 leaf processing-rule {
 *                                     type boolean;
 *                                 }
 *                                 leaf ignore {
 *                                     type boolean;
 *                                 }
 *                                 leaf class-type {
 *                                     type class-type;
 *                                 }
 *                                 uses object;
 *                             }
 *                             container iro {
 *                                 leaf processing-rule {
 *                                     type boolean;
 *                                 }
 *                                 leaf ignore {
 *                                     type boolean;
 *                                 }
 *                                 list subobject {
 *                                     key     choice subobject-type {
 *                                         case as-number-case {
 *                                             container as-number {
 *                                                 leaf as-number {
 *                                                     type as-number;
 *                                                 }
 *                                                 uses as-number-subobject;
 *                                             }
 *                                         }
 *                                         case exrs-case {
 *                                             container exrs {
 *                                                 list exrs {
 *                                                     key     leaf mandatory {
 *                                                         type boolean;
 *                                                     }
 *                                                     leaf attribute {
 *                                                         type enumeration;
 *                                                     }
 *                                                     choice subobject-type {
 *                                                         case as-number-case {
 *                                                             container as-number {
 *                                                                 leaf as-number {
 *                                                                     type as-number;
 *                                                                 }
 *                                                                 uses as-number-subobject;
 *                                                             }
 *                                                         }
 *                                                         case ip-prefix-case {
 *                                                             container ip-prefix {
 *                                                                 leaf ip-prefix {
 *                                                                     type ip-prefix;
 *                                                                 }
 *                                                                 uses ip-prefix-subobject;
 *                                                             }
 *                                                         }
 *                                                         case label-case {
 *                                                             container label {
 *                                                                 leaf uni-directional {
 *                                                                     type boolean;
 *                                                                 }
 *                                                                 choice label-type {
 *                                                                     case generalized-label-case {
 *                                                                         container generalized-label {
 *                                                                             leaf generalized-label {
 *                                                                                 type binary;
 *                                                                             }
 *                                                                             uses generalized-label;
 *                                                                         }
 *                                                                     }
 *                                                                     case type1-label-case {
 *                                                                         container type1-label {
 *                                                                             leaf type1-label {
 *                                                                                 type uint32;
 *                                                                             }
 *                                                                             uses type1-label;
 *                                                                         }
 *                                                                     }
 *                                                                     case waveband-switching-label-case {
 *                                                                         container waveband-switching-label {
 *                                                                             leaf end-label {
 *                                                                                 type uint32;
 *                                                                             }
 *                                                                             leaf start-label {
 *                                                                                 type uint32;
 *                                                                             }
 *                                                                             leaf waveband-id {
 *                                                                                 type uint32;
 *                                                                             }
 *                                                                             uses waveband-switching-label;
 *                                                                         }
 *                                                                     }
 *                                                                 }
 *                                                                 uses label-subobject;
 *                                                             }
 *                                                         }
 *                                                         case srlg-case {
 *                                                             container srlg {
 *                                                                 leaf srlg-id {
 *                                                                     type srlg-id;
 *                                                                 }
 *                                                                 uses srlg-subobject;
 *                                                             }
 *                                                         }
 *                                                         case unnumbered-case {
 *                                                             container unnumbered {
 *                                                                 leaf router-id {
 *                                                                     type uint32;
 *                                                                 }
 *                                                                 leaf interface-id {
 *                                                                     type uint32;
 *                                                                 }
 *                                                                 uses unnumbered-subobject;
 *                                                             }
 *                                                         }
 *                                                     }
 *                                                     uses exclude-route-subobjects;
 *                                                 }
 *                                             }
 *                                         }
 *                                         case ip-prefix-case {
 *                                             container ip-prefix {
 *                                                 leaf ip-prefix {
 *                                                     type ip-prefix;
 *                                                 }
 *                                                 uses ip-prefix-subobject;
 *                                             }
 *                                         }
 *                                         case label-case {
 *                                             container label {
 *                                                 leaf uni-directional {
 *                                                     type boolean;
 *                                                 }
 *                                                 choice label-type {
 *                                                     case generalized-label-case {
 *                                                         container generalized-label {
 *                                                             leaf generalized-label {
 *                                                                 type binary;
 *                                                             }
 *                                                             uses generalized-label;
 *                                                         }
 *                                                     }
 *                                                     case type1-label-case {
 *                                                         container type1-label {
 *                                                             leaf type1-label {
 *                                                                 type uint32;
 *                                                             }
 *                                                             uses type1-label;
 *                                                         }
 *                                                     }
 *                                                     case waveband-switching-label-case {
 *                                                         container waveband-switching-label {
 *                                                             leaf end-label {
 *                                                                 type uint32;
 *                                                             }
 *                                                             leaf start-label {
 *                                                                 type uint32;
 *                                                             }
 *                                                             leaf waveband-id {
 *                                                                 type uint32;
 *                                                             }
 *                                                             uses waveband-switching-label;
 *                                                         }
 *                                                     }
 *                                                 }
 *                                                 uses label-subobject;
 *                                             }
 *                                         }
 *                                         case srlg-case {
 *                                             container srlg {
 *                                                 leaf srlg-id {
 *                                                     type srlg-id;
 *                                                 }
 *                                                 uses srlg-subobject;
 *                                             }
 *                                         }
 *                                         case unnumbered-case {
 *                                             container unnumbered {
 *                                                 leaf router-id {
 *                                                     type uint32;
 *                                                 }
 *                                                 leaf interface-id {
 *                                                     type uint32;
 *                                                 }
 *                                                 uses unnumbered-subobject;
 *                                             }
 *                                         }
 *                                     }
 *                                     uses explicit-route-subobjects;
 *                                 }
 *                                 uses object;
 *                             }
 *                             container rro {
 *                                 leaf processing-rule {
 *                                     type boolean;
 *                                 }
 *                                 leaf ignore {
 *                                     type boolean;
 *                                 }
 *                                 list subobject {
 *                                     key     leaf protection-available {
 *                                         type boolean;
 *                                     }
 *                                     leaf protection-in-use {
 *                                         type boolean;
 *                                     }
 *                                     choice subobject-type {
 *                                         case ip-prefix-case {
 *                                             container ip-prefix {
 *                                                 leaf ip-prefix {
 *                                                     type ip-prefix;
 *                                                 }
 *                                                 uses ip-prefix-subobject;
 *                                             }
 *                                         }
 *                                         case label-case {
 *                                             container label {
 *                                                 leaf uni-directional {
 *                                                     type boolean;
 *                                                 }
 *                                                 choice label-type {
 *                                                     case generalized-label-case {
 *                                                         container generalized-label {
 *                                                             leaf generalized-label {
 *                                                                 type binary;
 *                                                             }
 *                                                             uses generalized-label;
 *                                                         }
 *                                                     }
 *                                                     case type1-label-case {
 *                                                         container type1-label {
 *                                                             leaf type1-label {
 *                                                                 type uint32;
 *                                                             }
 *                                                             uses type1-label;
 *                                                         }
 *                                                     }
 *                                                     case waveband-switching-label-case {
 *                                                         container waveband-switching-label {
 *                                                             leaf end-label {
 *                                                                 type uint32;
 *                                                             }
 *                                                             leaf start-label {
 *                                                                 type uint32;
 *                                                             }
 *                                                             leaf waveband-id {
 *                                                                 type uint32;
 *                                                             }
 *                                                             uses waveband-switching-label;
 *                                                         }
 *                                                     }
 *                                                 }
 *                                                 leaf global {
 *                                                     type boolean;
 *                                                 }
 *                                                 uses label-subobject;
 *                                             }
 *                                         }
 *                                         case path-key-case {
 *                                             container path-key {
 *                                                 leaf pce-id {
 *                                                     type pce-id;
 *                                                 }
 *                                                 leaf path-key {
 *                                                     type path-key;
 *                                                 }
 *                                                 uses path-key-subobject;
 *                                             }
 *                                         }
 *                                         case unnumbered-case {
 *                                             container unnumbered {
 *                                                 leaf router-id {
 *                                                     type uint32;
 *                                                 }
 *                                                 leaf interface-id {
 *                                                     type uint32;
 *                                                 }
 *                                                 uses unnumbered-subobject;
 *                                             }
 *                                         }
 *                                     }
 *                                     uses record-route-subobjects;
 *                                 }
 *                                 uses object;
 *                             }
 *                             container ero {
 *                                 leaf processing-rule {
 *                                     type boolean;
 *                                 }
 *                                 leaf ignore {
 *                                     type boolean;
 *                                 }
 *                                 list subobject {
 *                                     key     leaf loose {
 *                                         type boolean;
 *                                     }
 *                                     choice subobject-type {
 *                                         case as-number-case {
 *                                             container as-number {
 *                                                 leaf as-number {
 *                                                     type as-number;
 *                                                 }
 *                                                 uses as-number-subobject;
 *                                             }
 *                                         }
 *                                         case exrs-case {
 *                                             container exrs {
 *                                                 list exrs {
 *                                                     key     leaf mandatory {
 *                                                         type boolean;
 *                                                     }
 *                                                     leaf attribute {
 *                                                         type enumeration;
 *                                                     }
 *                                                     choice subobject-type {
 *                                                         case as-number-case {
 *                                                             container as-number {
 *                                                                 leaf as-number {
 *                                                                     type as-number;
 *                                                                 }
 *                                                                 uses as-number-subobject;
 *                                                             }
 *                                                         }
 *                                                         case ip-prefix-case {
 *                                                             container ip-prefix {
 *                                                                 leaf ip-prefix {
 *                                                                     type ip-prefix;
 *                                                                 }
 *                                                                 uses ip-prefix-subobject;
 *                                                             }
 *                                                         }
 *                                                         case label-case {
 *                                                             container label {
 *                                                                 leaf uni-directional {
 *                                                                     type boolean;
 *                                                                 }
 *                                                                 choice label-type {
 *                                                                     case generalized-label-case {
 *                                                                         container generalized-label {
 *                                                                             leaf generalized-label {
 *                                                                                 type binary;
 *                                                                             }
 *                                                                             uses generalized-label;
 *                                                                         }
 *                                                                     }
 *                                                                     case type1-label-case {
 *                                                                         container type1-label {
 *                                                                             leaf type1-label {
 *                                                                                 type uint32;
 *                                                                             }
 *                                                                             uses type1-label;
 *                                                                         }
 *                                                                     }
 *                                                                     case waveband-switching-label-case {
 *                                                                         container waveband-switching-label {
 *                                                                             leaf end-label {
 *                                                                                 type uint32;
 *                                                                             }
 *                                                                             leaf start-label {
 *                                                                                 type uint32;
 *                                                                             }
 *                                                                             leaf waveband-id {
 *                                                                                 type uint32;
 *                                                                             }
 *                                                                             uses waveband-switching-label;
 *                                                                         }
 *                                                                     }
 *                                                                 }
 *                                                                 uses label-subobject;
 *                                                             }
 *                                                         }
 *                                                         case srlg-case {
 *                                                             container srlg {
 *                                                                 leaf srlg-id {
 *                                                                     type srlg-id;
 *                                                                 }
 *                                                                 uses srlg-subobject;
 *                                                             }
 *                                                         }
 *                                                         case unnumbered-case {
 *                                                             container unnumbered {
 *                                                                 leaf router-id {
 *                                                                     type uint32;
 *                                                                 }
 *                                                                 leaf interface-id {
 *                                                                     type uint32;
 *                                                                 }
 *                                                                 uses unnumbered-subobject;
 *                                                             }
 *                                                         }
 *                                                     }
 *                                                     uses exclude-route-subobjects;
 *                                                 }
 *                                             }
 *                                         }
 *                                         case ip-prefix-case {
 *                                             container ip-prefix {
 *                                                 leaf ip-prefix {
 *                                                     type ip-prefix;
 *                                                 }
 *                                                 uses ip-prefix-subobject;
 *                                             }
 *                                         }
 *                                         case label-case {
 *                                             container label {
 *                                                 leaf uni-directional {
 *                                                     type boolean;
 *                                                 }
 *                                                 choice label-type {
 *                                                     case generalized-label-case {
 *                                                         container generalized-label {
 *                                                             leaf generalized-label {
 *                                                                 type binary;
 *                                                             }
 *                                                             uses generalized-label;
 *                                                         }
 *                                                     }
 *                                                     case type1-label-case {
 *                                                         container type1-label {
 *                                                             leaf type1-label {
 *                                                                 type uint32;
 *                                                             }
 *                                                             uses type1-label;
 *                                                         }
 *                                                     }
 *                                                     case waveband-switching-label-case {
 *                                                         container waveband-switching-label {
 *                                                             leaf end-label {
 *                                                                 type uint32;
 *                                                             }
 *                                                             leaf start-label {
 *                                                                 type uint32;
 *                                                             }
 *                                                             leaf waveband-id {
 *                                                                 type uint32;
 *                                                             }
 *                                                             uses waveband-switching-label;
 *                                                         }
 *                                                     }
 *                                                 }
 *                                                 uses label-subobject;
 *                                             }
 *                                         }
 *                                         case path-key-case {
 *                                             container path-key {
 *                                                 leaf pce-id {
 *                                                     type pce-id;
 *                                                 }
 *                                                 leaf path-key {
 *                                                     type path-key;
 *                                                 }
 *                                                 uses path-key-subobject;
 *                                             }
 *                                         }
 *                                         case srlg-case {
 *                                             container srlg {
 *                                                 leaf srlg-id {
 *                                                     type srlg-id;
 *                                                 }
 *                                                 uses srlg-subobject;
 *                                             }
 *                                         }
 *                                         case unnumbered-case {
 *                                             container unnumbered {
 *                                                 leaf router-id {
 *                                                     type uint32;
 *                                                 }
 *                                                 leaf interface-id {
 *                                                     type uint32;
 *                                                 }
 *                                                 uses unnumbered-subobject;
 *                                             }
 *                                         }
 *                                     }
 *                                     uses explicit-route-subobjects;
 *                                 }
 *                                 uses object;
 *                             }
 *                             uses path-definition;
 *                         }
 *                         list vendor-information-object {
 *                             key     leaf processing-rule {
 *                                 type boolean;
 *                             }
 *                             leaf ignore {
 *                                 type boolean;
 *                             }
 *                             leaf enterprise-number {
 *                                 type enterprise-number;
 *                             }
 *                             choice enterprise-specific-information {
 *                             }
 *                             uses object;
 *                             uses vendor-information;
 *                         }
 *                         uses vendor-information-objects;
 *                     }
 *                 }
 *             }
 *             uses vendor-information-objects;
 *             uses rp-object;
 *         }
 *         uses message-header;
 *     }
 *     uses pcrep-message;
 *     status CURRENT;
 * }
 * notification pcreq {
 *     container pcreq-message {
 *         leaf version {
 *             type protocol-version;
 *         }
 *         list requests {
 *             key     container rp {
 *                 leaf processing-rule {
 *                     type boolean;
 *                 }
 *                 leaf ignore {
 *                     type boolean;
 *                 }
 *                 container tlvs {
 *                     list vendor-information-tlv {
 *                         key     leaf enterprise-number {
 *                             type enterprise-number;
 *                         }
 *                         choice enterprise-specific-information {
 *                         }
 *                         uses vendor-information;
 *                         uses tlv;
 *                     }
 *                     container order {
 *                         leaf delete {
 *                             type uint32;
 *                         }
 *                         leaf setup {
 *                             type uint32;
 *                         }
 *                         uses tlv;
 *                     }
 *                     uses vendor-information-tlvs;
 *                     uses order-tlv;
 *                 }
 *                 leaf priority {
 *                     type uint8;
 *                 }
 *                 leaf request-id {
 *                     type request-id;
 *                 }
 *                 leaf reoptimization {
 *                     type boolean;
 *                 }
 *                 leaf bi-directional {
 *                     type boolean;
 *                 }
 *                 leaf loose {
 *                     type boolean;
 *                 }
 *                 leaf path-key {
 *                     type boolean;
 *                 }
 *                 leaf fragmentation {
 *                     type boolean;
 *                 }
 *                 leaf p2mp {
 *                     type boolean;
 *                 }
 *                 leaf ero-compression {
 *                     type boolean;
 *                 }
 *                 leaf supply-of {
 *                     type boolean;
 *                 }
 *                 leaf order {
 *                     type boolean;
 *                 }
 *                 leaf make-before-break {
 *                     type boolean;
 *                 }
 *                 uses object;
 *             }
 *             container path-key-expansion {
 *                 container path-key {
 *                     leaf processing-rule {
 *                         type boolean;
 *                     }
 *                     leaf ignore {
 *                         type boolean;
 *                     }
 *                     list path-keys {
 *                         key     leaf loose {
 *                             type boolean;
 *                         }
 *                         leaf pce-id {
 *                             type pce-id;
 *                         }
 *                         leaf path-key {
 *                             type path-key;
 *                         }
 *                         uses path-key-subobject;
 *                     }
 *                     uses object;
 *                 }
 *                 uses path-key-object;
 *             }
 *             container segment-computation {
 *                 container p2p {
 *                     container endpoints-obj {
 *                         choice address-family {
 *                             case ipv4-case {
 *                                 container ipv4 {
 *                                     leaf source-ipv4-address {
 *                                         type ipv4-address;
 *                                     }
 *                                     leaf destination-ipv4-address {
 *                                         type ipv4-address;
 *                                     }
 *                                 }
 *                             }
 *                             case ipv6-case {
 *                                 container ipv6 {
 *                                     leaf source-ipv6-address {
 *                                         type ipv6-address;
 *                                     }
 *                                     leaf destination-ipv6-address {
 *                                         type ipv6-address;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         leaf processing-rule {
 *                             type boolean;
 *                         }
 *                         leaf ignore {
 *                             type boolean;
 *                         }
 *                         uses endpoints;
 *                         uses object;
 *                     }
 *                     container reported-route {
 *                         container bandwidth {
 *                             leaf processing-rule {
 *                                 type boolean;
 *                             }
 *                             leaf ignore {
 *                                 type boolean;
 *                             }
 *                             leaf bandwidth {
 *                                 type bandwidth;
 *                             }
 *                             uses object;
 *                         }
 *                         container rro {
 *                             leaf processing-rule {
 *                                 type boolean;
 *                             }
 *                             leaf ignore {
 *                                 type boolean;
 *                             }
 *                             list subobject {
 *                                 key     leaf protection-available {
 *                                     type boolean;
 *                                 }
 *                                 leaf protection-in-use {
 *                                     type boolean;
 *                                 }
 *                                 choice subobject-type {
 *                                     case ip-prefix-case {
 *                                         container ip-prefix {
 *                                             leaf ip-prefix {
 *                                                 type ip-prefix;
 *                                             }
 *                                             uses ip-prefix-subobject;
 *                                         }
 *                                     }
 *                                     case label-case {
 *                                         container label {
 *                                             leaf uni-directional {
 *                                                 type boolean;
 *                                             }
 *                                             choice label-type {
 *                                                 case generalized-label-case {
 *                                                     container generalized-label {
 *                                                         leaf generalized-label {
 *                                                             type binary;
 *                                                         }
 *                                                         uses generalized-label;
 *                                                     }
 *                                                 }
 *                                                 case type1-label-case {
 *                                                     container type1-label {
 *                                                         leaf type1-label {
 *                                                             type uint32;
 *                                                         }
 *                                                         uses type1-label;
 *                                                     }
 *                                                 }
 *                                                 case waveband-switching-label-case {
 *                                                     container waveband-switching-label {
 *                                                         leaf end-label {
 *                                                             type uint32;
 *                                                         }
 *                                                         leaf start-label {
 *                                                             type uint32;
 *                                                         }
 *                                                         leaf waveband-id {
 *                                                             type uint32;
 *                                                         }
 *                                                         uses waveband-switching-label;
 *                                                     }
 *                                                 }
 *                                             }
 *                                             leaf global {
 *                                                 type boolean;
 *                                             }
 *                                             uses label-subobject;
 *                                         }
 *                                     }
 *                                     case path-key-case {
 *                                         container path-key {
 *                                             leaf pce-id {
 *                                                 type pce-id;
 *                                             }
 *                                             leaf path-key {
 *                                                 type path-key;
 *                                             }
 *                                             uses path-key-subobject;
 *                                         }
 *                                     }
 *                                     case unnumbered-case {
 *                                         container unnumbered {
 *                                             leaf router-id {
 *                                                 type uint32;
 *                                             }
 *                                             leaf interface-id {
 *                                                 type uint32;
 *                                             }
 *                                             uses unnumbered-subobject;
 *                                         }
 *                                     }
 *                                 }
 *                                 uses record-route-subobjects;
 *                             }
 *                             uses object;
 *                         }
 *                         uses bandwidth-object;
 *                         uses reported-route-object;
 *                     }
 *                     container lspa {
 *                         leaf processing-rule {
 *                             type boolean;
 *                         }
 *                         leaf ignore {
 *                             type boolean;
 *                         }
 *                         leaf hold-priority {
 *                             type uint8;
 *                         }
 *                         leaf setup-priority {
 *                             type uint8;
 *                         }
 *                         leaf local-protection-desired {
 *                             type boolean;
 *                         }
 *                         leaf include-any {
 *                             type attribute-filter;
 *                         }
 *                         leaf exclude-any {
 *                             type attribute-filter;
 *                         }
 *                         leaf include-all {
 *                             type attribute-filter;
 *                         }
 *                         container tlvs {
 *                             list vendor-information-tlv {
 *                                 key     leaf enterprise-number {
 *                                     type enterprise-number;
 *                                 }
 *                                 choice enterprise-specific-information {
 *                                 }
 *                                 uses vendor-information;
 *                                 uses tlv;
 *                             }
 *                             uses vendor-information-tlvs;
 *                         }
 *                         uses tunnel-attributes;
 *                         uses object;
 *                     }
 *                     container bandwidth {
 *                         leaf processing-rule {
 *                             type boolean;
 *                         }
 *                         leaf ignore {
 *                             type boolean;
 *                         }
 *                         leaf bandwidth {
 *                             type bandwidth;
 *                         }
 *                         uses object;
 *                     }
 *                     list metrics {
 *                         key     container metric {
 *                             leaf processing-rule {
 *                                 type boolean;
 *                             }
 *                             leaf ignore {
 *                                 type boolean;
 *                             }
 *                             leaf metric-type {
 *                                 type uint8;
 *                             }
 *                             leaf bound {
 *                                 type boolean;
 *                             }
 *                             leaf computed {
 *                                 type boolean;
 *                             }
 *                             leaf value {
 *                                 type float32;
 *                             }
 *                             uses object;
 *                         }
 *                         uses metric-object;
 *                     }
 *                     container of {
 *                         leaf processing-rule {
 *                             type boolean;
 *                         }
 *                         leaf ignore {
 *                             type boolean;
 *                         }
 *                         leaf code {
 *                             type of-id;
 *                         }
 *                         container tlvs {
 *                             list vendor-information-tlv {
 *                                 key     leaf enterprise-number {
 *                                     type enterprise-number;
 *                                 }
 *                                 choice enterprise-specific-information {
 *                                 }
 *                                 uses vendor-information;
 *                                 uses tlv;
 *                             }
 *                             uses vendor-information-tlvs;
 *                         }
 *                         uses object;
 *                     }
 *                     container xro {
 *                         leaf processing-rule {
 *                             type boolean;
 *                         }
 *                         leaf ignore {
 *                             type boolean;
 *                         }
 *                         leaf flags {
 *                             type bits;
 *                         }
 *                         list subobject {
 *                             key     leaf mandatory {
 *                                 type boolean;
 *                             }
 *                             leaf attribute {
 *                                 type enumeration;
 *                             }
 *                             choice subobject-type {
 *                                 case as-number-case {
 *                                     container as-number {
 *                                         leaf as-number {
 *                                             type as-number;
 *                                         }
 *                                         uses as-number-subobject;
 *                                     }
 *                                 }
 *                                 case ip-prefix-case {
 *                                     container ip-prefix {
 *                                         leaf ip-prefix {
 *                                             type ip-prefix;
 *                                         }
 *                                         uses ip-prefix-subobject;
 *                                     }
 *                                 }
 *                                 case label-case {
 *                                     container label {
 *                                         leaf uni-directional {
 *                                             type boolean;
 *                                         }
 *                                         choice label-type {
 *                                             case generalized-label-case {
 *                                                 container generalized-label {
 *                                                     leaf generalized-label {
 *                                                         type binary;
 *                                                     }
 *                                                     uses generalized-label;
 *                                                 }
 *                                             }
 *                                             case type1-label-case {
 *                                                 container type1-label {
 *                                                     leaf type1-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses type1-label;
 *                                                 }
 *                                             }
 *                                             case waveband-switching-label-case {
 *                                                 container waveband-switching-label {
 *                                                     leaf end-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf start-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf waveband-id {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses waveband-switching-label;
 *                                                 }
 *                                             }
 *                                         }
 *                                         uses label-subobject;
 *                                     }
 *                                 }
 *                                 case srlg-case {
 *                                     container srlg {
 *                                         leaf srlg-id {
 *                                             type srlg-id;
 *                                         }
 *                                         uses srlg-subobject;
 *                                     }
 *                                 }
 *                                 case unnumbered-case {
 *                                     container unnumbered {
 *                                         leaf router-id {
 *                                             type uint32;
 *                                         }
 *                                         leaf interface-id {
 *                                             type uint32;
 *                                         }
 *                                         uses unnumbered-subobject;
 *                                     }
 *                                 }
 *                             }
 *                             uses exclude-route-subobjects;
 *                         }
 *                         uses object;
 *                     }
 *                     container class-type {
 *                         leaf processing-rule {
 *                             type boolean;
 *                         }
 *                         leaf ignore {
 *                             type boolean;
 *                         }
 *                         leaf class-type {
 *                             type class-type;
 *                         }
 *                         uses object;
 *                     }
 *                     container iro {
 *                         leaf processing-rule {
 *                             type boolean;
 *                         }
 *                         leaf ignore {
 *                             type boolean;
 *                         }
 *                         list subobject {
 *                             key     choice subobject-type {
 *                                 case as-number-case {
 *                                     container as-number {
 *                                         leaf as-number {
 *                                             type as-number;
 *                                         }
 *                                         uses as-number-subobject;
 *                                     }
 *                                 }
 *                                 case exrs-case {
 *                                     container exrs {
 *                                         list exrs {
 *                                             key     leaf mandatory {
 *                                                 type boolean;
 *                                             }
 *                                             leaf attribute {
 *                                                 type enumeration;
 *                                             }
 *                                             choice subobject-type {
 *                                                 case as-number-case {
 *                                                     container as-number {
 *                                                         leaf as-number {
 *                                                             type as-number;
 *                                                         }
 *                                                         uses as-number-subobject;
 *                                                     }
 *                                                 }
 *                                                 case ip-prefix-case {
 *                                                     container ip-prefix {
 *                                                         leaf ip-prefix {
 *                                                             type ip-prefix;
 *                                                         }
 *                                                         uses ip-prefix-subobject;
 *                                                     }
 *                                                 }
 *                                                 case label-case {
 *                                                     container label {
 *                                                         leaf uni-directional {
 *                                                             type boolean;
 *                                                         }
 *                                                         choice label-type {
 *                                                             case generalized-label-case {
 *                                                                 container generalized-label {
 *                                                                     leaf generalized-label {
 *                                                                         type binary;
 *                                                                     }
 *                                                                     uses generalized-label;
 *                                                                 }
 *                                                             }
 *                                                             case type1-label-case {
 *                                                                 container type1-label {
 *                                                                     leaf type1-label {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     uses type1-label;
 *                                                                 }
 *                                                             }
 *                                                             case waveband-switching-label-case {
 *                                                                 container waveband-switching-label {
 *                                                                     leaf end-label {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     leaf start-label {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     leaf waveband-id {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     uses waveband-switching-label;
 *                                                                 }
 *                                                             }
 *                                                         }
 *                                                         uses label-subobject;
 *                                                     }
 *                                                 }
 *                                                 case srlg-case {
 *                                                     container srlg {
 *                                                         leaf srlg-id {
 *                                                             type srlg-id;
 *                                                         }
 *                                                         uses srlg-subobject;
 *                                                     }
 *                                                 }
 *                                                 case unnumbered-case {
 *                                                     container unnumbered {
 *                                                         leaf router-id {
 *                                                             type uint32;
 *                                                         }
 *                                                         leaf interface-id {
 *                                                             type uint32;
 *                                                         }
 *                                                         uses unnumbered-subobject;
 *                                                     }
 *                                                 }
 *                                             }
 *                                             uses exclude-route-subobjects;
 *                                         }
 *                                     }
 *                                 }
 *                                 case ip-prefix-case {
 *                                     container ip-prefix {
 *                                         leaf ip-prefix {
 *                                             type ip-prefix;
 *                                         }
 *                                         uses ip-prefix-subobject;
 *                                     }
 *                                 }
 *                                 case label-case {
 *                                     container label {
 *                                         leaf uni-directional {
 *                                             type boolean;
 *                                         }
 *                                         choice label-type {
 *                                             case generalized-label-case {
 *                                                 container generalized-label {
 *                                                     leaf generalized-label {
 *                                                         type binary;
 *                                                     }
 *                                                     uses generalized-label;
 *                                                 }
 *                                             }
 *                                             case type1-label-case {
 *                                                 container type1-label {
 *                                                     leaf type1-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses type1-label;
 *                                                 }
 *                                             }
 *                                             case waveband-switching-label-case {
 *                                                 container waveband-switching-label {
 *                                                     leaf end-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf start-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf waveband-id {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses waveband-switching-label;
 *                                                 }
 *                                             }
 *                                         }
 *                                         uses label-subobject;
 *                                     }
 *                                 }
 *                                 case srlg-case {
 *                                     container srlg {
 *                                         leaf srlg-id {
 *                                             type srlg-id;
 *                                         }
 *                                         uses srlg-subobject;
 *                                     }
 *                                 }
 *                                 case unnumbered-case {
 *                                     container unnumbered {
 *                                         leaf router-id {
 *                                             type uint32;
 *                                         }
 *                                         leaf interface-id {
 *                                             type uint32;
 *                                         }
 *                                         uses unnumbered-subobject;
 *                                     }
 *                                 }
 *                             }
 *                             uses explicit-route-subobjects;
 *                         }
 *                         uses object;
 *                     }
 *                     container rro {
 *                         leaf processing-rule {
 *                             type boolean;
 *                         }
 *                         leaf ignore {
 *                             type boolean;
 *                         }
 *                         list subobject {
 *                             key     leaf protection-available {
 *                                 type boolean;
 *                             }
 *                             leaf protection-in-use {
 *                                 type boolean;
 *                             }
 *                             choice subobject-type {
 *                                 case ip-prefix-case {
 *                                     container ip-prefix {
 *                                         leaf ip-prefix {
 *                                             type ip-prefix;
 *                                         }
 *                                         uses ip-prefix-subobject;
 *                                     }
 *                                 }
 *                                 case label-case {
 *                                     container label {
 *                                         leaf uni-directional {
 *                                             type boolean;
 *                                         }
 *                                         choice label-type {
 *                                             case generalized-label-case {
 *                                                 container generalized-label {
 *                                                     leaf generalized-label {
 *                                                         type binary;
 *                                                     }
 *                                                     uses generalized-label;
 *                                                 }
 *                                             }
 *                                             case type1-label-case {
 *                                                 container type1-label {
 *                                                     leaf type1-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses type1-label;
 *                                                 }
 *                                             }
 *                                             case waveband-switching-label-case {
 *                                                 container waveband-switching-label {
 *                                                     leaf end-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf start-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf waveband-id {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses waveband-switching-label;
 *                                                 }
 *                                             }
 *                                         }
 *                                         leaf global {
 *                                             type boolean;
 *                                         }
 *                                         uses label-subobject;
 *                                     }
 *                                 }
 *                                 case path-key-case {
 *                                     container path-key {
 *                                         leaf pce-id {
 *                                             type pce-id;
 *                                         }
 *                                         leaf path-key {
 *                                             type path-key;
 *                                         }
 *                                         uses path-key-subobject;
 *                                     }
 *                                 }
 *                                 case unnumbered-case {
 *                                     container unnumbered {
 *                                         leaf router-id {
 *                                             type uint32;
 *                                         }
 *                                         leaf interface-id {
 *                                             type uint32;
 *                                         }
 *                                         uses unnumbered-subobject;
 *                                     }
 *                                 }
 *                             }
 *                             uses record-route-subobjects;
 *                         }
 *                         uses object;
 *                     }
 *                     list vendor-information-object {
 *                         key     leaf processing-rule {
 *                             type boolean;
 *                         }
 *                         leaf ignore {
 *                             type boolean;
 *                         }
 *                         leaf enterprise-number {
 *                             type enterprise-number;
 *                         }
 *                         choice enterprise-specific-information {
 *                         }
 *                         uses object;
 *                         uses vendor-information;
 *                     }
 *                     container load-balancing {
 *                         leaf processing-rule {
 *                             type boolean;
 *                         }
 *                         leaf ignore {
 *                             type boolean;
 *                         }
 *                         leaf max-lsp {
 *                             type uint8;
 *                         }
 *                         leaf min-bandwidth {
 *                             type bandwidth;
 *                         }
 *                         uses object;
 *                     }
 *                     uses load-balancing-object;
 *                     uses vendor-information-objects;
 *                     uses endpoints-object;
 *                     uses lsp-attributes;
 *                 }
 *             }
 *             list vendor-information-object {
 *                 key     leaf processing-rule {
 *                     type boolean;
 *                 }
 *                 leaf ignore {
 *                     type boolean;
 *                 }
 *                 leaf enterprise-number {
 *                     type enterprise-number;
 *                 }
 *                 choice enterprise-specific-information {
 *                 }
 *                 uses object;
 *                 uses vendor-information;
 *             }
 *             uses vendor-information-objects;
 *             uses rp-object;
 *         }
 *         list svec {
 *             key     container svec {
 *                 leaf processing-rule {
 *                     type boolean;
 *                 }
 *                 leaf ignore {
 *                     type boolean;
 *                 }
 *                 leaf link-diverse {
 *                     type boolean;
 *                 }
 *                 leaf node-diverse {
 *                     type boolean;
 *                 }
 *                 leaf srlg-diverse {
 *                     type boolean;
 *                 }
 *                 leaf-list requests-ids {
 *                     type request-id;
 *                 }
 *                 uses object;
 *             }
 *             container xro {
 *                 leaf processing-rule {
 *                     type boolean;
 *                 }
 *                 leaf ignore {
 *                     type boolean;
 *                 }
 *                 leaf flags {
 *                     type bits;
 *                 }
 *                 list subobject {
 *                     key     leaf mandatory {
 *                         type boolean;
 *                     }
 *                     leaf attribute {
 *                         type enumeration;
 *                     }
 *                     choice subobject-type {
 *                         case as-number-case {
 *                             container as-number {
 *                                 leaf as-number {
 *                                     type as-number;
 *                                 }
 *                                 uses as-number-subobject;
 *                             }
 *                         }
 *                         case ip-prefix-case {
 *                             container ip-prefix {
 *                                 leaf ip-prefix {
 *                                     type ip-prefix;
 *                                 }
 *                                 uses ip-prefix-subobject;
 *                             }
 *                         }
 *                         case label-case {
 *                             container label {
 *                                 leaf uni-directional {
 *                                     type boolean;
 *                                 }
 *                                 choice label-type {
 *                                     case generalized-label-case {
 *                                         container generalized-label {
 *                                             leaf generalized-label {
 *                                                 type binary;
 *                                             }
 *                                             uses generalized-label;
 *                                         }
 *                                     }
 *                                     case type1-label-case {
 *                                         container type1-label {
 *                                             leaf type1-label {
 *                                                 type uint32;
 *                                             }
 *                                             uses type1-label;
 *                                         }
 *                                     }
 *                                     case waveband-switching-label-case {
 *                                         container waveband-switching-label {
 *                                             leaf end-label {
 *                                                 type uint32;
 *                                             }
 *                                             leaf start-label {
 *                                                 type uint32;
 *                                             }
 *                                             leaf waveband-id {
 *                                                 type uint32;
 *                                             }
 *                                             uses waveband-switching-label;
 *                                         }
 *                                     }
 *                                 }
 *                                 uses label-subobject;
 *                             }
 *                         }
 *                         case srlg-case {
 *                             container srlg {
 *                                 leaf srlg-id {
 *                                     type srlg-id;
 *                                 }
 *                                 uses srlg-subobject;
 *                             }
 *                         }
 *                         case unnumbered-case {
 *                             container unnumbered {
 *                                 leaf router-id {
 *                                     type uint32;
 *                                 }
 *                                 leaf interface-id {
 *                                     type uint32;
 *                                 }
 *                                 uses unnumbered-subobject;
 *                             }
 *                         }
 *                     }
 *                     uses exclude-route-subobjects;
 *                 }
 *                 uses object;
 *             }
 *             container gc {
 *                 leaf processing-rule {
 *                     type boolean;
 *                 }
 *                 leaf ignore {
 *                     type boolean;
 *                 }
 *                 leaf max-hop {
 *                     type uint8;
 *                 }
 *                 leaf max-utilization {
 *                     type uint8;
 *                 }
 *                 leaf min-utilization {
 *                     type uint8;
 *                 }
 *                 leaf over-booking-factor {
 *                     type uint8;
 *                 }
 *                 container tlvs {
 *                     list vendor-information-tlv {
 *                         key     leaf enterprise-number {
 *                             type enterprise-number;
 *                         }
 *                         choice enterprise-specific-information {
 *                         }
 *                         uses vendor-information;
 *                         uses tlv;
 *                     }
 *                     uses vendor-information-tlvs;
 *                 }
 *                 uses object;
 *             }
 *             container of {
 *                 leaf processing-rule {
 *                     type boolean;
 *                 }
 *                 leaf ignore {
 *                     type boolean;
 *                 }
 *                 leaf code {
 *                     type of-id;
 *                 }
 *                 container tlvs {
 *                     list vendor-information-tlv {
 *                         key     leaf enterprise-number {
 *                             type enterprise-number;
 *                         }
 *                         choice enterprise-specific-information {
 *                         }
 *                         uses vendor-information;
 *                         uses tlv;
 *                     }
 *                     uses vendor-information-tlvs;
 *                 }
 *                 uses object;
 *             }
 *             list metric {
 *                 key     container metric {
 *                     leaf processing-rule {
 *                         type boolean;
 *                     }
 *                     leaf ignore {
 *                         type boolean;
 *                     }
 *                     leaf metric-type {
 *                         type uint8;
 *                     }
 *                     leaf bound {
 *                         type boolean;
 *                     }
 *                     leaf computed {
 *                         type boolean;
 *                     }
 *                     leaf value {
 *                         type float32;
 *                     }
 *                     uses object;
 *                 }
 *                 uses metric-object;
 *             }
 *             list vendor-information-object {
 *                 key     leaf processing-rule {
 *                     type boolean;
 *                 }
 *                 leaf ignore {
 *                     type boolean;
 *                 }
 *                 leaf enterprise-number {
 *                     type enterprise-number;
 *                 }
 *                 choice enterprise-specific-information {
 *                 }
 *                 uses object;
 *                 uses vendor-information;
 *             }
 *             uses vendor-information-objects;
 *             uses svec-object;
 *             uses exclude-route-object;
 *             uses of-object;
 *             uses gc-object;
 *         }
 *         uses message-header;
 *     }
 *     uses pcreq-message;
 *     status CURRENT;
 * }
 * </pre>
 */
public interface PcepMessageListener
    extends
    NotificationListener
{




    void onClose(Close notification);
    
    void onKeepalive(Keepalive notification);
    
    void onOpen(Open notification);
    
    void onPcerr(Pcerr notification);
    
    void onPcntf(Pcntf notification);
    
    void onPcrep(Pcrep notification);
    
    void onPcreq(Pcreq notification);

}

