package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.Gc;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;


/**
 * GLOBAL CONSTRAINTS (GC) Object
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <br />(Source path: <i>META-INF/yang/pcep-types.yang</i>):
 * <pre>
 * grouping gc-object {
 *     container gc {
 *         leaf processing-rule {
 *             type boolean;
 *         }
 *         leaf ignore {
 *             type boolean;
 *         }
 *         leaf max-hop {
 *             type uint8;
 *         }
 *         leaf max-utilization {
 *             type uint8;
 *         }
 *         leaf min-utilization {
 *             type uint8;
 *         }
 *         leaf over-booking-factor {
 *             type uint8;
 *         }
 *         container tlvs {
 *             list vendor-information-tlv {
 *                 key     leaf enterprise-number {
 *                     type enterprise-number;
 *                 }
 *                 choice enterprise-specific-information {
 *                 }
 *                 uses vendor-information;
 *                 uses tlv;
 *             }
 *             uses vendor-information-tlvs;
 *         }
 *         uses object;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/gc-object</i>
 */
public interface GcObject
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types","2013-10-05","gc-object");;

    Gc getGc();

}

