package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;


/**
 * LSPA Object
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <br />(Source path: <i>META-INF/yang/pcep-types.yang</i>):
 * <pre>
 * grouping lspa-object {
 *     container lspa {
 *         leaf processing-rule {
 *             type boolean;
 *         }
 *         leaf ignore {
 *             type boolean;
 *         }
 *         leaf hold-priority {
 *             type uint8;
 *         }
 *         leaf setup-priority {
 *             type uint8;
 *         }
 *         leaf local-protection-desired {
 *             type boolean;
 *         }
 *         leaf include-any {
 *             type attribute-filter;
 *         }
 *         leaf exclude-any {
 *             type attribute-filter;
 *         }
 *         leaf include-all {
 *             type attribute-filter;
 *         }
 *         container tlvs {
 *             list vendor-information-tlv {
 *                 key     leaf enterprise-number {
 *                     type enterprise-number;
 *                 }
 *                 choice enterprise-specific-information {
 *                 }
 *                 uses vendor-information;
 *                 uses tlv;
 *             }
 *             uses vendor-information-tlvs;
 *         }
 *         uses tunnel-attributes;
 *         uses object;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/lspa-object</i>
 */
public interface LspaObject
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types","2013-10-05","lspa-object");;

    Lspa getLspa();

}

