package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Tlv;
import org.opendaylight.yangtools.yang.binding.DataObject;


/**
 * NO-PATH-VECTOR TLV
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <br />(Source path: <i>META-INF/yang/pcep-types.yang</i>):
 * <pre>
 * grouping no-path-vector-tlv {
 *     leaf flags {
 *         type bits;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/no-path-vector-tlv</i>
 */
public interface NoPathVectorTlv
    extends
    DataObject,
    Tlv
{

    /**
     * The bits built-in type represents a bit set. That is, a bits value is a set of flags identified by small integer position numbers starting at 0.  Each bit number has an assigned name.
     */
    public static final class Flags
     {
        final private java.lang.Boolean _p2mpUnreachable;
        final private java.lang.Boolean _noGcoSolution;
        final private java.lang.Boolean _noGcoMigration;
        final private java.lang.Boolean _pathKey;
        final private java.lang.Boolean _chainUnavailable;
        final private java.lang.Boolean _unknownSource;
        final private java.lang.Boolean _unknownDestination;
        final private java.lang.Boolean _pceUnavailable;
    
        public Flags(java.lang.Boolean _chainUnavailable, java.lang.Boolean _noGcoMigration, java.lang.Boolean _noGcoSolution, java.lang.Boolean _p2mpUnreachable, java.lang.Boolean _pathKey, java.lang.Boolean _pceUnavailable, java.lang.Boolean _unknownDestination, java.lang.Boolean _unknownSource) {
        
        
            this._p2mpUnreachable = _p2mpUnreachable;
            this._noGcoSolution = _noGcoSolution;
            this._noGcoMigration = _noGcoMigration;
            this._pathKey = _pathKey;
            this._chainUnavailable = _chainUnavailable;
            this._unknownSource = _unknownSource;
            this._unknownDestination = _unknownDestination;
            this._pceUnavailable = _pceUnavailable;
        }
        
        /**
         * Creates a copy from Source Object.
         *
         * @param source Source object
         */
        public Flags(Flags source) {
            this._p2mpUnreachable = source._p2mpUnreachable;
            this._noGcoSolution = source._noGcoSolution;
            this._noGcoMigration = source._noGcoMigration;
            this._pathKey = source._pathKey;
            this._chainUnavailable = source._chainUnavailable;
            this._unknownSource = source._unknownSource;
            this._unknownDestination = source._unknownDestination;
            this._pceUnavailable = source._pceUnavailable;
        }
    
    
        public java.lang.Boolean isP2mpUnreachable() {
            return _p2mpUnreachable;
        }
        
        public java.lang.Boolean isNoGcoSolution() {
            return _noGcoSolution;
        }
        
        public java.lang.Boolean isNoGcoMigration() {
            return _noGcoMigration;
        }
        
        public java.lang.Boolean isPathKey() {
            return _pathKey;
        }
        
        public java.lang.Boolean isChainUnavailable() {
            return _chainUnavailable;
        }
        
        public java.lang.Boolean isUnknownSource() {
            return _unknownSource;
        }
        
        public java.lang.Boolean isUnknownDestination() {
            return _unknownDestination;
        }
        
        public java.lang.Boolean isPceUnavailable() {
            return _pceUnavailable;
        }
    
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_p2mpUnreachable == null) ? 0 : _p2mpUnreachable.hashCode());
            result = prime * result + ((_noGcoSolution == null) ? 0 : _noGcoSolution.hashCode());
            result = prime * result + ((_noGcoMigration == null) ? 0 : _noGcoMigration.hashCode());
            result = prime * result + ((_pathKey == null) ? 0 : _pathKey.hashCode());
            result = prime * result + ((_chainUnavailable == null) ? 0 : _chainUnavailable.hashCode());
            result = prime * result + ((_unknownSource == null) ? 0 : _unknownSource.hashCode());
            result = prime * result + ((_unknownDestination == null) ? 0 : _unknownDestination.hashCode());
            result = prime * result + ((_pceUnavailable == null) ? 0 : _pceUnavailable.hashCode());
            return result;
        }
    
        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (getClass() != obj.getClass()) {
                return false;
            }
            Flags other = (Flags) obj;
            if (_p2mpUnreachable == null) {
                if (other._p2mpUnreachable != null) {
                    return false;
                }
            } else if(!_p2mpUnreachable.equals(other._p2mpUnreachable)) {
                return false;
            }
            if (_noGcoSolution == null) {
                if (other._noGcoSolution != null) {
                    return false;
                }
            } else if(!_noGcoSolution.equals(other._noGcoSolution)) {
                return false;
            }
            if (_noGcoMigration == null) {
                if (other._noGcoMigration != null) {
                    return false;
                }
            } else if(!_noGcoMigration.equals(other._noGcoMigration)) {
                return false;
            }
            if (_pathKey == null) {
                if (other._pathKey != null) {
                    return false;
                }
            } else if(!_pathKey.equals(other._pathKey)) {
                return false;
            }
            if (_chainUnavailable == null) {
                if (other._chainUnavailable != null) {
                    return false;
                }
            } else if(!_chainUnavailable.equals(other._chainUnavailable)) {
                return false;
            }
            if (_unknownSource == null) {
                if (other._unknownSource != null) {
                    return false;
                }
            } else if(!_unknownSource.equals(other._unknownSource)) {
                return false;
            }
            if (_unknownDestination == null) {
                if (other._unknownDestination != null) {
                    return false;
                }
            } else if(!_unknownDestination.equals(other._unknownDestination)) {
                return false;
            }
            if (_pceUnavailable == null) {
                if (other._pceUnavailable != null) {
                    return false;
                }
            } else if(!_pceUnavailable.equals(other._pceUnavailable)) {
                return false;
            }
            return true;
        }
    
        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.NoPathVectorTlv.Flags.class.getSimpleName()).append(" [");
            boolean first = true;
        
            if (_p2mpUnreachable != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_p2mpUnreachable=");
                builder.append(_p2mpUnreachable);
             }
            if (_noGcoSolution != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_noGcoSolution=");
                builder.append(_noGcoSolution);
             }
            if (_noGcoMigration != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_noGcoMigration=");
                builder.append(_noGcoMigration);
             }
            if (_pathKey != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_pathKey=");
                builder.append(_pathKey);
             }
            if (_chainUnavailable != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_chainUnavailable=");
                builder.append(_chainUnavailable);
             }
            if (_unknownSource != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_unknownSource=");
                builder.append(_unknownSource);
             }
            if (_unknownDestination != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_unknownDestination=");
                builder.append(_unknownDestination);
             }
            if (_pceUnavailable != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_pceUnavailable=");
                builder.append(_pceUnavailable);
             }
            return builder.append(']').toString();
        }
    
    
    
    }
    


    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types","2013-10-05","no-path-vector-tlv");;

    Flags getFlags();

}

