package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.key.object.PathKey;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;


/**
 * PATH-KEY Object
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <br />(Source path: <i>META-INF/yang/pcep-types.yang</i>):
 * <pre>
 * grouping path-key-object {
 *     container path-key {
 *         leaf processing-rule {
 *             type boolean;
 *         }
 *         leaf ignore {
 *             type boolean;
 *         }
 *         list path-keys {
 *             key     leaf loose {
 *                 type boolean;
 *             }
 *             leaf pce-id {
 *                 type pce-id;
 *             }
 *             leaf path-key {
 *                 type path-key;
 *             }
 *             uses path-key-subobject;
 *         }
 *         uses object;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/path-key-object</i>
 */
public interface PathKeyObject
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types","2013-10-05","path-key-object");;

    PathKey getPathKey();

}

