package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;
import java.io.Serializable;
import java.beans.ConstructorProperties;
import java.util.Arrays;


/**
 * The union built-in type represents a value that corresponds to one of its member types.
 */
public class PceId
 implements Serializable {
    private static final long serialVersionUID = 4383038616583172807L;
    final private byte[] _binary;
    final private char[] _value;

    public PceId(byte[] _binary) {
        super();
        this._binary = _binary;
        this._value = new java.lang.String(_binary).toCharArray();
    }
    
    /**
     * Constructor provided only for using in JMX. Don't use it for
     * construction new object of this union type. 
     */
    @ConstructorProperties("value")
    public PceId(char[] _value) {
        java.lang.String defVal = new java.lang.String(_value);
        PceId defInst = PceIdBuilder.getDefaultInstance(defVal);
        this._binary = defInst._binary;
        this._value = _value;
    }
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public PceId(PceId source) {
        this._binary = source._binary;
        this._value = source._value;
    }


    public byte[] getBinary() {
        return _binary;
    }
    
    public char[] getValue() {
        return _value;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((_binary == null) ? 0 : Arrays.hashCode(_binary));
        result = prime * result + ((_value == null) ? 0 : Arrays.hashCode(_value));
        return result;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        PceId other = (PceId) obj;
        if (_binary == null) {
            if (other._binary != null) {
                return false;
            }
        } else if(!Arrays.equals(_binary, other._binary)) {
            return false;
        }
        if (_value == null) {
            if (other._value != null) {
                return false;
            }
        } else if(!Arrays.equals(_value, other._value)) {
            return false;
        }
        return true;
    }

    @Override
    public java.lang.String toString() {
        java.lang.StringBuilder builder = new java.lang.StringBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.PceId.class.getSimpleName()).append(" [");
        boolean first = true;
    
        if (_binary != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_binary=");
            builder.append(Arrays.toString(_binary));
         }
        if (_value != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_value=");
            builder.append(Arrays.toString(_value));
         }
        return builder.append(']').toString();
    }



}
