package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Message;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <br />(Source path: <i>META-INF/yang/pcep-types.yang</i>):
 * <pre>
 * grouping pcntf-message {
 *     container pcntf-message {
 *         leaf version {
 *             type protocol-version;
 *         }
 *         list notifications {
 *             key     list rps {
 *                 key     container rp {
 *                     leaf processing-rule {
 *                         type boolean;
 *                     }
 *                     leaf ignore {
 *                         type boolean;
 *                     }
 *                     container tlvs {
 *                         list vendor-information-tlv {
 *                             key     leaf enterprise-number {
 *                                 type enterprise-number;
 *                             }
 *                             choice enterprise-specific-information {
 *                             }
 *                             uses vendor-information;
 *                             uses tlv;
 *                         }
 *                         container order {
 *                             leaf delete {
 *                                 type uint32;
 *                             }
 *                             leaf setup {
 *                                 type uint32;
 *                             }
 *                             uses tlv;
 *                         }
 *                         uses vendor-information-tlvs;
 *                         uses order-tlv;
 *                     }
 *                     leaf priority {
 *                         type uint8;
 *                     }
 *                     leaf request-id {
 *                         type request-id;
 *                     }
 *                     leaf reoptimization {
 *                         type boolean;
 *                     }
 *                     leaf bi-directional {
 *                         type boolean;
 *                     }
 *                     leaf loose {
 *                         type boolean;
 *                     }
 *                     leaf path-key {
 *                         type boolean;
 *                     }
 *                     leaf fragmentation {
 *                         type boolean;
 *                     }
 *                     leaf p2mp {
 *                         type boolean;
 *                     }
 *                     leaf ero-compression {
 *                         type boolean;
 *                     }
 *                     leaf supply-of {
 *                         type boolean;
 *                     }
 *                     leaf order {
 *                         type boolean;
 *                     }
 *                     leaf make-before-break {
 *                         type boolean;
 *                     }
 *                     uses object;
 *                 }
 *                 uses rp-object;
 *             }
 *             list notifications {
 *                 key     container c-notification {
 *                     leaf processing-rule {
 *                         type boolean;
 *                     }
 *                     leaf ignore {
 *                         type boolean;
 *                     }
 *                     container tlvs {
 *                         container overload-duration {
 *                             leaf duration {
 *                                 type uint32;
 *                             }
 *                             uses tlv;
 *                         }
 *                         list vendor-information-tlv {
 *                             key     leaf enterprise-number {
 *                                 type enterprise-number;
 *                             }
 *                             choice enterprise-specific-information {
 *                             }
 *                             uses vendor-information;
 *                             uses tlv;
 *                         }
 *                         uses overload-duration-tlv;
 *                         uses vendor-information-tlvs;
 *                     }
 *                     leaf type {
 *                         type uint8;
 *                     }
 *                     leaf value {
 *                         type uint8;
 *                     }
 *                     uses object;
 *                 }
 *                 uses notification-object;
 *             }
 *         }
 *         uses message-header;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/pcntf-message</i>
 */
public interface PcntfMessage
    extends
    DataObject,
    Message
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types","2013-10-05","pcntf-message");;

    /**
     * Notification Message
     */
    org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.PcntfMessage getPcntfMessage();

}

