package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reported.route.object.Rro;


/**
 * Reported Route Object
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <br />(Source path: <i>META-INF/yang/pcep-types.yang</i>):
 * <pre>
 * grouping reported-route-object {
 *     container rro {
 *         leaf processing-rule {
 *             type boolean;
 *         }
 *         leaf ignore {
 *             type boolean;
 *         }
 *         list subobject {
 *             key     leaf protection-available {
 *                 type boolean;
 *             }
 *             leaf protection-in-use {
 *                 type boolean;
 *             }
 *             choice subobject-type {
 *                 case ip-prefix-case {
 *                     container ip-prefix {
 *                         leaf ip-prefix {
 *                             type ip-prefix;
 *                         }
 *                         uses ip-prefix-subobject;
 *                     }
 *                 }
 *                 case label-case {
 *                     container label {
 *                         leaf uni-directional {
 *                             type boolean;
 *                         }
 *                         choice label-type {
 *                             case generalized-label-case {
 *                                 container generalized-label {
 *                                     leaf generalized-label {
 *                                         type binary;
 *                                     }
 *                                     uses generalized-label;
 *                                 }
 *                             }
 *                             case type1-label-case {
 *                                 container type1-label {
 *                                     leaf type1-label {
 *                                         type uint32;
 *                                     }
 *                                     uses type1-label;
 *                                 }
 *                             }
 *                             case waveband-switching-label-case {
 *                                 container waveband-switching-label {
 *                                     leaf end-label {
 *                                         type uint32;
 *                                     }
 *                                     leaf start-label {
 *                                         type uint32;
 *                                     }
 *                                     leaf waveband-id {
 *                                         type uint32;
 *                                     }
 *                                     uses waveband-switching-label;
 *                                 }
 *                             }
 *                         }
 *                         leaf global {
 *                             type boolean;
 *                         }
 *                         uses label-subobject;
 *                     }
 *                 }
 *                 case path-key-case {
 *                     container path-key {
 *                         leaf pce-id {
 *                             type pce-id;
 *                         }
 *                         leaf path-key {
 *                             type path-key;
 *                         }
 *                         uses path-key-subobject;
 *                     }
 *                 }
 *                 case unnumbered-case {
 *                     container unnumbered {
 *                         leaf router-id {
 *                             type uint32;
 *                         }
 *                         leaf interface-id {
 *                             type uint32;
 *                         }
 *                         uses unnumbered-subobject;
 *                     }
 *                 }
 *             }
 *             uses record-route-subobjects;
 *         }
 *         uses object;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/reported-route-object</i>
 */
public interface ReportedRouteObject
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types","2013-10-05","reported-route-object");;

    Rro getRro();

}

