package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.EnterpriseSpecificInformation;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.iana.rev130816.EnterpriseNumber;


/**
 * VENDOR-INFORMATION format
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <br />(Source path: <i>META-INF/yang/pcep-types.yang</i>):
 * <pre>
 * grouping vendor-information {
 *     leaf enterprise-number {
 *         type enterprise-number;
 *     }
 *     choice enterprise-specific-information {
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/vendor-information</i>
 */
public interface VendorInformation
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types","2013-10-05","vendor-information");;

    EnterpriseNumber getEnterpriseNumber();
    
    EnterpriseSpecificInformation getEnterpriseSpecificInformation();

}

