package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.close.message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MessageHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.CloseMessage;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.CloseObject;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * Close Message
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <br />(Source path: <i>META-INF/yang/pcep-types.yang</i>):
 * <pre>
 * container c-close-message {
 *     container c-close {
 *         leaf processing-rule {
 *             type boolean;
 *         }
 *         leaf ignore {
 *             type boolean;
 *         }
 *         leaf reason {
 *             type uint8;
 *         }
 *         container tlvs {
 *             list vendor-information-tlv {
 *                 key     leaf enterprise-number {
 *                     type enterprise-number;
 *                 }
 *                 choice enterprise-specific-information {
 *                 }
 *                 uses vendor-information;
 *                 uses tlv;
 *             }
 *             uses vendor-information-tlvs;
 *         }
 *         uses object;
 *     }
 *     leaf version {
 *         type protocol-version;
 *     }
 *     uses close-object;
 *     uses message-header;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/close-message/c-close-message</i>
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.close.message.CCloseMessageBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.close.message.CCloseMessageBuilder
 */
public interface CCloseMessage
    extends
    ChildOf<CloseMessage>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.close.message.CCloseMessage>,
    CloseObject,
    MessageHeader
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types","2013-10-05","c-close-message");;


}

