package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Endpoints;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.EndpointsObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <br />(Source path: <i>META-INF/yang/pcep-types.yang</i>):
 * <pre>
 * container endpoints-obj {
 *     choice address-family {
 *         case ipv4-case {
 *             container ipv4 {
 *                 leaf source-ipv4-address {
 *                     type ipv4-address;
 *                 }
 *                 leaf destination-ipv4-address {
 *                     type ipv4-address;
 *                 }
 *             }
 *         }
 *         case ipv6-case {
 *             container ipv6 {
 *                 leaf source-ipv6-address {
 *                     type ipv6-address;
 *                 }
 *                 leaf destination-ipv6-address {
 *                     type ipv6-address;
 *                 }
 *             }
 *         }
 *     }
 *     leaf processing-rule {
 *         type boolean;
 *     }
 *     leaf ignore {
 *         type boolean;
 *     }
 *     uses endpoints;
 *     uses object;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/endpoints-object/endpoints-obj</i>
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.object.EndpointsObjBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.object.EndpointsObjBuilder
 */
public interface EndpointsObj
    extends
    ChildOf<EndpointsObject>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.object.EndpointsObj>,
    Endpoints,
    Object
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types","2013-10-05","endpoints-obj");;


}

