package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.exclude.route.object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.exclude.route.object.xro.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ExcludeRouteObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <br />(Source path: <i>META-INF/yang/pcep-types.yang</i>):
 * <pre>
 * container xro {
 *     leaf processing-rule {
 *         type boolean;
 *     }
 *     leaf ignore {
 *         type boolean;
 *     }
 *     leaf flags {
 *         type bits;
 *     }
 *     list subobject {
 *         key     leaf mandatory {
 *             type boolean;
 *         }
 *         leaf attribute {
 *             type enumeration;
 *         }
 *         choice subobject-type {
 *             case as-number-case {
 *                 container as-number {
 *                     leaf as-number {
 *                         type as-number;
 *                     }
 *                     uses as-number-subobject;
 *                 }
 *             }
 *             case ip-prefix-case {
 *                 container ip-prefix {
 *                     leaf ip-prefix {
 *                         type ip-prefix;
 *                     }
 *                     uses ip-prefix-subobject;
 *                 }
 *             }
 *             case label-case {
 *                 container label {
 *                     leaf uni-directional {
 *                         type boolean;
 *                     }
 *                     choice label-type {
 *                         case generalized-label-case {
 *                             container generalized-label {
 *                                 leaf generalized-label {
 *                                     type binary;
 *                                 }
 *                                 uses generalized-label;
 *                             }
 *                         }
 *                         case type1-label-case {
 *                             container type1-label {
 *                                 leaf type1-label {
 *                                     type uint32;
 *                                 }
 *                                 uses type1-label;
 *                             }
 *                         }
 *                         case waveband-switching-label-case {
 *                             container waveband-switching-label {
 *                                 leaf end-label {
 *                                     type uint32;
 *                                 }
 *                                 leaf start-label {
 *                                     type uint32;
 *                                 }
 *                                 leaf waveband-id {
 *                                     type uint32;
 *                                 }
 *                                 uses waveband-switching-label;
 *                             }
 *                         }
 *                     }
 *                     uses label-subobject;
 *                 }
 *             }
 *             case srlg-case {
 *                 container srlg {
 *                     leaf srlg-id {
 *                         type srlg-id;
 *                     }
 *                     uses srlg-subobject;
 *                 }
 *             }
 *             case unnumbered-case {
 *                 container unnumbered {
 *                     leaf router-id {
 *                         type uint32;
 *                     }
 *                     leaf interface-id {
 *                         type uint32;
 *                     }
 *                     uses unnumbered-subobject;
 *                 }
 *             }
 *         }
 *         uses exclude-route-subobjects;
 *     }
 *     uses object;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/exclude-route-object/xro</i>
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.exclude.route.object.XroBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.exclude.route.object.XroBuilder
 */
public interface Xro
    extends
    ChildOf<ExcludeRouteObject>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.exclude.route.object.Xro>,
    Object
{

    /**
     * The bits built-in type represents a bit set. That is, a bits value is a set of flags identified by small integer position numbers starting at 0.  Each bit number has an assigned name.
     */
    public static final class Flags
     {
        final private java.lang.Boolean _fail;
    
        public Flags(java.lang.Boolean _fail) {
        
        
            this._fail = _fail;
        }
        
        /**
         * Creates a copy from Source Object.
         *
         * @param source Source object
         */
        public Flags(Flags source) {
            this._fail = source._fail;
        }
    
    
        public java.lang.Boolean isFail() {
            return _fail;
        }
    
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_fail == null) ? 0 : _fail.hashCode());
            return result;
        }
    
        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (getClass() != obj.getClass()) {
                return false;
            }
            Flags other = (Flags) obj;
            if (_fail == null) {
                if (other._fail != null) {
                    return false;
                }
            } else if(!_fail.equals(other._fail)) {
                return false;
            }
            return true;
        }
    
        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.exclude.route.object.Xro.Flags.class.getSimpleName()).append(" [");
            boolean first = true;
        
            if (_fail != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_fail=");
                builder.append(_fail);
             }
            return builder.append(']').toString();
        }
    
    
    
    }
    


    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types","2013-10-05","xro");;

    Flags getFlags();
    
    List<Subobject> getSubobject();

}

