package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object;
import com.google.common.collect.Range;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.gc.Tlvs;
import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.util.List;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.Gc} instances.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.Gc
 */
public class GcBuilder {

    private java.lang.Short _maxHop;
    private static List<Range<BigInteger>> _maxHop_range;
    private java.lang.Short _maxUtilization;
    private static List<Range<BigInteger>> _maxUtilization_range;
    private java.lang.Short _minUtilization;
    private static List<Range<BigInteger>> _minUtilization_range;
    private java.lang.Short _overBookingFactor;
    private static List<Range<BigInteger>> _overBookingFactor_range;
    private Tlvs _tlvs;
    private java.lang.Boolean _ignore;
    private java.lang.Boolean _processingRule;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.Gc>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.Gc>> augmentation = new HashMap<>();

    public GcBuilder() {
    } 
    
    
    public GcBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public GcBuilder(Gc base) {
        this._maxHop = base.getMaxHop();
        this._maxUtilization = base.getMaxUtilization();
        this._minUtilization = base.getMinUtilization();
        this._overBookingFactor = base.getOverBookingFactor();
        this._tlvs = base.getTlvs();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
        if (base instanceof GcImpl) {
            GcImpl _impl = (GcImpl) base;
            this.augmentation = new HashMap<>(_impl.augmentation);
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader) {
            this._processingRule = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader)arg).isProcessingRule();
            this._ignore = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader] \n" +
              "but was: " + arg
            );
        }
    }

    public java.lang.Short getMaxHop() {
        return _maxHop;
    }
    
    public java.lang.Short getMaxUtilization() {
        return _maxUtilization;
    }
    
    public java.lang.Short getMinUtilization() {
        return _minUtilization;
    }
    
    public java.lang.Short getOverBookingFactor() {
        return _overBookingFactor;
    }
    
    public Tlvs getTlvs() {
        return _tlvs;
    }
    
    public java.lang.Boolean isIgnore() {
        return _ignore;
    }
    
    public java.lang.Boolean isProcessingRule() {
        return _processingRule;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.Gc>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public GcBuilder setMaxHop(java.lang.Short value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value);
            boolean isValidRange = false;
            for (Range<BigInteger> r : _maxHop_range()) {
                if (r.contains(_constraint)) {
                    isValidRange = true;
                }
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _maxHop_range));
            }
        }
        this._maxHop = value;
        return this;
    }
    public static List<Range<BigInteger>> _maxHop_range() {
        if (_maxHop_range == null) {
            synchronized (GcBuilder.class) {
                if (_maxHop_range == null) {
                    ImmutableList.Builder<Range<BigInteger>> builder = ImmutableList.builder();
                    builder.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(255L)));
                    _maxHop_range = builder.build();
                }
            }
        }
        return _maxHop_range;
    }
    
    public GcBuilder setMaxUtilization(java.lang.Short value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value);
            boolean isValidRange = false;
            for (Range<BigInteger> r : _maxUtilization_range()) {
                if (r.contains(_constraint)) {
                    isValidRange = true;
                }
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _maxUtilization_range));
            }
        }
        this._maxUtilization = value;
        return this;
    }
    public static List<Range<BigInteger>> _maxUtilization_range() {
        if (_maxUtilization_range == null) {
            synchronized (GcBuilder.class) {
                if (_maxUtilization_range == null) {
                    ImmutableList.Builder<Range<BigInteger>> builder = ImmutableList.builder();
                    builder.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(100L)));
                    _maxUtilization_range = builder.build();
                }
            }
        }
        return _maxUtilization_range;
    }
    
    public GcBuilder setMinUtilization(java.lang.Short value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value);
            boolean isValidRange = false;
            for (Range<BigInteger> r : _minUtilization_range()) {
                if (r.contains(_constraint)) {
                    isValidRange = true;
                }
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _minUtilization_range));
            }
        }
        this._minUtilization = value;
        return this;
    }
    public static List<Range<BigInteger>> _minUtilization_range() {
        if (_minUtilization_range == null) {
            synchronized (GcBuilder.class) {
                if (_minUtilization_range == null) {
                    ImmutableList.Builder<Range<BigInteger>> builder = ImmutableList.builder();
                    builder.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(100L)));
                    _minUtilization_range = builder.build();
                }
            }
        }
        return _minUtilization_range;
    }
    
    public GcBuilder setOverBookingFactor(java.lang.Short value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value);
            boolean isValidRange = false;
            for (Range<BigInteger> r : _overBookingFactor_range()) {
                if (r.contains(_constraint)) {
                    isValidRange = true;
                }
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _overBookingFactor_range));
            }
        }
        this._overBookingFactor = value;
        return this;
    }
    public static List<Range<BigInteger>> _overBookingFactor_range() {
        if (_overBookingFactor_range == null) {
            synchronized (GcBuilder.class) {
                if (_overBookingFactor_range == null) {
                    ImmutableList.Builder<Range<BigInteger>> builder = ImmutableList.builder();
                    builder.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(100L)));
                    _overBookingFactor_range = builder.build();
                }
            }
        }
        return _overBookingFactor_range;
    }
    
    public GcBuilder setTlvs(Tlvs value) {
        this._tlvs = value;
        return this;
    }
    
    public GcBuilder setIgnore(java.lang.Boolean value) {
        this._ignore = value;
        return this;
    }
    
    public GcBuilder setProcessingRule(java.lang.Boolean value) {
        this._processingRule = value;
        return this;
    }
    
    public GcBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.Gc>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.Gc> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Gc build() {
        return new GcImpl(this);
    }

    private static final class GcImpl implements Gc {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.Gc> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.Gc.class;
        }

        private final java.lang.Short _maxHop;
        private final java.lang.Short _maxUtilization;
        private final java.lang.Short _minUtilization;
        private final java.lang.Short _overBookingFactor;
        private final Tlvs _tlvs;
        private final java.lang.Boolean _ignore;
        private final java.lang.Boolean _processingRule;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.Gc>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.Gc>> augmentation = new HashMap<>();

        private GcImpl(GcBuilder base) {
            this._maxHop = base.getMaxHop();
            this._maxUtilization = base.getMaxUtilization();
            this._minUtilization = base.getMinUtilization();
            this._overBookingFactor = base.getOverBookingFactor();
            this._tlvs = base.getTlvs();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
                switch (base.augmentation.size()) {
                case 0:
                    this.augmentation = Collections.emptyMap();
                    break;
                    case 1:
                        final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.Gc>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.Gc>> e = base.augmentation.entrySet().iterator().next();
                        this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.Gc>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.Gc>>singletonMap(e.getKey(), e.getValue());       
                    break;
                default :
                    this.augmentation = new HashMap<>(base.augmentation);
                }
        }

        @Override
        public java.lang.Short getMaxHop() {
            return _maxHop;
        }
        
        @Override
        public java.lang.Short getMaxUtilization() {
            return _maxUtilization;
        }
        
        @Override
        public java.lang.Short getMinUtilization() {
            return _minUtilization;
        }
        
        @Override
        public java.lang.Short getOverBookingFactor() {
            return _overBookingFactor;
        }
        
        @Override
        public Tlvs getTlvs() {
            return _tlvs;
        }
        
        @Override
        public java.lang.Boolean isIgnore() {
            return _ignore;
        }
        
        @Override
        public java.lang.Boolean isProcessingRule() {
            return _processingRule;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.Gc>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_maxHop == null) ? 0 : _maxHop.hashCode());
            result = prime * result + ((_maxUtilization == null) ? 0 : _maxUtilization.hashCode());
            result = prime * result + ((_minUtilization == null) ? 0 : _minUtilization.hashCode());
            result = prime * result + ((_overBookingFactor == null) ? 0 : _overBookingFactor.hashCode());
            result = prime * result + ((_tlvs == null) ? 0 : _tlvs.hashCode());
            result = prime * result + ((_ignore == null) ? 0 : _ignore.hashCode());
            result = prime * result + ((_processingRule == null) ? 0 : _processingRule.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.Gc.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.Gc other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.Gc)obj;
            if (_maxHop == null) {
                if (other.getMaxHop() != null) {
                    return false;
                }
            } else if(!_maxHop.equals(other.getMaxHop())) {
                return false;
            }
            if (_maxUtilization == null) {
                if (other.getMaxUtilization() != null) {
                    return false;
                }
            } else if(!_maxUtilization.equals(other.getMaxUtilization())) {
                return false;
            }
            if (_minUtilization == null) {
                if (other.getMinUtilization() != null) {
                    return false;
                }
            } else if(!_minUtilization.equals(other.getMinUtilization())) {
                return false;
            }
            if (_overBookingFactor == null) {
                if (other.getOverBookingFactor() != null) {
                    return false;
                }
            } else if(!_overBookingFactor.equals(other.getOverBookingFactor())) {
                return false;
            }
            if (_tlvs == null) {
                if (other.getTlvs() != null) {
                    return false;
                }
            } else if(!_tlvs.equals(other.getTlvs())) {
                return false;
            }
            if (_ignore == null) {
                if (other.isIgnore() != null) {
                    return false;
                }
            } else if(!_ignore.equals(other.isIgnore())) {
                return false;
            }
            if (_processingRule == null) {
                if (other.isProcessingRule() != null) {
                    return false;
                }
            } else if(!_processingRule.equals(other.isProcessingRule())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                GcImpl otherImpl = (GcImpl) obj;
                if (augmentation == null) {
                    if (otherImpl.augmentation != null) {
                        return false;
                    }
                } else if(!augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.Gc>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.Gc>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
        
        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Gc [");
            boolean first = true;
        
            if (_maxHop != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maxHop=");
                builder.append(_maxHop);
             }
            if (_maxUtilization != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maxUtilization=");
                builder.append(_maxUtilization);
             }
            if (_minUtilization != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_minUtilization=");
                builder.append(_minUtilization);
             }
            if (_overBookingFactor != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_overBookingFactor=");
                builder.append(_overBookingFactor);
             }
            if (_tlvs != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tlvs=");
                builder.append(_tlvs);
             }
            if (_ignore != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ignore=");
                builder.append(_ignore);
             }
            if (_processingRule != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_processingRule=");
                builder.append(_processingRule);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
