package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.notification.object;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.notification.object.c.notification.Tlvs;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.NotificationObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <br />(Source path: <i>META-INF/yang/pcep-types.yang</i>):
 * <pre>
 * container c-notification {
 *     leaf processing-rule {
 *         type boolean;
 *     }
 *     leaf ignore {
 *         type boolean;
 *     }
 *     container tlvs {
 *         container overload-duration {
 *             leaf duration {
 *                 type uint32;
 *             }
 *             uses tlv;
 *         }
 *         list vendor-information-tlv {
 *             key     leaf enterprise-number {
 *                 type enterprise-number;
 *             }
 *             choice enterprise-specific-information {
 *             }
 *             uses vendor-information;
 *             uses tlv;
 *         }
 *         uses overload-duration-tlv;
 *         uses vendor-information-tlvs;
 *     }
 *     leaf type {
 *         type uint8;
 *     }
 *     leaf value {
 *         type uint8;
 *     }
 *     uses object;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/notification-object/c-notification</i>
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.notification.object.CNotificationBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.notification.object.CNotificationBuilder
 */
public interface CNotification
    extends
    ChildOf<NotificationObject>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.notification.object.CNotification>,
    Object
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types","2013-10-05","c-notification");;

    Tlvs getTlvs();
    
    java.lang.Short getType();
    
    java.lang.Short getValue();

}

