package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MessageHeader;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OpenObject;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * Open Message
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <br />(Source path: <i>META-INF/yang/pcep-types.yang</i>):
 * <pre>
 * container open-message {
 *     container open {
 *         leaf processing-rule {
 *             type boolean;
 *         }
 *         leaf ignore {
 *             type boolean;
 *         }
 *         container tlvs {
 *             container of-list {
 *                 leaf-list codes {
 *                     type of-id;
 *                 }
 *                 uses tlv;
 *             }
 *             list vendor-information-tlv {
 *                 key     leaf enterprise-number {
 *                     type enterprise-number;
 *                 }
 *                 choice enterprise-specific-information {
 *                 }
 *                 uses vendor-information;
 *                 uses tlv;
 *             }
 *             uses of-list-tlv;
 *             uses vendor-information-tlvs;
 *         }
 *         leaf version {
 *             type protocol-version;
 *         }
 *         leaf keepalive {
 *             type uint8;
 *         }
 *         leaf dead-timer {
 *             type uint8;
 *         }
 *         leaf session-id {
 *             type uint8;
 *         }
 *         uses object;
 *     }
 *     leaf version {
 *         type protocol-version;
 *     }
 *     uses message-header;
 *     uses open-object;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/open-message/open-message</i>
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.message.OpenMessageBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.message.OpenMessageBuilder
 */
public interface OpenMessage
    extends
    ChildOf<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OpenMessage>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.message.OpenMessage>,
    MessageHeader,
    OpenObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types","2013-10-05","open-message");;


}

