package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.ErrorType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MessageHeader;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.Errors;
import java.util.List;


/**
 * Error Message
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <br />(Source path: <i>META-INF/yang/pcep-types.yang</i>):
 * <pre>
 * container pcerr-message {
 *     leaf version {
 *         type protocol-version;
 *     }
 *     list errors {
 *         key     container error-object {
 *             leaf processing-rule {
 *                 type boolean;
 *             }
 *             leaf ignore {
 *                 type boolean;
 *             }
 *             container tlvs {
 *                 container req-missing {
 *                     leaf request-id {
 *                         type request-id;
 *                     }
 *                     uses tlv;
 *                 }
 *                 list vendor-information-tlv {
 *                     key     leaf enterprise-number {
 *                         type enterprise-number;
 *                     }
 *                     choice enterprise-specific-information {
 *                     }
 *                     uses vendor-information;
 *                     uses tlv;
 *                 }
 *                 uses vendor-information-tlvs;
 *                 uses req-missing-tlv;
 *             }
 *             leaf type {
 *                 type uint8;
 *             }
 *             leaf value {
 *                 type uint8;
 *             }
 *             uses object;
 *         }
 *         uses pcep-error-object;
 *     }
 *     choice error-type {
 *         case request-case {
 *             container request {
 *                 list rps {
 *                     key     container rp {
 *                         leaf processing-rule {
 *                             type boolean;
 *                         }
 *                         leaf ignore {
 *                             type boolean;
 *                         }
 *                         container tlvs {
 *                             list vendor-information-tlv {
 *                                 key     leaf enterprise-number {
 *                                     type enterprise-number;
 *                                 }
 *                                 choice enterprise-specific-information {
 *                                 }
 *                                 uses vendor-information;
 *                                 uses tlv;
 *                             }
 *                             container order {
 *                                 leaf delete {
 *                                     type uint32;
 *                                 }
 *                                 leaf setup {
 *                                     type uint32;
 *                                 }
 *                                 uses tlv;
 *                             }
 *                             uses vendor-information-tlvs;
 *                             uses order-tlv;
 *                         }
 *                         leaf priority {
 *                             type uint8;
 *                         }
 *                         leaf request-id {
 *                             type request-id;
 *                         }
 *                         leaf reoptimization {
 *                             type boolean;
 *                         }
 *                         leaf bi-directional {
 *                             type boolean;
 *                         }
 *                         leaf loose {
 *                             type boolean;
 *                         }
 *                         leaf path-key {
 *                             type boolean;
 *                         }
 *                         leaf fragmentation {
 *                             type boolean;
 *                         }
 *                         leaf p2mp {
 *                             type boolean;
 *                         }
 *                         leaf ero-compression {
 *                             type boolean;
 *                         }
 *                         leaf supply-of {
 *                             type boolean;
 *                         }
 *                         leaf order {
 *                             type boolean;
 *                         }
 *                         leaf make-before-break {
 *                             type boolean;
 *                         }
 *                         uses object;
 *                     }
 *                     uses rp-object;
 *                 }
 *             }
 *         }
 *         case session-case {
 *             container session {
 *                 container open {
 *                     leaf processing-rule {
 *                         type boolean;
 *                     }
 *                     leaf ignore {
 *                         type boolean;
 *                     }
 *                     container tlvs {
 *                         container of-list {
 *                             leaf-list codes {
 *                                 type of-id;
 *                             }
 *                             uses tlv;
 *                         }
 *                         list vendor-information-tlv {
 *                             key     leaf enterprise-number {
 *                                 type enterprise-number;
 *                             }
 *                             choice enterprise-specific-information {
 *                             }
 *                             uses vendor-information;
 *                             uses tlv;
 *                         }
 *                         uses of-list-tlv;
 *                         uses vendor-information-tlvs;
 *                     }
 *                     leaf version {
 *                         type protocol-version;
 *                     }
 *                     leaf keepalive {
 *                         type uint8;
 *                     }
 *                     leaf dead-timer {
 *                         type uint8;
 *                     }
 *                     leaf session-id {
 *                         type uint8;
 *                     }
 *                     uses object;
 *                 }
 *                 uses open-object;
 *             }
 *         }
 *     }
 *     uses message-header;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/pcerr-message/pcerr-message</i>
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.PcerrMessageBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.PcerrMessageBuilder
 */
public interface PcerrMessage
    extends
    ChildOf<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.PcerrMessage>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.PcerrMessage>,
    MessageHeader
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types","2013-10-05","pcerr-message");;

    List<Errors> getErrors();
    
    ErrorType getErrorType();

}

