package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.pcntf.message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.PcntfMessage;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.pcntf.message.notifications.Rps;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <br />(Source path: <i>META-INF/yang/pcep-types.yang</i>):
 * <pre>
 * list notifications {
 *     key     list rps {
 *         key     container rp {
 *             leaf processing-rule {
 *                 type boolean;
 *             }
 *             leaf ignore {
 *                 type boolean;
 *             }
 *             container tlvs {
 *                 list vendor-information-tlv {
 *                     key     leaf enterprise-number {
 *                         type enterprise-number;
 *                     }
 *                     choice enterprise-specific-information {
 *                     }
 *                     uses vendor-information;
 *                     uses tlv;
 *                 }
 *                 container order {
 *                     leaf delete {
 *                         type uint32;
 *                     }
 *                     leaf setup {
 *                         type uint32;
 *                     }
 *                     uses tlv;
 *                 }
 *                 uses vendor-information-tlvs;
 *                 uses order-tlv;
 *             }
 *             leaf priority {
 *                 type uint8;
 *             }
 *             leaf request-id {
 *                 type request-id;
 *             }
 *             leaf reoptimization {
 *                 type boolean;
 *             }
 *             leaf bi-directional {
 *                 type boolean;
 *             }
 *             leaf loose {
 *                 type boolean;
 *             }
 *             leaf path-key {
 *                 type boolean;
 *             }
 *             leaf fragmentation {
 *                 type boolean;
 *             }
 *             leaf p2mp {
 *                 type boolean;
 *             }
 *             leaf ero-compression {
 *                 type boolean;
 *             }
 *             leaf supply-of {
 *                 type boolean;
 *             }
 *             leaf order {
 *                 type boolean;
 *             }
 *             leaf make-before-break {
 *                 type boolean;
 *             }
 *             uses object;
 *         }
 *         uses rp-object;
 *     }
 *     list notifications {
 *         key     container c-notification {
 *             leaf processing-rule {
 *                 type boolean;
 *             }
 *             leaf ignore {
 *                 type boolean;
 *             }
 *             container tlvs {
 *                 container overload-duration {
 *                     leaf duration {
 *                         type uint32;
 *                     }
 *                     uses tlv;
 *                 }
 *                 list vendor-information-tlv {
 *                     key     leaf enterprise-number {
 *                         type enterprise-number;
 *                     }
 *                     choice enterprise-specific-information {
 *                     }
 *                     uses vendor-information;
 *                     uses tlv;
 *                 }
 *                 uses overload-duration-tlv;
 *                 uses vendor-information-tlvs;
 *             }
 *             leaf type {
 *                 type uint8;
 *             }
 *             leaf value {
 *                 type uint8;
 *             }
 *             uses object;
 *         }
 *         uses notification-object;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/pcntf-message/pcntf-message/notifications</i>
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.pcntf.message.NotificationsBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.pcntf.message.NotificationsBuilder@see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.pcntf.message.NotificationsKey
 */
public interface Notifications
    extends
    ChildOf<PcntfMessage>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.pcntf.message.Notifications>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types","2013-10-05","notifications");;

    List<Rps> getRps();
    
    List<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.pcntf.message.notifications.Notifications> getNotifications();

}

