package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.pcntf.message.notifications;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.NotificationObject;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <br />(Source path: <i>META-INF/yang/pcep-types.yang</i>):
 * <pre>
 * list notifications {
 *     key     container c-notification {
 *         leaf processing-rule {
 *             type boolean;
 *         }
 *         leaf ignore {
 *             type boolean;
 *         }
 *         container tlvs {
 *             container overload-duration {
 *                 leaf duration {
 *                     type uint32;
 *                 }
 *                 uses tlv;
 *             }
 *             list vendor-information-tlv {
 *                 key     leaf enterprise-number {
 *                     type enterprise-number;
 *                 }
 *                 choice enterprise-specific-information {
 *                 }
 *                 uses vendor-information;
 *                 uses tlv;
 *             }
 *             uses overload-duration-tlv;
 *             uses vendor-information-tlvs;
 *         }
 *         leaf type {
 *             type uint8;
 *         }
 *         leaf value {
 *             type uint8;
 *         }
 *         uses object;
 *     }
 *     uses notification-object;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/pcntf-message/pcntf-message/notifications/notifications</i>
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.pcntf.message.notifications.NotificationsBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.pcntf.message.notifications.NotificationsBuilder@see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.pcntf.message.notifications.NotificationsKey
 */
public interface Notifications
    extends
    ChildOf<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.pcntf.message.Notifications>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.pcntf.message.notifications.Notifications>,
    NotificationObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types","2013-10-05","notifications");;


}

