package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.success._case.success;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.explicit.route.object.Ero;
import java.util.Collections;
import java.util.Map;
import java.util.HashMap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.classtype.object.ClassType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.include.route.object.Iro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lsp.attributes.Metrics;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.exclude.route.object.Xro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.of.object.Of;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reported.route.object.Rro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.bandwidth.object.Bandwidth;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.success._case.success.Paths} instances.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.success._case.success.Paths
 */
public class PathsBuilder {

    private Bandwidth _bandwidth;
    private ClassType _classType;
    private Ero _ero;
    private Iro _iro;
    private Lspa _lspa;
    private List<Metrics> _metrics;
    private Of _of;
    private Rro _rro;
    private Xro _xro;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.success._case.success.Paths>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.success._case.success.Paths>> augmentation = new HashMap<>();

    public PathsBuilder() {
    } 
    
    
    public PathsBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ExplicitRouteObject arg) {
        this._ero = arg.getEro();
    }
    
    public PathsBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LspAttributes arg) {
        this._metrics = arg.getMetrics();
        this._xro = arg.getXro();
        this._rro = arg.getRro();
        this._bandwidth = arg.getBandwidth();
        this._of = arg.getOf();
        this._iro = arg.getIro();
        this._classType = arg.getClassType();
        this._lspa = arg.getLspa();
    }
    
    public PathsBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ExcludeRouteObject arg) {
        this._xro = arg.getXro();
    }
    
    public PathsBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ReportedRouteObject arg) {
        this._rro = arg.getRro();
    }
    
    public PathsBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.BandwidthObject arg) {
        this._bandwidth = arg.getBandwidth();
    }
    
    public PathsBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OfObject arg) {
        this._of = arg.getOf();
    }
    
    public PathsBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.IncludeRouteObject arg) {
        this._iro = arg.getIro();
    }
    
    public PathsBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ClasstypeObject arg) {
        this._classType = arg.getClassType();
    }
    
    public PathsBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LspaObject arg) {
        this._lspa = arg.getLspa();
    }

    public PathsBuilder(Paths base) {
        this._bandwidth = base.getBandwidth();
        this._classType = base.getClassType();
        this._ero = base.getEro();
        this._iro = base.getIro();
        this._lspa = base.getLspa();
        this._metrics = base.getMetrics();
        this._of = base.getOf();
        this._rro = base.getRro();
        this._xro = base.getXro();
        if (base instanceof PathsImpl) {
            PathsImpl _impl = (PathsImpl) base;
            this.augmentation = new HashMap<>(_impl.augmentation);
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OfObject</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ExcludeRouteObject</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LspaObject</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ClasstypeObject</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ExplicitRouteObject</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LspAttributes</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ReportedRouteObject</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.BandwidthObject</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.IncludeRouteObject</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OfObject) {
            this._of = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OfObject)arg).getOf();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ExcludeRouteObject) {
            this._xro = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ExcludeRouteObject)arg).getXro();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LspaObject) {
            this._lspa = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LspaObject)arg).getLspa();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ClasstypeObject) {
            this._classType = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ClasstypeObject)arg).getClassType();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ExplicitRouteObject) {
            this._ero = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ExplicitRouteObject)arg).getEro();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LspAttributes) {
            this._metrics = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LspAttributes)arg).getMetrics();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ReportedRouteObject) {
            this._rro = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ReportedRouteObject)arg).getRro();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.BandwidthObject) {
            this._bandwidth = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.BandwidthObject)arg).getBandwidth();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.IncludeRouteObject) {
            this._iro = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.IncludeRouteObject)arg).getIro();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OfObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ExcludeRouteObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LspaObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ClasstypeObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ExplicitRouteObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LspAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ReportedRouteObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.BandwidthObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.IncludeRouteObject] \n" +
              "but was: " + arg
            );
        }
    }

    public Bandwidth getBandwidth() {
        return _bandwidth;
    }
    
    public ClassType getClassType() {
        return _classType;
    }
    
    public Ero getEro() {
        return _ero;
    }
    
    public Iro getIro() {
        return _iro;
    }
    
    public Lspa getLspa() {
        return _lspa;
    }
    
    public List<Metrics> getMetrics() {
        return _metrics;
    }
    
    public Of getOf() {
        return _of;
    }
    
    public Rro getRro() {
        return _rro;
    }
    
    public Xro getXro() {
        return _xro;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.success._case.success.Paths>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public PathsBuilder setBandwidth(Bandwidth value) {
        this._bandwidth = value;
        return this;
    }
    
    public PathsBuilder setClassType(ClassType value) {
        this._classType = value;
        return this;
    }
    
    public PathsBuilder setEro(Ero value) {
        this._ero = value;
        return this;
    }
    
    public PathsBuilder setIro(Iro value) {
        this._iro = value;
        return this;
    }
    
    public PathsBuilder setLspa(Lspa value) {
        this._lspa = value;
        return this;
    }
    
    public PathsBuilder setMetrics(List<Metrics> value) {
        this._metrics = value;
        return this;
    }
    
    public PathsBuilder setOf(Of value) {
        this._of = value;
        return this;
    }
    
    public PathsBuilder setRro(Rro value) {
        this._rro = value;
        return this;
    }
    
    public PathsBuilder setXro(Xro value) {
        this._xro = value;
        return this;
    }
    
    public PathsBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.success._case.success.Paths>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.success._case.success.Paths> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Paths build() {
        return new PathsImpl(this);
    }

    private static final class PathsImpl implements Paths {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.success._case.success.Paths> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.success._case.success.Paths.class;
        }

        private final Bandwidth _bandwidth;
        private final ClassType _classType;
        private final Ero _ero;
        private final Iro _iro;
        private final Lspa _lspa;
        private final List<Metrics> _metrics;
        private final Of _of;
        private final Rro _rro;
        private final Xro _xro;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.success._case.success.Paths>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.success._case.success.Paths>> augmentation = new HashMap<>();

        private PathsImpl(PathsBuilder base) {
            this._bandwidth = base.getBandwidth();
            this._classType = base.getClassType();
            this._ero = base.getEro();
            this._iro = base.getIro();
            this._lspa = base.getLspa();
            this._metrics = base.getMetrics();
            this._of = base.getOf();
            this._rro = base.getRro();
            this._xro = base.getXro();
                switch (base.augmentation.size()) {
                case 0:
                    this.augmentation = Collections.emptyMap();
                    break;
                    case 1:
                        final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.success._case.success.Paths>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.success._case.success.Paths>> e = base.augmentation.entrySet().iterator().next();
                        this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.success._case.success.Paths>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.success._case.success.Paths>>singletonMap(e.getKey(), e.getValue());       
                    break;
                default :
                    this.augmentation = new HashMap<>(base.augmentation);
                }
        }

        @Override
        public Bandwidth getBandwidth() {
            return _bandwidth;
        }
        
        @Override
        public ClassType getClassType() {
            return _classType;
        }
        
        @Override
        public Ero getEro() {
            return _ero;
        }
        
        @Override
        public Iro getIro() {
            return _iro;
        }
        
        @Override
        public Lspa getLspa() {
            return _lspa;
        }
        
        @Override
        public List<Metrics> getMetrics() {
            return _metrics;
        }
        
        @Override
        public Of getOf() {
            return _of;
        }
        
        @Override
        public Rro getRro() {
            return _rro;
        }
        
        @Override
        public Xro getXro() {
            return _xro;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.success._case.success.Paths>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_bandwidth == null) ? 0 : _bandwidth.hashCode());
            result = prime * result + ((_classType == null) ? 0 : _classType.hashCode());
            result = prime * result + ((_ero == null) ? 0 : _ero.hashCode());
            result = prime * result + ((_iro == null) ? 0 : _iro.hashCode());
            result = prime * result + ((_lspa == null) ? 0 : _lspa.hashCode());
            result = prime * result + ((_metrics == null) ? 0 : _metrics.hashCode());
            result = prime * result + ((_of == null) ? 0 : _of.hashCode());
            result = prime * result + ((_rro == null) ? 0 : _rro.hashCode());
            result = prime * result + ((_xro == null) ? 0 : _xro.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.success._case.success.Paths.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.success._case.success.Paths other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.success._case.success.Paths)obj;
            if (_bandwidth == null) {
                if (other.getBandwidth() != null) {
                    return false;
                }
            } else if(!_bandwidth.equals(other.getBandwidth())) {
                return false;
            }
            if (_classType == null) {
                if (other.getClassType() != null) {
                    return false;
                }
            } else if(!_classType.equals(other.getClassType())) {
                return false;
            }
            if (_ero == null) {
                if (other.getEro() != null) {
                    return false;
                }
            } else if(!_ero.equals(other.getEro())) {
                return false;
            }
            if (_iro == null) {
                if (other.getIro() != null) {
                    return false;
                }
            } else if(!_iro.equals(other.getIro())) {
                return false;
            }
            if (_lspa == null) {
                if (other.getLspa() != null) {
                    return false;
                }
            } else if(!_lspa.equals(other.getLspa())) {
                return false;
            }
            if (_metrics == null) {
                if (other.getMetrics() != null) {
                    return false;
                }
            } else if(!_metrics.equals(other.getMetrics())) {
                return false;
            }
            if (_of == null) {
                if (other.getOf() != null) {
                    return false;
                }
            } else if(!_of.equals(other.getOf())) {
                return false;
            }
            if (_rro == null) {
                if (other.getRro() != null) {
                    return false;
                }
            } else if(!_rro.equals(other.getRro())) {
                return false;
            }
            if (_xro == null) {
                if (other.getXro() != null) {
                    return false;
                }
            } else if(!_xro.equals(other.getXro())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                PathsImpl otherImpl = (PathsImpl) obj;
                if (augmentation == null) {
                    if (otherImpl.augmentation != null) {
                        return false;
                    }
                } else if(!augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.success._case.success.Paths>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.success._case.success.Paths>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
        
        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Paths [");
            boolean first = true;
        
            if (_bandwidth != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_bandwidth=");
                builder.append(_bandwidth);
             }
            if (_classType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_classType=");
                builder.append(_classType);
             }
            if (_ero != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ero=");
                builder.append(_ero);
             }
            if (_iro != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_iro=");
                builder.append(_iro);
             }
            if (_lspa != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_lspa=");
                builder.append(_lspa);
             }
            if (_metrics != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_metrics=");
                builder.append(_metrics);
             }
            if (_of != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_of=");
                builder.append(_of);
             }
            if (_rro != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_rro=");
                builder.append(_rro);
             }
            if (_xro != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_xro=");
                builder.append(_xro);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
