package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.objects.VendorInformationObject;
import java.util.Collections;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.PathKeyExpansion;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.SegmentComputation;
import java.util.List;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Requests} instances.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Requests
 */
public class RequestsBuilder {

    private PathKeyExpansion _pathKeyExpansion;
    private Rp _rp;
    private SegmentComputation _segmentComputation;
    private List<VendorInformationObject> _vendorInformationObject;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Requests>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Requests>> augmentation = new HashMap<>();

    public RequestsBuilder() {
    } 
    
    public RequestsBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationObjects arg) {
        this._vendorInformationObject = arg.getVendorInformationObject();
    }
    
    public RequestsBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.RpObject arg) {
        this._rp = arg.getRp();
    }

    public RequestsBuilder(Requests base) {
        this._pathKeyExpansion = base.getPathKeyExpansion();
        this._rp = base.getRp();
        this._segmentComputation = base.getSegmentComputation();
        this._vendorInformationObject = base.getVendorInformationObject();
        if (base instanceof RequestsImpl) {
            RequestsImpl _impl = (RequestsImpl) base;
            this.augmentation = new HashMap<>(_impl.augmentation);
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.RpObject</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationObjects</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.RpObject) {
            this._rp = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.RpObject)arg).getRp();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationObjects) {
            this._vendorInformationObject = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationObjects)arg).getVendorInformationObject();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.RpObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationObjects] \n" +
              "but was: " + arg
            );
        }
    }

    public PathKeyExpansion getPathKeyExpansion() {
        return _pathKeyExpansion;
    }
    
    public Rp getRp() {
        return _rp;
    }
    
    public SegmentComputation getSegmentComputation() {
        return _segmentComputation;
    }
    
    public List<VendorInformationObject> getVendorInformationObject() {
        return _vendorInformationObject;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Requests>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public RequestsBuilder setPathKeyExpansion(PathKeyExpansion value) {
        this._pathKeyExpansion = value;
        return this;
    }
    
    public RequestsBuilder setRp(Rp value) {
        this._rp = value;
        return this;
    }
    
    public RequestsBuilder setSegmentComputation(SegmentComputation value) {
        this._segmentComputation = value;
        return this;
    }
    
    public RequestsBuilder setVendorInformationObject(List<VendorInformationObject> value) {
        this._vendorInformationObject = value;
        return this;
    }
    
    public RequestsBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Requests>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Requests> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Requests build() {
        return new RequestsImpl(this);
    }

    private static final class RequestsImpl implements Requests {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Requests> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Requests.class;
        }

        private final PathKeyExpansion _pathKeyExpansion;
        private final Rp _rp;
        private final SegmentComputation _segmentComputation;
        private final List<VendorInformationObject> _vendorInformationObject;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Requests>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Requests>> augmentation = new HashMap<>();

        private RequestsImpl(RequestsBuilder base) {
            this._pathKeyExpansion = base.getPathKeyExpansion();
            this._rp = base.getRp();
            this._segmentComputation = base.getSegmentComputation();
            this._vendorInformationObject = base.getVendorInformationObject();
                switch (base.augmentation.size()) {
                case 0:
                    this.augmentation = Collections.emptyMap();
                    break;
                    case 1:
                        final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Requests>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Requests>> e = base.augmentation.entrySet().iterator().next();
                        this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Requests>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Requests>>singletonMap(e.getKey(), e.getValue());       
                    break;
                default :
                    this.augmentation = new HashMap<>(base.augmentation);
                }
        }

        @Override
        public PathKeyExpansion getPathKeyExpansion() {
            return _pathKeyExpansion;
        }
        
        @Override
        public Rp getRp() {
            return _rp;
        }
        
        @Override
        public SegmentComputation getSegmentComputation() {
            return _segmentComputation;
        }
        
        @Override
        public List<VendorInformationObject> getVendorInformationObject() {
            return _vendorInformationObject;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Requests>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_pathKeyExpansion == null) ? 0 : _pathKeyExpansion.hashCode());
            result = prime * result + ((_rp == null) ? 0 : _rp.hashCode());
            result = prime * result + ((_segmentComputation == null) ? 0 : _segmentComputation.hashCode());
            result = prime * result + ((_vendorInformationObject == null) ? 0 : _vendorInformationObject.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Requests.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Requests other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Requests)obj;
            if (_pathKeyExpansion == null) {
                if (other.getPathKeyExpansion() != null) {
                    return false;
                }
            } else if(!_pathKeyExpansion.equals(other.getPathKeyExpansion())) {
                return false;
            }
            if (_rp == null) {
                if (other.getRp() != null) {
                    return false;
                }
            } else if(!_rp.equals(other.getRp())) {
                return false;
            }
            if (_segmentComputation == null) {
                if (other.getSegmentComputation() != null) {
                    return false;
                }
            } else if(!_segmentComputation.equals(other.getSegmentComputation())) {
                return false;
            }
            if (_vendorInformationObject == null) {
                if (other.getVendorInformationObject() != null) {
                    return false;
                }
            } else if(!_vendorInformationObject.equals(other.getVendorInformationObject())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                RequestsImpl otherImpl = (RequestsImpl) obj;
                if (augmentation == null) {
                    if (otherImpl.augmentation != null) {
                        return false;
                    }
                } else if(!augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Requests>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Requests>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
        
        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Requests [");
            boolean first = true;
        
            if (_pathKeyExpansion != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_pathKeyExpansion=");
                builder.append(_pathKeyExpansion);
             }
            if (_rp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_rp=");
                builder.append(_rp);
             }
            if (_segmentComputation != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_segmentComputation=");
                builder.append(_segmentComputation);
             }
            if (_vendorInformationObject != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_vendorInformationObject=");
                builder.append(_vendorInformationObject);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
