package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation;
import java.util.Collections;
import java.util.Map;
import java.util.HashMap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.object.EndpointsObj;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.load.balancing.object.LoadBalancing;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.classtype.object.ClassType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.objects.VendorInformationObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.include.route.object.Iro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.p2p.ReportedRoute;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lsp.attributes.Metrics;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.exclude.route.object.Xro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.of.object.Of;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reported.route.object.Rro;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.bandwidth.object.Bandwidth;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p} instances.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p
 */
public class P2pBuilder {

    private Bandwidth _bandwidth;
    private ClassType _classType;
    private EndpointsObj _endpointsObj;
    private Iro _iro;
    private LoadBalancing _loadBalancing;
    private Lspa _lspa;
    private List<Metrics> _metrics;
    private Of _of;
    private ReportedRoute _reportedRoute;
    private Rro _rro;
    private List<VendorInformationObject> _vendorInformationObject;
    private Xro _xro;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p>> augmentation = new HashMap<>();

    public P2pBuilder() {
    } 
    
    public P2pBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LoadBalancingObject arg) {
        this._loadBalancing = arg.getLoadBalancing();
    }
    
    public P2pBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationObjects arg) {
        this._vendorInformationObject = arg.getVendorInformationObject();
    }
    
    public P2pBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.EndpointsObject arg) {
        this._endpointsObj = arg.getEndpointsObj();
    }
    
    public P2pBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LspAttributes arg) {
        this._metrics = arg.getMetrics();
        this._xro = arg.getXro();
        this._rro = arg.getRro();
        this._bandwidth = arg.getBandwidth();
        this._of = arg.getOf();
        this._iro = arg.getIro();
        this._classType = arg.getClassType();
        this._lspa = arg.getLspa();
    }
    
    public P2pBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ExcludeRouteObject arg) {
        this._xro = arg.getXro();
    }
    
    public P2pBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ReportedRouteObject arg) {
        this._rro = arg.getRro();
    }
    
    public P2pBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.BandwidthObject arg) {
        this._bandwidth = arg.getBandwidth();
    }
    
    public P2pBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OfObject arg) {
        this._of = arg.getOf();
    }
    
    public P2pBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.IncludeRouteObject arg) {
        this._iro = arg.getIro();
    }
    
    public P2pBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ClasstypeObject arg) {
        this._classType = arg.getClassType();
    }
    
    public P2pBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LspaObject arg) {
        this._lspa = arg.getLspa();
    }

    public P2pBuilder(P2p base) {
        this._bandwidth = base.getBandwidth();
        this._classType = base.getClassType();
        this._endpointsObj = base.getEndpointsObj();
        this._iro = base.getIro();
        this._loadBalancing = base.getLoadBalancing();
        this._lspa = base.getLspa();
        this._metrics = base.getMetrics();
        this._of = base.getOf();
        this._reportedRoute = base.getReportedRoute();
        this._rro = base.getRro();
        this._vendorInformationObject = base.getVendorInformationObject();
        this._xro = base.getXro();
        if (base instanceof P2pImpl) {
            P2pImpl _impl = (P2pImpl) base;
            this.augmentation = new HashMap<>(_impl.augmentation);
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OfObject</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.EndpointsObject</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ExcludeRouteObject</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ClasstypeObject</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LspaObject</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LspAttributes</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ReportedRouteObject</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.BandwidthObject</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationObjects</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LoadBalancingObject</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.IncludeRouteObject</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OfObject) {
            this._of = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OfObject)arg).getOf();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.EndpointsObject) {
            this._endpointsObj = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.EndpointsObject)arg).getEndpointsObj();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ExcludeRouteObject) {
            this._xro = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ExcludeRouteObject)arg).getXro();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ClasstypeObject) {
            this._classType = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ClasstypeObject)arg).getClassType();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LspaObject) {
            this._lspa = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LspaObject)arg).getLspa();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LspAttributes) {
            this._metrics = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LspAttributes)arg).getMetrics();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ReportedRouteObject) {
            this._rro = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ReportedRouteObject)arg).getRro();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.BandwidthObject) {
            this._bandwidth = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.BandwidthObject)arg).getBandwidth();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationObjects) {
            this._vendorInformationObject = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationObjects)arg).getVendorInformationObject();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LoadBalancingObject) {
            this._loadBalancing = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LoadBalancingObject)arg).getLoadBalancing();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.IncludeRouteObject) {
            this._iro = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.IncludeRouteObject)arg).getIro();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OfObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.EndpointsObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ExcludeRouteObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ClasstypeObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LspaObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LspAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ReportedRouteObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.BandwidthObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationObjects, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LoadBalancingObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.IncludeRouteObject] \n" +
              "but was: " + arg
            );
        }
    }

    public Bandwidth getBandwidth() {
        return _bandwidth;
    }
    
    public ClassType getClassType() {
        return _classType;
    }
    
    public EndpointsObj getEndpointsObj() {
        return _endpointsObj;
    }
    
    public Iro getIro() {
        return _iro;
    }
    
    public LoadBalancing getLoadBalancing() {
        return _loadBalancing;
    }
    
    public Lspa getLspa() {
        return _lspa;
    }
    
    public List<Metrics> getMetrics() {
        return _metrics;
    }
    
    public Of getOf() {
        return _of;
    }
    
    public ReportedRoute getReportedRoute() {
        return _reportedRoute;
    }
    
    public Rro getRro() {
        return _rro;
    }
    
    public List<VendorInformationObject> getVendorInformationObject() {
        return _vendorInformationObject;
    }
    
    public Xro getXro() {
        return _xro;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public P2pBuilder setBandwidth(Bandwidth value) {
        this._bandwidth = value;
        return this;
    }
    
    public P2pBuilder setClassType(ClassType value) {
        this._classType = value;
        return this;
    }
    
    public P2pBuilder setEndpointsObj(EndpointsObj value) {
        this._endpointsObj = value;
        return this;
    }
    
    public P2pBuilder setIro(Iro value) {
        this._iro = value;
        return this;
    }
    
    public P2pBuilder setLoadBalancing(LoadBalancing value) {
        this._loadBalancing = value;
        return this;
    }
    
    public P2pBuilder setLspa(Lspa value) {
        this._lspa = value;
        return this;
    }
    
    public P2pBuilder setMetrics(List<Metrics> value) {
        this._metrics = value;
        return this;
    }
    
    public P2pBuilder setOf(Of value) {
        this._of = value;
        return this;
    }
    
    public P2pBuilder setReportedRoute(ReportedRoute value) {
        this._reportedRoute = value;
        return this;
    }
    
    public P2pBuilder setRro(Rro value) {
        this._rro = value;
        return this;
    }
    
    public P2pBuilder setVendorInformationObject(List<VendorInformationObject> value) {
        this._vendorInformationObject = value;
        return this;
    }
    
    public P2pBuilder setXro(Xro value) {
        this._xro = value;
        return this;
    }
    
    public P2pBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public P2p build() {
        return new P2pImpl(this);
    }

    private static final class P2pImpl implements P2p {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p.class;
        }

        private final Bandwidth _bandwidth;
        private final ClassType _classType;
        private final EndpointsObj _endpointsObj;
        private final Iro _iro;
        private final LoadBalancing _loadBalancing;
        private final Lspa _lspa;
        private final List<Metrics> _metrics;
        private final Of _of;
        private final ReportedRoute _reportedRoute;
        private final Rro _rro;
        private final List<VendorInformationObject> _vendorInformationObject;
        private final Xro _xro;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p>> augmentation = new HashMap<>();

        private P2pImpl(P2pBuilder base) {
            this._bandwidth = base.getBandwidth();
            this._classType = base.getClassType();
            this._endpointsObj = base.getEndpointsObj();
            this._iro = base.getIro();
            this._loadBalancing = base.getLoadBalancing();
            this._lspa = base.getLspa();
            this._metrics = base.getMetrics();
            this._of = base.getOf();
            this._reportedRoute = base.getReportedRoute();
            this._rro = base.getRro();
            this._vendorInformationObject = base.getVendorInformationObject();
            this._xro = base.getXro();
                switch (base.augmentation.size()) {
                case 0:
                    this.augmentation = Collections.emptyMap();
                    break;
                    case 1:
                        final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p>> e = base.augmentation.entrySet().iterator().next();
                        this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p>>singletonMap(e.getKey(), e.getValue());       
                    break;
                default :
                    this.augmentation = new HashMap<>(base.augmentation);
                }
        }

        @Override
        public Bandwidth getBandwidth() {
            return _bandwidth;
        }
        
        @Override
        public ClassType getClassType() {
            return _classType;
        }
        
        @Override
        public EndpointsObj getEndpointsObj() {
            return _endpointsObj;
        }
        
        @Override
        public Iro getIro() {
            return _iro;
        }
        
        @Override
        public LoadBalancing getLoadBalancing() {
            return _loadBalancing;
        }
        
        @Override
        public Lspa getLspa() {
            return _lspa;
        }
        
        @Override
        public List<Metrics> getMetrics() {
            return _metrics;
        }
        
        @Override
        public Of getOf() {
            return _of;
        }
        
        @Override
        public ReportedRoute getReportedRoute() {
            return _reportedRoute;
        }
        
        @Override
        public Rro getRro() {
            return _rro;
        }
        
        @Override
        public List<VendorInformationObject> getVendorInformationObject() {
            return _vendorInformationObject;
        }
        
        @Override
        public Xro getXro() {
            return _xro;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_bandwidth == null) ? 0 : _bandwidth.hashCode());
            result = prime * result + ((_classType == null) ? 0 : _classType.hashCode());
            result = prime * result + ((_endpointsObj == null) ? 0 : _endpointsObj.hashCode());
            result = prime * result + ((_iro == null) ? 0 : _iro.hashCode());
            result = prime * result + ((_loadBalancing == null) ? 0 : _loadBalancing.hashCode());
            result = prime * result + ((_lspa == null) ? 0 : _lspa.hashCode());
            result = prime * result + ((_metrics == null) ? 0 : _metrics.hashCode());
            result = prime * result + ((_of == null) ? 0 : _of.hashCode());
            result = prime * result + ((_reportedRoute == null) ? 0 : _reportedRoute.hashCode());
            result = prime * result + ((_rro == null) ? 0 : _rro.hashCode());
            result = prime * result + ((_vendorInformationObject == null) ? 0 : _vendorInformationObject.hashCode());
            result = prime * result + ((_xro == null) ? 0 : _xro.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p)obj;
            if (_bandwidth == null) {
                if (other.getBandwidth() != null) {
                    return false;
                }
            } else if(!_bandwidth.equals(other.getBandwidth())) {
                return false;
            }
            if (_classType == null) {
                if (other.getClassType() != null) {
                    return false;
                }
            } else if(!_classType.equals(other.getClassType())) {
                return false;
            }
            if (_endpointsObj == null) {
                if (other.getEndpointsObj() != null) {
                    return false;
                }
            } else if(!_endpointsObj.equals(other.getEndpointsObj())) {
                return false;
            }
            if (_iro == null) {
                if (other.getIro() != null) {
                    return false;
                }
            } else if(!_iro.equals(other.getIro())) {
                return false;
            }
            if (_loadBalancing == null) {
                if (other.getLoadBalancing() != null) {
                    return false;
                }
            } else if(!_loadBalancing.equals(other.getLoadBalancing())) {
                return false;
            }
            if (_lspa == null) {
                if (other.getLspa() != null) {
                    return false;
                }
            } else if(!_lspa.equals(other.getLspa())) {
                return false;
            }
            if (_metrics == null) {
                if (other.getMetrics() != null) {
                    return false;
                }
            } else if(!_metrics.equals(other.getMetrics())) {
                return false;
            }
            if (_of == null) {
                if (other.getOf() != null) {
                    return false;
                }
            } else if(!_of.equals(other.getOf())) {
                return false;
            }
            if (_reportedRoute == null) {
                if (other.getReportedRoute() != null) {
                    return false;
                }
            } else if(!_reportedRoute.equals(other.getReportedRoute())) {
                return false;
            }
            if (_rro == null) {
                if (other.getRro() != null) {
                    return false;
                }
            } else if(!_rro.equals(other.getRro())) {
                return false;
            }
            if (_vendorInformationObject == null) {
                if (other.getVendorInformationObject() != null) {
                    return false;
                }
            } else if(!_vendorInformationObject.equals(other.getVendorInformationObject())) {
                return false;
            }
            if (_xro == null) {
                if (other.getXro() != null) {
                    return false;
                }
            } else if(!_xro.equals(other.getXro())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                P2pImpl otherImpl = (P2pImpl) obj;
                if (augmentation == null) {
                    if (otherImpl.augmentation != null) {
                        return false;
                    }
                } else if(!augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
        
        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("P2p [");
            boolean first = true;
        
            if (_bandwidth != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_bandwidth=");
                builder.append(_bandwidth);
             }
            if (_classType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_classType=");
                builder.append(_classType);
             }
            if (_endpointsObj != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_endpointsObj=");
                builder.append(_endpointsObj);
             }
            if (_iro != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_iro=");
                builder.append(_iro);
             }
            if (_loadBalancing != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_loadBalancing=");
                builder.append(_loadBalancing);
             }
            if (_lspa != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_lspa=");
                builder.append(_lspa);
             }
            if (_metrics != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_metrics=");
                builder.append(_metrics);
             }
            if (_of != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_of=");
                builder.append(_of);
             }
            if (_reportedRoute != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_reportedRoute=");
                builder.append(_reportedRoute);
             }
            if (_rro != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_rro=");
                builder.append(_rro);
             }
            if (_vendorInformationObject != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_vendorInformationObject=");
                builder.append(_vendorInformationObject);
             }
            if (_xro != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_xro=");
                builder.append(_xro);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
