package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object;
import com.google.common.collect.Range;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.RequestId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.rp.Tlvs;
import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.util.List;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp} instances.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp
 */
public class RpBuilder {

    private java.lang.Short _priority;
    private static List<Range<BigInteger>> _priority_range;
    private RequestId _requestId;
    private static List<Range<BigInteger>> _requestId_range;
    private Tlvs _tlvs;
    private java.lang.Boolean _biDirectional;
    private java.lang.Boolean _eroCompression;
    private java.lang.Boolean _fragmentation;
    private java.lang.Boolean _ignore;
    private java.lang.Boolean _loose;
    private java.lang.Boolean _makeBeforeBreak;
    private java.lang.Boolean _order;
    private java.lang.Boolean _p2mp;
    private java.lang.Boolean _pathKey;
    private java.lang.Boolean _processingRule;
    private java.lang.Boolean _reoptimization;
    private java.lang.Boolean _supplyOf;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp>> augmentation = new HashMap<>();

    public RpBuilder() {
    } 
    
    
    public RpBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public RpBuilder(Rp base) {
        this._priority = base.getPriority();
        this._requestId = base.getRequestId();
        this._tlvs = base.getTlvs();
        this._biDirectional = base.isBiDirectional();
        this._eroCompression = base.isEroCompression();
        this._fragmentation = base.isFragmentation();
        this._ignore = base.isIgnore();
        this._loose = base.isLoose();
        this._makeBeforeBreak = base.isMakeBeforeBreak();
        this._order = base.isOrder();
        this._p2mp = base.isP2mp();
        this._pathKey = base.isPathKey();
        this._processingRule = base.isProcessingRule();
        this._reoptimization = base.isReoptimization();
        this._supplyOf = base.isSupplyOf();
        if (base instanceof RpImpl) {
            RpImpl _impl = (RpImpl) base;
            this.augmentation = new HashMap<>(_impl.augmentation);
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader) {
            this._processingRule = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader)arg).isProcessingRule();
            this._ignore = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader] \n" +
              "but was: " + arg
            );
        }
    }

    public java.lang.Short getPriority() {
        return _priority;
    }
    
    public RequestId getRequestId() {
        return _requestId;
    }
    
    public Tlvs getTlvs() {
        return _tlvs;
    }
    
    public java.lang.Boolean isBiDirectional() {
        return _biDirectional;
    }
    
    public java.lang.Boolean isEroCompression() {
        return _eroCompression;
    }
    
    public java.lang.Boolean isFragmentation() {
        return _fragmentation;
    }
    
    public java.lang.Boolean isIgnore() {
        return _ignore;
    }
    
    public java.lang.Boolean isLoose() {
        return _loose;
    }
    
    public java.lang.Boolean isMakeBeforeBreak() {
        return _makeBeforeBreak;
    }
    
    public java.lang.Boolean isOrder() {
        return _order;
    }
    
    public java.lang.Boolean isP2mp() {
        return _p2mp;
    }
    
    public java.lang.Boolean isPathKey() {
        return _pathKey;
    }
    
    public java.lang.Boolean isProcessingRule() {
        return _processingRule;
    }
    
    public java.lang.Boolean isReoptimization() {
        return _reoptimization;
    }
    
    public java.lang.Boolean isSupplyOf() {
        return _supplyOf;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public RpBuilder setPriority(java.lang.Short value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value);
            boolean isValidRange = false;
            for (Range<BigInteger> r : _priority_range()) {
                if (r.contains(_constraint)) {
                    isValidRange = true;
                }
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _priority_range));
            }
        }
        this._priority = value;
        return this;
    }
    public static List<Range<BigInteger>> _priority_range() {
        if (_priority_range == null) {
            synchronized (RpBuilder.class) {
                if (_priority_range == null) {
                    ImmutableList.Builder<Range<BigInteger>> builder = ImmutableList.builder();
                    builder.add(Range.closed(BigInteger.ONE, BigInteger.valueOf(7L)));
                    _priority_range = builder.build();
                }
            }
        }
        return _priority_range;
    }
    
    public RpBuilder setRequestId(RequestId value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.getValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : _requestId_range()) {
                if (r.contains(_constraint)) {
                    isValidRange = true;
                }
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _requestId_range));
            }
        }
        this._requestId = value;
        return this;
    }
    public static List<Range<BigInteger>> _requestId_range() {
        if (_requestId_range == null) {
            synchronized (RpBuilder.class) {
                if (_requestId_range == null) {
                    ImmutableList.Builder<Range<BigInteger>> builder = ImmutableList.builder();
                    builder.add(Range.closed(BigInteger.ONE, BigInteger.valueOf(4294967295L)));
                    _requestId_range = builder.build();
                }
            }
        }
        return _requestId_range;
    }
    
    public RpBuilder setTlvs(Tlvs value) {
        this._tlvs = value;
        return this;
    }
    
    public RpBuilder setBiDirectional(java.lang.Boolean value) {
        this._biDirectional = value;
        return this;
    }
    
    public RpBuilder setEroCompression(java.lang.Boolean value) {
        this._eroCompression = value;
        return this;
    }
    
    public RpBuilder setFragmentation(java.lang.Boolean value) {
        this._fragmentation = value;
        return this;
    }
    
    public RpBuilder setIgnore(java.lang.Boolean value) {
        this._ignore = value;
        return this;
    }
    
    public RpBuilder setLoose(java.lang.Boolean value) {
        this._loose = value;
        return this;
    }
    
    public RpBuilder setMakeBeforeBreak(java.lang.Boolean value) {
        this._makeBeforeBreak = value;
        return this;
    }
    
    public RpBuilder setOrder(java.lang.Boolean value) {
        this._order = value;
        return this;
    }
    
    public RpBuilder setP2mp(java.lang.Boolean value) {
        this._p2mp = value;
        return this;
    }
    
    public RpBuilder setPathKey(java.lang.Boolean value) {
        this._pathKey = value;
        return this;
    }
    
    public RpBuilder setProcessingRule(java.lang.Boolean value) {
        this._processingRule = value;
        return this;
    }
    
    public RpBuilder setReoptimization(java.lang.Boolean value) {
        this._reoptimization = value;
        return this;
    }
    
    public RpBuilder setSupplyOf(java.lang.Boolean value) {
        this._supplyOf = value;
        return this;
    }
    
    public RpBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Rp build() {
        return new RpImpl(this);
    }

    private static final class RpImpl implements Rp {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp.class;
        }

        private final java.lang.Short _priority;
        private final RequestId _requestId;
        private final Tlvs _tlvs;
        private final java.lang.Boolean _biDirectional;
        private final java.lang.Boolean _eroCompression;
        private final java.lang.Boolean _fragmentation;
        private final java.lang.Boolean _ignore;
        private final java.lang.Boolean _loose;
        private final java.lang.Boolean _makeBeforeBreak;
        private final java.lang.Boolean _order;
        private final java.lang.Boolean _p2mp;
        private final java.lang.Boolean _pathKey;
        private final java.lang.Boolean _processingRule;
        private final java.lang.Boolean _reoptimization;
        private final java.lang.Boolean _supplyOf;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp>> augmentation = new HashMap<>();

        private RpImpl(RpBuilder base) {
            this._priority = base.getPriority();
            this._requestId = base.getRequestId();
            this._tlvs = base.getTlvs();
            this._biDirectional = base.isBiDirectional();
            this._eroCompression = base.isEroCompression();
            this._fragmentation = base.isFragmentation();
            this._ignore = base.isIgnore();
            this._loose = base.isLoose();
            this._makeBeforeBreak = base.isMakeBeforeBreak();
            this._order = base.isOrder();
            this._p2mp = base.isP2mp();
            this._pathKey = base.isPathKey();
            this._processingRule = base.isProcessingRule();
            this._reoptimization = base.isReoptimization();
            this._supplyOf = base.isSupplyOf();
                switch (base.augmentation.size()) {
                case 0:
                    this.augmentation = Collections.emptyMap();
                    break;
                    case 1:
                        final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp>> e = base.augmentation.entrySet().iterator().next();
                        this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp>>singletonMap(e.getKey(), e.getValue());       
                    break;
                default :
                    this.augmentation = new HashMap<>(base.augmentation);
                }
        }

        @Override
        public java.lang.Short getPriority() {
            return _priority;
        }
        
        @Override
        public RequestId getRequestId() {
            return _requestId;
        }
        
        @Override
        public Tlvs getTlvs() {
            return _tlvs;
        }
        
        @Override
        public java.lang.Boolean isBiDirectional() {
            return _biDirectional;
        }
        
        @Override
        public java.lang.Boolean isEroCompression() {
            return _eroCompression;
        }
        
        @Override
        public java.lang.Boolean isFragmentation() {
            return _fragmentation;
        }
        
        @Override
        public java.lang.Boolean isIgnore() {
            return _ignore;
        }
        
        @Override
        public java.lang.Boolean isLoose() {
            return _loose;
        }
        
        @Override
        public java.lang.Boolean isMakeBeforeBreak() {
            return _makeBeforeBreak;
        }
        
        @Override
        public java.lang.Boolean isOrder() {
            return _order;
        }
        
        @Override
        public java.lang.Boolean isP2mp() {
            return _p2mp;
        }
        
        @Override
        public java.lang.Boolean isPathKey() {
            return _pathKey;
        }
        
        @Override
        public java.lang.Boolean isProcessingRule() {
            return _processingRule;
        }
        
        @Override
        public java.lang.Boolean isReoptimization() {
            return _reoptimization;
        }
        
        @Override
        public java.lang.Boolean isSupplyOf() {
            return _supplyOf;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_priority == null) ? 0 : _priority.hashCode());
            result = prime * result + ((_requestId == null) ? 0 : _requestId.hashCode());
            result = prime * result + ((_tlvs == null) ? 0 : _tlvs.hashCode());
            result = prime * result + ((_biDirectional == null) ? 0 : _biDirectional.hashCode());
            result = prime * result + ((_eroCompression == null) ? 0 : _eroCompression.hashCode());
            result = prime * result + ((_fragmentation == null) ? 0 : _fragmentation.hashCode());
            result = prime * result + ((_ignore == null) ? 0 : _ignore.hashCode());
            result = prime * result + ((_loose == null) ? 0 : _loose.hashCode());
            result = prime * result + ((_makeBeforeBreak == null) ? 0 : _makeBeforeBreak.hashCode());
            result = prime * result + ((_order == null) ? 0 : _order.hashCode());
            result = prime * result + ((_p2mp == null) ? 0 : _p2mp.hashCode());
            result = prime * result + ((_pathKey == null) ? 0 : _pathKey.hashCode());
            result = prime * result + ((_processingRule == null) ? 0 : _processingRule.hashCode());
            result = prime * result + ((_reoptimization == null) ? 0 : _reoptimization.hashCode());
            result = prime * result + ((_supplyOf == null) ? 0 : _supplyOf.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp)obj;
            if (_priority == null) {
                if (other.getPriority() != null) {
                    return false;
                }
            } else if(!_priority.equals(other.getPriority())) {
                return false;
            }
            if (_requestId == null) {
                if (other.getRequestId() != null) {
                    return false;
                }
            } else if(!_requestId.equals(other.getRequestId())) {
                return false;
            }
            if (_tlvs == null) {
                if (other.getTlvs() != null) {
                    return false;
                }
            } else if(!_tlvs.equals(other.getTlvs())) {
                return false;
            }
            if (_biDirectional == null) {
                if (other.isBiDirectional() != null) {
                    return false;
                }
            } else if(!_biDirectional.equals(other.isBiDirectional())) {
                return false;
            }
            if (_eroCompression == null) {
                if (other.isEroCompression() != null) {
                    return false;
                }
            } else if(!_eroCompression.equals(other.isEroCompression())) {
                return false;
            }
            if (_fragmentation == null) {
                if (other.isFragmentation() != null) {
                    return false;
                }
            } else if(!_fragmentation.equals(other.isFragmentation())) {
                return false;
            }
            if (_ignore == null) {
                if (other.isIgnore() != null) {
                    return false;
                }
            } else if(!_ignore.equals(other.isIgnore())) {
                return false;
            }
            if (_loose == null) {
                if (other.isLoose() != null) {
                    return false;
                }
            } else if(!_loose.equals(other.isLoose())) {
                return false;
            }
            if (_makeBeforeBreak == null) {
                if (other.isMakeBeforeBreak() != null) {
                    return false;
                }
            } else if(!_makeBeforeBreak.equals(other.isMakeBeforeBreak())) {
                return false;
            }
            if (_order == null) {
                if (other.isOrder() != null) {
                    return false;
                }
            } else if(!_order.equals(other.isOrder())) {
                return false;
            }
            if (_p2mp == null) {
                if (other.isP2mp() != null) {
                    return false;
                }
            } else if(!_p2mp.equals(other.isP2mp())) {
                return false;
            }
            if (_pathKey == null) {
                if (other.isPathKey() != null) {
                    return false;
                }
            } else if(!_pathKey.equals(other.isPathKey())) {
                return false;
            }
            if (_processingRule == null) {
                if (other.isProcessingRule() != null) {
                    return false;
                }
            } else if(!_processingRule.equals(other.isProcessingRule())) {
                return false;
            }
            if (_reoptimization == null) {
                if (other.isReoptimization() != null) {
                    return false;
                }
            } else if(!_reoptimization.equals(other.isReoptimization())) {
                return false;
            }
            if (_supplyOf == null) {
                if (other.isSupplyOf() != null) {
                    return false;
                }
            } else if(!_supplyOf.equals(other.isSupplyOf())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                RpImpl otherImpl = (RpImpl) obj;
                if (augmentation == null) {
                    if (otherImpl.augmentation != null) {
                        return false;
                    }
                } else if(!augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
        
        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Rp [");
            boolean first = true;
        
            if (_priority != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_priority=");
                builder.append(_priority);
             }
            if (_requestId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_requestId=");
                builder.append(_requestId);
             }
            if (_tlvs != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tlvs=");
                builder.append(_tlvs);
             }
            if (_biDirectional != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_biDirectional=");
                builder.append(_biDirectional);
             }
            if (_eroCompression != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_eroCompression=");
                builder.append(_eroCompression);
             }
            if (_fragmentation != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_fragmentation=");
                builder.append(_fragmentation);
             }
            if (_ignore != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ignore=");
                builder.append(_ignore);
             }
            if (_loose != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_loose=");
                builder.append(_loose);
             }
            if (_makeBeforeBreak != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_makeBeforeBreak=");
                builder.append(_makeBeforeBreak);
             }
            if (_order != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_order=");
                builder.append(_order);
             }
            if (_p2mp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_p2mp=");
                builder.append(_p2mp);
             }
            if (_pathKey != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_pathKey=");
                builder.append(_pathKey);
             }
            if (_processingRule != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_processingRule=");
                builder.append(_processingRule);
             }
            if (_reoptimization != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_reoptimization=");
                builder.append(_reoptimization);
             }
            if (_supplyOf != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_supplyOf=");
                builder.append(_supplyOf);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
