/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;

public class ClassType
implements Serializable {
    private static final long serialVersionUID = 7216175713280286513L;
    private static final List<Range<BigInteger>> _range;
    private final Short _value;

    @ConstructorProperties(value={"value"})
    public ClassType(Short _value) {
        if (_value != null) {
            BigInteger _constraint = BigInteger.valueOf(_value.shortValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : ClassType.range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", _value, ClassType.range()));
            }
        }
        Preconditions.checkNotNull((Object)_value, (Object)"Supplied value may not be null");
        this._value = _value;
    }

    public ClassType(ClassType source) {
        this._value = source._value;
    }

    public static ClassType getDefaultInstance(String defaultValue) {
        return new ClassType(Short.valueOf(defaultValue));
    }

    public Short getValue() {
        return this._value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._value == null ? 0 : this._value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassType other = (ClassType)obj;
        return !(this._value == null ? other._value != null : !this._value.equals(other._value));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(ClassType.class.getSimpleName()).append(" [");
        boolean first = true;
        if (this._value != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_value=");
            builder.append(this._value);
        }
        return builder.append(']').toString();
    }

    public static List<Range<BigInteger>> range() {
        return _range;
    }

    static {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)Range.closed((Comparable)BigInteger.ONE, (Comparable)BigInteger.valueOf(7L)));
        _range = builder.build();
    }
}

