/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;

public class PathKey
implements Serializable {
    private static final long serialVersionUID = 1330045814905353022L;
    private static final List<Range<BigInteger>> _range;
    private final Integer _value;

    @ConstructorProperties(value={"value"})
    public PathKey(Integer _value) {
        if (_value != null) {
            BigInteger _constraint = BigInteger.valueOf(_value.intValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : PathKey.range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", _value, PathKey.range()));
            }
        }
        Preconditions.checkNotNull((Object)_value, (Object)"Supplied value may not be null");
        this._value = _value;
    }

    public PathKey(PathKey source) {
        this._value = source._value;
    }

    public static PathKey getDefaultInstance(String defaultValue) {
        return new PathKey(Integer.valueOf(defaultValue));
    }

    public Integer getValue() {
        return this._value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._value == null ? 0 : this._value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathKey other = (PathKey)obj;
        return !(this._value == null ? other._value != null : !this._value.equals(other._value));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(PathKey.class.getSimpleName()).append(" [");
        boolean first = true;
        if (this._value != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_value=");
            builder.append(this._value);
        }
        return builder.append(']').toString();
    }

    public static List<Range<BigInteger>> range() {
        return _range;
    }

    static {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        _range = builder.build();
    }
}

