/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.close.object;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.close.object.CClose;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.close.object.c.close.Tlvs;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class CCloseBuilder {
    private Short _reason;
    private static List<Range<BigInteger>> _reason_range;
    private Tlvs _tlvs;
    private Boolean _ignore;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<CClose>>, Augmentation<CClose>> augmentation = new HashMap<Class<? extends Augmentation<CClose>>, Augmentation<CClose>>();

    public CCloseBuilder() {
    }

    public CCloseBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public CCloseBuilder(CClose base) {
        this._reason = base.getReason();
        this._tlvs = base.getTlvs();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
        if (base instanceof CCloseImpl) {
            CCloseImpl _impl = (CCloseImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<CClose>>, Augmentation<CClose>>(_impl.augmentation);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader] \nbut was: " + arg);
        }
    }

    public Short getReason() {
        return this._reason;
    }

    public Tlvs getTlvs() {
        return this._tlvs;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public <E extends Augmentation<CClose>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public CCloseBuilder setReason(Short value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.shortValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : CCloseBuilder._reason_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _reason_range));
            }
        }
        this._reason = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _reason_range() {
        if (_reason_range != null) return _reason_range;
        Class<CCloseBuilder> clazz = CCloseBuilder.class;
        synchronized (CCloseBuilder.class) {
            if (_reason_range != null) return _reason_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
            _reason_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _reason_range;
        }
    }

    public CCloseBuilder setTlvs(Tlvs value) {
        this._tlvs = value;
        return this;
    }

    public CCloseBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public CCloseBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public CCloseBuilder addAugmentation(Class<? extends Augmentation<CClose>> augmentationType, Augmentation<CClose> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public CClose build() {
        return new CCloseImpl(this);
    }

    private static final class CCloseImpl
    implements CClose {
        private final Short _reason;
        private final Tlvs _tlvs;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private Map<Class<? extends Augmentation<CClose>>, Augmentation<CClose>> augmentation = new HashMap<Class<? extends Augmentation<CClose>>, Augmentation<CClose>>();

        public Class<CClose> getImplementedInterface() {
            return CClose.class;
        }

        private CCloseImpl(CCloseBuilder base) {
            this._reason = base.getReason();
            this._tlvs = base.getTlvs();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<CClose>>, Augmentation<CClose>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<CClose>>, Augmentation<CClose>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getReason() {
            return this._reason;
        }

        @Override
        public Tlvs getTlvs() {
            return this._tlvs;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        public <E extends Augmentation<CClose>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._reason == null ? 0 : this._reason.hashCode());
            result = 31 * result + (this._tlvs == null ? 0 : this._tlvs.hashCode());
            result = 31 * result + (this._ignore == null ? 0 : this._ignore.hashCode());
            result = 31 * result + (this._processingRule == null ? 0 : this._processingRule.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!CClose.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            CClose other = (CClose)obj;
            if (this._reason == null ? other.getReason() != null : !this._reason.equals(other.getReason())) {
                return false;
            }
            if (this._tlvs == null ? other.getTlvs() != null : !this._tlvs.equals(other.getTlvs())) {
                return false;
            }
            if (this._ignore == null ? other.isIgnore() != null : !this._ignore.equals(other.isIgnore())) {
                return false;
            }
            if (this._processingRule == null ? other.isProcessingRule() != null : !this._processingRule.equals(other.isProcessingRule())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                CCloseImpl otherImpl = (CCloseImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<CClose>>, Augmentation<CClose>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("CClose [");
            boolean first = true;
            if (this._reason != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_reason=");
                builder.append(this._reason);
            }
            if (this._tlvs != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tlvs=");
                builder.append(this._tlvs);
            }
            if (this._ignore != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ignore=");
                builder.append(this._ignore);
            }
            if (this._processingRule != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_processingRule=");
                builder.append(this._processingRule);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

