/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.address.family.ipv4._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.address.family.ipv4._case.Ipv4;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class Ipv4Builder {
    private Ipv4Address _destinationIpv4Address;
    private Ipv4Address _sourceIpv4Address;
    Map<Class<? extends Augmentation<Ipv4>>, Augmentation<Ipv4>> augmentation = new HashMap<Class<? extends Augmentation<Ipv4>>, Augmentation<Ipv4>>();

    public Ipv4Builder() {
    }

    public Ipv4Builder(Ipv4 base) {
        this._destinationIpv4Address = base.getDestinationIpv4Address();
        this._sourceIpv4Address = base.getSourceIpv4Address();
        if (base instanceof Ipv4Impl) {
            Ipv4Impl _impl = (Ipv4Impl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<Ipv4>>, Augmentation<Ipv4>>(_impl.augmentation);
        }
    }

    public Ipv4Address getDestinationIpv4Address() {
        return this._destinationIpv4Address;
    }

    public Ipv4Address getSourceIpv4Address() {
        return this._sourceIpv4Address;
    }

    public <E extends Augmentation<Ipv4>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public Ipv4Builder setDestinationIpv4Address(Ipv4Address value) {
        this._destinationIpv4Address = value;
        return this;
    }

    public Ipv4Builder setSourceIpv4Address(Ipv4Address value) {
        this._sourceIpv4Address = value;
        return this;
    }

    public Ipv4Builder addAugmentation(Class<? extends Augmentation<Ipv4>> augmentationType, Augmentation<Ipv4> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Ipv4 build() {
        return new Ipv4Impl(this);
    }

    private static final class Ipv4Impl
    implements Ipv4 {
        private final Ipv4Address _destinationIpv4Address;
        private final Ipv4Address _sourceIpv4Address;
        private Map<Class<? extends Augmentation<Ipv4>>, Augmentation<Ipv4>> augmentation = new HashMap<Class<? extends Augmentation<Ipv4>>, Augmentation<Ipv4>>();

        public Class<Ipv4> getImplementedInterface() {
            return Ipv4.class;
        }

        private Ipv4Impl(Ipv4Builder base) {
            this._destinationIpv4Address = base.getDestinationIpv4Address();
            this._sourceIpv4Address = base.getSourceIpv4Address();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Ipv4>>, Augmentation<Ipv4>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Ipv4>>, Augmentation<Ipv4>>(base.augmentation);
                }
            }
        }

        @Override
        public Ipv4Address getDestinationIpv4Address() {
            return this._destinationIpv4Address;
        }

        @Override
        public Ipv4Address getSourceIpv4Address() {
            return this._sourceIpv4Address;
        }

        public <E extends Augmentation<Ipv4>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._destinationIpv4Address == null ? 0 : this._destinationIpv4Address.hashCode());
            result = 31 * result + (this._sourceIpv4Address == null ? 0 : this._sourceIpv4Address.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Ipv4.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Ipv4 other = (Ipv4)obj;
            if (this._destinationIpv4Address == null ? other.getDestinationIpv4Address() != null : !this._destinationIpv4Address.equals((Object)other.getDestinationIpv4Address())) {
                return false;
            }
            if (this._sourceIpv4Address == null ? other.getSourceIpv4Address() != null : !this._sourceIpv4Address.equals((Object)other.getSourceIpv4Address())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                Ipv4Impl otherImpl = (Ipv4Impl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Ipv4>>, Augmentation<Ipv4>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Ipv4 [");
            boolean first = true;
            if (this._destinationIpv4Address != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_destinationIpv4Address=");
                builder.append(this._destinationIpv4Address);
            }
            if (this._sourceIpv4Address != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_sourceIpv4Address=");
                builder.append(this._sourceIpv4Address);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

