/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.address.family.ipv6._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.address.family.ipv6._case.Ipv6;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class Ipv6Builder {
    private Ipv6Address _destinationIpv6Address;
    private Ipv6Address _sourceIpv6Address;
    Map<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>> augmentation = new HashMap<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>>();

    public Ipv6Builder() {
    }

    public Ipv6Builder(Ipv6 base) {
        this._destinationIpv6Address = base.getDestinationIpv6Address();
        this._sourceIpv6Address = base.getSourceIpv6Address();
        if (base instanceof Ipv6Impl) {
            Ipv6Impl _impl = (Ipv6Impl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>>(_impl.augmentation);
        }
    }

    public Ipv6Address getDestinationIpv6Address() {
        return this._destinationIpv6Address;
    }

    public Ipv6Address getSourceIpv6Address() {
        return this._sourceIpv6Address;
    }

    public <E extends Augmentation<Ipv6>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public Ipv6Builder setDestinationIpv6Address(Ipv6Address value) {
        this._destinationIpv6Address = value;
        return this;
    }

    public Ipv6Builder setSourceIpv6Address(Ipv6Address value) {
        this._sourceIpv6Address = value;
        return this;
    }

    public Ipv6Builder addAugmentation(Class<? extends Augmentation<Ipv6>> augmentationType, Augmentation<Ipv6> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Ipv6 build() {
        return new Ipv6Impl(this);
    }

    private static final class Ipv6Impl
    implements Ipv6 {
        private final Ipv6Address _destinationIpv6Address;
        private final Ipv6Address _sourceIpv6Address;
        private Map<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>> augmentation = new HashMap<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>>();

        public Class<Ipv6> getImplementedInterface() {
            return Ipv6.class;
        }

        private Ipv6Impl(Ipv6Builder base) {
            this._destinationIpv6Address = base.getDestinationIpv6Address();
            this._sourceIpv6Address = base.getSourceIpv6Address();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>>(base.augmentation);
                }
            }
        }

        @Override
        public Ipv6Address getDestinationIpv6Address() {
            return this._destinationIpv6Address;
        }

        @Override
        public Ipv6Address getSourceIpv6Address() {
            return this._sourceIpv6Address;
        }

        public <E extends Augmentation<Ipv6>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._destinationIpv6Address == null ? 0 : this._destinationIpv6Address.hashCode());
            result = 31 * result + (this._sourceIpv6Address == null ? 0 : this._sourceIpv6Address.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Ipv6.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Ipv6 other = (Ipv6)obj;
            if (this._destinationIpv6Address == null ? other.getDestinationIpv6Address() != null : !this._destinationIpv6Address.equals((Object)other.getDestinationIpv6Address())) {
                return false;
            }
            if (this._sourceIpv6Address == null ? other.getSourceIpv6Address() != null : !this._sourceIpv6Address.equals((Object)other.getSourceIpv6Address())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                Ipv6Impl otherImpl = (Ipv6Impl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Ipv6 [");
            boolean first = true;
            if (this._destinationIpv6Address != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_destinationIpv6Address=");
                builder.append(this._destinationIpv6Address);
            }
            if (this._sourceIpv6Address != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_sourceIpv6Address=");
                builder.append(this._sourceIpv6Address);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

