/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.object;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Endpoints;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.object.EndpointsObj;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class EndpointsObjBuilder {
    private AddressFamily _addressFamily;
    private Boolean _ignore;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<EndpointsObj>>, Augmentation<EndpointsObj>> augmentation = new HashMap<Class<? extends Augmentation<EndpointsObj>>, Augmentation<EndpointsObj>>();

    public EndpointsObjBuilder() {
    }

    public EndpointsObjBuilder(Endpoints arg) {
        this._addressFamily = arg.getAddressFamily();
    }

    public EndpointsObjBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public EndpointsObjBuilder(EndpointsObj base) {
        this._addressFamily = base.getAddressFamily();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
        if (base instanceof EndpointsObjImpl) {
            EndpointsObjImpl _impl = (EndpointsObjImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<EndpointsObj>>, Augmentation<EndpointsObj>>(_impl.augmentation);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (arg instanceof Endpoints) {
            this._addressFamily = ((Endpoints)arg).getAddressFamily();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Endpoints] \nbut was: " + arg);
        }
    }

    public AddressFamily getAddressFamily() {
        return this._addressFamily;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public <E extends Augmentation<EndpointsObj>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public EndpointsObjBuilder setAddressFamily(AddressFamily value) {
        this._addressFamily = value;
        return this;
    }

    public EndpointsObjBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public EndpointsObjBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public EndpointsObjBuilder addAugmentation(Class<? extends Augmentation<EndpointsObj>> augmentationType, Augmentation<EndpointsObj> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public EndpointsObj build() {
        return new EndpointsObjImpl(this);
    }

    private static final class EndpointsObjImpl
    implements EndpointsObj {
        private final AddressFamily _addressFamily;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private Map<Class<? extends Augmentation<EndpointsObj>>, Augmentation<EndpointsObj>> augmentation = new HashMap<Class<? extends Augmentation<EndpointsObj>>, Augmentation<EndpointsObj>>();

        public Class<EndpointsObj> getImplementedInterface() {
            return EndpointsObj.class;
        }

        private EndpointsObjImpl(EndpointsObjBuilder base) {
            this._addressFamily = base.getAddressFamily();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<EndpointsObj>>, Augmentation<EndpointsObj>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<EndpointsObj>>, Augmentation<EndpointsObj>>(base.augmentation);
                }
            }
        }

        @Override
        public AddressFamily getAddressFamily() {
            return this._addressFamily;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        public <E extends Augmentation<EndpointsObj>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._addressFamily == null ? 0 : this._addressFamily.hashCode());
            result = 31 * result + (this._ignore == null ? 0 : this._ignore.hashCode());
            result = 31 * result + (this._processingRule == null ? 0 : this._processingRule.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!EndpointsObj.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            EndpointsObj other = (EndpointsObj)obj;
            if (this._addressFamily == null ? other.getAddressFamily() != null : !this._addressFamily.equals(other.getAddressFamily())) {
                return false;
            }
            if (this._ignore == null ? other.isIgnore() != null : !this._ignore.equals(other.isIgnore())) {
                return false;
            }
            if (this._processingRule == null ? other.isProcessingRule() != null : !this._processingRule.equals(other.isProcessingRule())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                EndpointsObjImpl otherImpl = (EndpointsObjImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<EndpointsObj>>, Augmentation<EndpointsObj>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("EndpointsObj [");
            boolean first = true;
            if (this._addressFamily != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_addressFamily=");
                builder.append(this._addressFamily);
            }
            if (this._ignore != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ignore=");
                builder.append(this._ignore);
            }
            if (this._processingRule != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_processingRule=");
                builder.append(this._processingRule);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

