/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.exclude.route.object;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.exclude.route.object.Xro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.exclude.route.object.xro.Subobject;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class XroBuilder {
    private Xro.Flags _flags;
    private List<Subobject> _subobject;
    private Boolean _ignore;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<Xro>>, Augmentation<Xro>> augmentation = new HashMap<Class<? extends Augmentation<Xro>>, Augmentation<Xro>>();

    public XroBuilder() {
    }

    public XroBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public XroBuilder(Xro base) {
        this._flags = base.getFlags();
        this._subobject = base.getSubobject();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
        if (base instanceof XroImpl) {
            XroImpl _impl = (XroImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<Xro>>, Augmentation<Xro>>(_impl.augmentation);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader] \nbut was: " + arg);
        }
    }

    public Xro.Flags getFlags() {
        return this._flags;
    }

    public List<Subobject> getSubobject() {
        return this._subobject;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public <E extends Augmentation<Xro>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public XroBuilder setFlags(Xro.Flags value) {
        this._flags = value;
        return this;
    }

    public XroBuilder setSubobject(List<Subobject> value) {
        this._subobject = value;
        return this;
    }

    public XroBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public XroBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public XroBuilder addAugmentation(Class<? extends Augmentation<Xro>> augmentationType, Augmentation<Xro> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Xro build() {
        return new XroImpl(this);
    }

    private static final class XroImpl
    implements Xro {
        private final Xro.Flags _flags;
        private final List<Subobject> _subobject;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private Map<Class<? extends Augmentation<Xro>>, Augmentation<Xro>> augmentation = new HashMap<Class<? extends Augmentation<Xro>>, Augmentation<Xro>>();

        public Class<Xro> getImplementedInterface() {
            return Xro.class;
        }

        private XroImpl(XroBuilder base) {
            this._flags = base.getFlags();
            this._subobject = base.getSubobject();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Xro>>, Augmentation<Xro>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Xro>>, Augmentation<Xro>>(base.augmentation);
                }
            }
        }

        @Override
        public Xro.Flags getFlags() {
            return this._flags;
        }

        @Override
        public List<Subobject> getSubobject() {
            return this._subobject;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        public <E extends Augmentation<Xro>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._flags == null ? 0 : this._flags.hashCode());
            result = 31 * result + (this._subobject == null ? 0 : this._subobject.hashCode());
            result = 31 * result + (this._ignore == null ? 0 : this._ignore.hashCode());
            result = 31 * result + (this._processingRule == null ? 0 : this._processingRule.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Xro.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Xro other = (Xro)obj;
            if (this._flags == null ? other.getFlags() != null : !this._flags.equals(other.getFlags())) {
                return false;
            }
            if (this._subobject == null ? other.getSubobject() != null : !this._subobject.equals(other.getSubobject())) {
                return false;
            }
            if (this._ignore == null ? other.isIgnore() != null : !this._ignore.equals(other.isIgnore())) {
                return false;
            }
            if (this._processingRule == null ? other.isProcessingRule() != null : !this._processingRule.equals(other.isProcessingRule())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                XroImpl otherImpl = (XroImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Xro>>, Augmentation<Xro>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Xro [");
            boolean first = true;
            if (this._flags != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_flags=");
                builder.append(this._flags);
            }
            if (this._subobject != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_subobject=");
                builder.append(this._subobject);
            }
            if (this._ignore != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ignore=");
                builder.append(this._ignore);
            }
            if (this._processingRule != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_processingRule=");
                builder.append(this._processingRule);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

