/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.Gc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.gc.Tlvs;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GcBuilder {
    private Short _maxHop;
    private static List<Range<BigInteger>> _maxHop_range;
    private Short _maxUtilization;
    private static List<Range<BigInteger>> _maxUtilization_range;
    private Short _minUtilization;
    private static List<Range<BigInteger>> _minUtilization_range;
    private Short _overBookingFactor;
    private static List<Range<BigInteger>> _overBookingFactor_range;
    private Tlvs _tlvs;
    private Boolean _ignore;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<Gc>>, Augmentation<Gc>> augmentation = new HashMap<Class<? extends Augmentation<Gc>>, Augmentation<Gc>>();

    public GcBuilder() {
    }

    public GcBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public GcBuilder(Gc base) {
        this._maxHop = base.getMaxHop();
        this._maxUtilization = base.getMaxUtilization();
        this._minUtilization = base.getMinUtilization();
        this._overBookingFactor = base.getOverBookingFactor();
        this._tlvs = base.getTlvs();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
        if (base instanceof GcImpl) {
            GcImpl _impl = (GcImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<Gc>>, Augmentation<Gc>>(_impl.augmentation);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader] \nbut was: " + arg);
        }
    }

    public Short getMaxHop() {
        return this._maxHop;
    }

    public Short getMaxUtilization() {
        return this._maxUtilization;
    }

    public Short getMinUtilization() {
        return this._minUtilization;
    }

    public Short getOverBookingFactor() {
        return this._overBookingFactor;
    }

    public Tlvs getTlvs() {
        return this._tlvs;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public <E extends Augmentation<Gc>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public GcBuilder setMaxHop(Short value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.shortValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : GcBuilder._maxHop_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _maxHop_range));
            }
        }
        this._maxHop = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _maxHop_range() {
        if (_maxHop_range != null) return _maxHop_range;
        Class<GcBuilder> clazz = GcBuilder.class;
        synchronized (GcBuilder.class) {
            if (_maxHop_range != null) return _maxHop_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
            _maxHop_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _maxHop_range;
        }
    }

    public GcBuilder setMaxUtilization(Short value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.shortValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : GcBuilder._maxUtilization_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _maxUtilization_range));
            }
        }
        this._maxUtilization = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _maxUtilization_range() {
        if (_maxUtilization_range != null) return _maxUtilization_range;
        Class<GcBuilder> clazz = GcBuilder.class;
        synchronized (GcBuilder.class) {
            if (_maxUtilization_range != null) return _maxUtilization_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(100L)));
            _maxUtilization_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _maxUtilization_range;
        }
    }

    public GcBuilder setMinUtilization(Short value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.shortValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : GcBuilder._minUtilization_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _minUtilization_range));
            }
        }
        this._minUtilization = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _minUtilization_range() {
        if (_minUtilization_range != null) return _minUtilization_range;
        Class<GcBuilder> clazz = GcBuilder.class;
        synchronized (GcBuilder.class) {
            if (_minUtilization_range != null) return _minUtilization_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(100L)));
            _minUtilization_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _minUtilization_range;
        }
    }

    public GcBuilder setOverBookingFactor(Short value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.shortValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : GcBuilder._overBookingFactor_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _overBookingFactor_range));
            }
        }
        this._overBookingFactor = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _overBookingFactor_range() {
        if (_overBookingFactor_range != null) return _overBookingFactor_range;
        Class<GcBuilder> clazz = GcBuilder.class;
        synchronized (GcBuilder.class) {
            if (_overBookingFactor_range != null) return _overBookingFactor_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(100L)));
            _overBookingFactor_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _overBookingFactor_range;
        }
    }

    public GcBuilder setTlvs(Tlvs value) {
        this._tlvs = value;
        return this;
    }

    public GcBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public GcBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public GcBuilder addAugmentation(Class<? extends Augmentation<Gc>> augmentationType, Augmentation<Gc> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Gc build() {
        return new GcImpl(this);
    }

    private static final class GcImpl
    implements Gc {
        private final Short _maxHop;
        private final Short _maxUtilization;
        private final Short _minUtilization;
        private final Short _overBookingFactor;
        private final Tlvs _tlvs;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private Map<Class<? extends Augmentation<Gc>>, Augmentation<Gc>> augmentation = new HashMap<Class<? extends Augmentation<Gc>>, Augmentation<Gc>>();

        public Class<Gc> getImplementedInterface() {
            return Gc.class;
        }

        private GcImpl(GcBuilder base) {
            this._maxHop = base.getMaxHop();
            this._maxUtilization = base.getMaxUtilization();
            this._minUtilization = base.getMinUtilization();
            this._overBookingFactor = base.getOverBookingFactor();
            this._tlvs = base.getTlvs();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Gc>>, Augmentation<Gc>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Gc>>, Augmentation<Gc>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getMaxHop() {
            return this._maxHop;
        }

        @Override
        public Short getMaxUtilization() {
            return this._maxUtilization;
        }

        @Override
        public Short getMinUtilization() {
            return this._minUtilization;
        }

        @Override
        public Short getOverBookingFactor() {
            return this._overBookingFactor;
        }

        @Override
        public Tlvs getTlvs() {
            return this._tlvs;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        public <E extends Augmentation<Gc>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._maxHop == null ? 0 : this._maxHop.hashCode());
            result = 31 * result + (this._maxUtilization == null ? 0 : this._maxUtilization.hashCode());
            result = 31 * result + (this._minUtilization == null ? 0 : this._minUtilization.hashCode());
            result = 31 * result + (this._overBookingFactor == null ? 0 : this._overBookingFactor.hashCode());
            result = 31 * result + (this._tlvs == null ? 0 : this._tlvs.hashCode());
            result = 31 * result + (this._ignore == null ? 0 : this._ignore.hashCode());
            result = 31 * result + (this._processingRule == null ? 0 : this._processingRule.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Gc.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Gc other = (Gc)obj;
            if (this._maxHop == null ? other.getMaxHop() != null : !this._maxHop.equals(other.getMaxHop())) {
                return false;
            }
            if (this._maxUtilization == null ? other.getMaxUtilization() != null : !this._maxUtilization.equals(other.getMaxUtilization())) {
                return false;
            }
            if (this._minUtilization == null ? other.getMinUtilization() != null : !this._minUtilization.equals(other.getMinUtilization())) {
                return false;
            }
            if (this._overBookingFactor == null ? other.getOverBookingFactor() != null : !this._overBookingFactor.equals(other.getOverBookingFactor())) {
                return false;
            }
            if (this._tlvs == null ? other.getTlvs() != null : !this._tlvs.equals(other.getTlvs())) {
                return false;
            }
            if (this._ignore == null ? other.isIgnore() != null : !this._ignore.equals(other.isIgnore())) {
                return false;
            }
            if (this._processingRule == null ? other.isProcessingRule() != null : !this._processingRule.equals(other.isProcessingRule())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                GcImpl otherImpl = (GcImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Gc>>, Augmentation<Gc>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Gc [");
            boolean first = true;
            if (this._maxHop != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maxHop=");
                builder.append(this._maxHop);
            }
            if (this._maxUtilization != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maxUtilization=");
                builder.append(this._maxUtilization);
            }
            if (this._minUtilization != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_minUtilization=");
                builder.append(this._minUtilization);
            }
            if (this._overBookingFactor != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_overBookingFactor=");
                builder.append(this._overBookingFactor);
            }
            if (this._tlvs != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tlvs=");
                builder.append(this._tlvs);
            }
            if (this._ignore != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ignore=");
                builder.append(this._ignore);
            }
            if (this._processingRule != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_processingRule=");
                builder.append(this._processingRule);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

