/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.keepalive.message;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MessageHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.keepalive.message.KeepaliveMessage;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class KeepaliveMessageBuilder {
    private ProtocolVersion _version;
    private static List<Range<BigInteger>> _version_range;
    Map<Class<? extends Augmentation<KeepaliveMessage>>, Augmentation<KeepaliveMessage>> augmentation = new HashMap<Class<? extends Augmentation<KeepaliveMessage>>, Augmentation<KeepaliveMessage>>();

    public KeepaliveMessageBuilder() {
    }

    public KeepaliveMessageBuilder(MessageHeader arg) {
        this._version = arg.getVersion();
    }

    public KeepaliveMessageBuilder(KeepaliveMessage base) {
        this._version = base.getVersion();
        if (base instanceof KeepaliveMessageImpl) {
            KeepaliveMessageImpl _impl = (KeepaliveMessageImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<KeepaliveMessage>>, Augmentation<KeepaliveMessage>>(_impl.augmentation);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MessageHeader) {
            this._version = ((MessageHeader)arg).getVersion();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MessageHeader] \nbut was: " + arg);
        }
    }

    public ProtocolVersion getVersion() {
        return this._version;
    }

    public <E extends Augmentation<KeepaliveMessage>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public KeepaliveMessageBuilder setVersion(ProtocolVersion value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.getValue().shortValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : KeepaliveMessageBuilder._version_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _version_range));
            }
        }
        this._version = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _version_range() {
        if (_version_range != null) return _version_range;
        Class<KeepaliveMessageBuilder> clazz = KeepaliveMessageBuilder.class;
        synchronized (KeepaliveMessageBuilder.class) {
            if (_version_range != null) return _version_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ONE, (Comparable)BigInteger.valueOf(7L)));
            _version_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _version_range;
        }
    }

    public KeepaliveMessageBuilder addAugmentation(Class<? extends Augmentation<KeepaliveMessage>> augmentationType, Augmentation<KeepaliveMessage> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public KeepaliveMessage build() {
        return new KeepaliveMessageImpl(this);
    }

    private static final class KeepaliveMessageImpl
    implements KeepaliveMessage {
        private final ProtocolVersion _version;
        private Map<Class<? extends Augmentation<KeepaliveMessage>>, Augmentation<KeepaliveMessage>> augmentation = new HashMap<Class<? extends Augmentation<KeepaliveMessage>>, Augmentation<KeepaliveMessage>>();

        public Class<KeepaliveMessage> getImplementedInterface() {
            return KeepaliveMessage.class;
        }

        private KeepaliveMessageImpl(KeepaliveMessageBuilder base) {
            this._version = base.getVersion();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<KeepaliveMessage>>, Augmentation<KeepaliveMessage>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<KeepaliveMessage>>, Augmentation<KeepaliveMessage>>(base.augmentation);
                }
            }
        }

        @Override
        public ProtocolVersion getVersion() {
            return this._version;
        }

        public <E extends Augmentation<KeepaliveMessage>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._version == null ? 0 : this._version.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!KeepaliveMessage.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            KeepaliveMessage other = (KeepaliveMessage)obj;
            if (this._version == null ? other.getVersion() != null : !this._version.equals(other.getVersion())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                KeepaliveMessageImpl otherImpl = (KeepaliveMessageImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<KeepaliveMessage>>, Augmentation<KeepaliveMessage>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("KeepaliveMessage [");
            boolean first = true;
            if (this._version != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_version=");
                builder.append(this._version);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

