/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.load.balancing.object;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.load.balancing.object.LoadBalancing;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LoadBalancingBuilder {
    private Short _maxLsp;
    private static List<Range<BigInteger>> _maxLsp_range;
    private Bandwidth _minBandwidth;
    private Boolean _ignore;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<LoadBalancing>>, Augmentation<LoadBalancing>> augmentation = new HashMap<Class<? extends Augmentation<LoadBalancing>>, Augmentation<LoadBalancing>>();

    public LoadBalancingBuilder() {
    }

    public LoadBalancingBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public LoadBalancingBuilder(LoadBalancing base) {
        this._maxLsp = base.getMaxLsp();
        this._minBandwidth = base.getMinBandwidth();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
        if (base instanceof LoadBalancingImpl) {
            LoadBalancingImpl _impl = (LoadBalancingImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<LoadBalancing>>, Augmentation<LoadBalancing>>(_impl.augmentation);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader] \nbut was: " + arg);
        }
    }

    public Short getMaxLsp() {
        return this._maxLsp;
    }

    public Bandwidth getMinBandwidth() {
        return this._minBandwidth;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public <E extends Augmentation<LoadBalancing>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public LoadBalancingBuilder setMaxLsp(Short value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.shortValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : LoadBalancingBuilder._maxLsp_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _maxLsp_range));
            }
        }
        this._maxLsp = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _maxLsp_range() {
        if (_maxLsp_range != null) return _maxLsp_range;
        Class<LoadBalancingBuilder> clazz = LoadBalancingBuilder.class;
        synchronized (LoadBalancingBuilder.class) {
            if (_maxLsp_range != null) return _maxLsp_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
            _maxLsp_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _maxLsp_range;
        }
    }

    public LoadBalancingBuilder setMinBandwidth(Bandwidth value) {
        this._minBandwidth = value;
        return this;
    }

    public LoadBalancingBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public LoadBalancingBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public LoadBalancingBuilder addAugmentation(Class<? extends Augmentation<LoadBalancing>> augmentationType, Augmentation<LoadBalancing> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public LoadBalancing build() {
        return new LoadBalancingImpl(this);
    }

    private static final class LoadBalancingImpl
    implements LoadBalancing {
        private final Short _maxLsp;
        private final Bandwidth _minBandwidth;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private Map<Class<? extends Augmentation<LoadBalancing>>, Augmentation<LoadBalancing>> augmentation = new HashMap<Class<? extends Augmentation<LoadBalancing>>, Augmentation<LoadBalancing>>();

        public Class<LoadBalancing> getImplementedInterface() {
            return LoadBalancing.class;
        }

        private LoadBalancingImpl(LoadBalancingBuilder base) {
            this._maxLsp = base.getMaxLsp();
            this._minBandwidth = base.getMinBandwidth();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<LoadBalancing>>, Augmentation<LoadBalancing>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<LoadBalancing>>, Augmentation<LoadBalancing>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getMaxLsp() {
            return this._maxLsp;
        }

        @Override
        public Bandwidth getMinBandwidth() {
            return this._minBandwidth;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        public <E extends Augmentation<LoadBalancing>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._maxLsp == null ? 0 : this._maxLsp.hashCode());
            result = 31 * result + (this._minBandwidth == null ? 0 : this._minBandwidth.hashCode());
            result = 31 * result + (this._ignore == null ? 0 : this._ignore.hashCode());
            result = 31 * result + (this._processingRule == null ? 0 : this._processingRule.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!LoadBalancing.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            LoadBalancing other = (LoadBalancing)obj;
            if (this._maxLsp == null ? other.getMaxLsp() != null : !this._maxLsp.equals(other.getMaxLsp())) {
                return false;
            }
            if (this._minBandwidth == null ? other.getMinBandwidth() != null : !this._minBandwidth.equals((Object)other.getMinBandwidth())) {
                return false;
            }
            if (this._ignore == null ? other.isIgnore() != null : !this._ignore.equals(other.isIgnore())) {
                return false;
            }
            if (this._processingRule == null ? other.isProcessingRule() != null : !this._processingRule.equals(other.isProcessingRule())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                LoadBalancingImpl otherImpl = (LoadBalancingImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<LoadBalancing>>, Augmentation<LoadBalancing>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("LoadBalancing [");
            boolean first = true;
            if (this._maxLsp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maxLsp=");
                builder.append(this._maxLsp);
            }
            if (this._minBandwidth != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_minBandwidth=");
                builder.append(this._minBandwidth);
            }
            if (this._ignore != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ignore=");
                builder.append(this._ignore);
            }
            if (this._processingRule != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_processingRule=");
                builder.append(this._processingRule);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

