/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.lspa.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.AttributeFilter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.AttributeFilters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.TunnelAttributes;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LspaBuilder {
    private AttributeFilter _excludeAny;
    private static List<Range<BigInteger>> _excludeAny_range;
    private Short _holdPriority;
    private static List<Range<BigInteger>> _holdPriority_range;
    private AttributeFilter _includeAll;
    private static List<Range<BigInteger>> _includeAll_range;
    private AttributeFilter _includeAny;
    private static List<Range<BigInteger>> _includeAny_range;
    private Short _setupPriority;
    private static List<Range<BigInteger>> _setupPriority_range;
    private Tlvs _tlvs;
    private Boolean _ignore;
    private Boolean _localProtectionDesired;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<Lspa>>, Augmentation<Lspa>> augmentation = new HashMap<Class<? extends Augmentation<Lspa>>, Augmentation<Lspa>>();

    public LspaBuilder() {
    }

    public LspaBuilder(TunnelAttributes arg) {
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._localProtectionDesired = arg.isLocalProtectionDesired();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }

    public LspaBuilder(AttributeFilters arg) {
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }

    public LspaBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public LspaBuilder(Lspa base) {
        this._excludeAny = base.getExcludeAny();
        this._holdPriority = base.getHoldPriority();
        this._includeAll = base.getIncludeAll();
        this._includeAny = base.getIncludeAny();
        this._setupPriority = base.getSetupPriority();
        this._tlvs = base.getTlvs();
        this._ignore = base.isIgnore();
        this._localProtectionDesired = base.isLocalProtectionDesired();
        this._processingRule = base.isProcessingRule();
        if (base instanceof LspaImpl) {
            LspaImpl _impl = (LspaImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<Lspa>>, Augmentation<Lspa>>(_impl.augmentation);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (arg instanceof AttributeFilters) {
            this._includeAny = ((AttributeFilters)arg).getIncludeAny();
            this._excludeAny = ((AttributeFilters)arg).getExcludeAny();
            this._includeAll = ((AttributeFilters)arg).getIncludeAll();
            isValidArg = true;
        }
        if (arg instanceof TunnelAttributes) {
            this._holdPriority = ((TunnelAttributes)arg).getHoldPriority();
            this._setupPriority = ((TunnelAttributes)arg).getSetupPriority();
            this._localProtectionDesired = ((TunnelAttributes)arg).isLocalProtectionDesired();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.AttributeFilters, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.TunnelAttributes] \nbut was: " + arg);
        }
    }

    public AttributeFilter getExcludeAny() {
        return this._excludeAny;
    }

    public Short getHoldPriority() {
        return this._holdPriority;
    }

    public AttributeFilter getIncludeAll() {
        return this._includeAll;
    }

    public AttributeFilter getIncludeAny() {
        return this._includeAny;
    }

    public Short getSetupPriority() {
        return this._setupPriority;
    }

    public Tlvs getTlvs() {
        return this._tlvs;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isLocalProtectionDesired() {
        return this._localProtectionDesired;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public <E extends Augmentation<Lspa>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public LspaBuilder setExcludeAny(AttributeFilter value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.getValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : LspaBuilder._excludeAny_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _excludeAny_range));
            }
        }
        this._excludeAny = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _excludeAny_range() {
        if (_excludeAny_range != null) return _excludeAny_range;
        Class<LspaBuilder> clazz = LspaBuilder.class;
        synchronized (LspaBuilder.class) {
            if (_excludeAny_range != null) return _excludeAny_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
            _excludeAny_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _excludeAny_range;
        }
    }

    public LspaBuilder setHoldPriority(Short value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.shortValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : LspaBuilder._holdPriority_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _holdPriority_range));
            }
        }
        this._holdPriority = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _holdPriority_range() {
        if (_holdPriority_range != null) return _holdPriority_range;
        Class<LspaBuilder> clazz = LspaBuilder.class;
        synchronized (LspaBuilder.class) {
            if (_holdPriority_range != null) return _holdPriority_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
            _holdPriority_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _holdPriority_range;
        }
    }

    public LspaBuilder setIncludeAll(AttributeFilter value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.getValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : LspaBuilder._includeAll_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _includeAll_range));
            }
        }
        this._includeAll = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _includeAll_range() {
        if (_includeAll_range != null) return _includeAll_range;
        Class<LspaBuilder> clazz = LspaBuilder.class;
        synchronized (LspaBuilder.class) {
            if (_includeAll_range != null) return _includeAll_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
            _includeAll_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _includeAll_range;
        }
    }

    public LspaBuilder setIncludeAny(AttributeFilter value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.getValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : LspaBuilder._includeAny_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _includeAny_range));
            }
        }
        this._includeAny = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _includeAny_range() {
        if (_includeAny_range != null) return _includeAny_range;
        Class<LspaBuilder> clazz = LspaBuilder.class;
        synchronized (LspaBuilder.class) {
            if (_includeAny_range != null) return _includeAny_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
            _includeAny_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _includeAny_range;
        }
    }

    public LspaBuilder setSetupPriority(Short value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.shortValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : LspaBuilder._setupPriority_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _setupPriority_range));
            }
        }
        this._setupPriority = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _setupPriority_range() {
        if (_setupPriority_range != null) return _setupPriority_range;
        Class<LspaBuilder> clazz = LspaBuilder.class;
        synchronized (LspaBuilder.class) {
            if (_setupPriority_range != null) return _setupPriority_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
            _setupPriority_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _setupPriority_range;
        }
    }

    public LspaBuilder setTlvs(Tlvs value) {
        this._tlvs = value;
        return this;
    }

    public LspaBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public LspaBuilder setLocalProtectionDesired(Boolean value) {
        this._localProtectionDesired = value;
        return this;
    }

    public LspaBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public LspaBuilder addAugmentation(Class<? extends Augmentation<Lspa>> augmentationType, Augmentation<Lspa> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Lspa build() {
        return new LspaImpl(this);
    }

    private static final class LspaImpl
    implements Lspa {
        private final AttributeFilter _excludeAny;
        private final Short _holdPriority;
        private final AttributeFilter _includeAll;
        private final AttributeFilter _includeAny;
        private final Short _setupPriority;
        private final Tlvs _tlvs;
        private final Boolean _ignore;
        private final Boolean _localProtectionDesired;
        private final Boolean _processingRule;
        private Map<Class<? extends Augmentation<Lspa>>, Augmentation<Lspa>> augmentation = new HashMap<Class<? extends Augmentation<Lspa>>, Augmentation<Lspa>>();

        public Class<Lspa> getImplementedInterface() {
            return Lspa.class;
        }

        private LspaImpl(LspaBuilder base) {
            this._excludeAny = base.getExcludeAny();
            this._holdPriority = base.getHoldPriority();
            this._includeAll = base.getIncludeAll();
            this._includeAny = base.getIncludeAny();
            this._setupPriority = base.getSetupPriority();
            this._tlvs = base.getTlvs();
            this._ignore = base.isIgnore();
            this._localProtectionDesired = base.isLocalProtectionDesired();
            this._processingRule = base.isProcessingRule();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Lspa>>, Augmentation<Lspa>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Lspa>>, Augmentation<Lspa>>(base.augmentation);
                }
            }
        }

        public AttributeFilter getExcludeAny() {
            return this._excludeAny;
        }

        public Short getHoldPriority() {
            return this._holdPriority;
        }

        public AttributeFilter getIncludeAll() {
            return this._includeAll;
        }

        public AttributeFilter getIncludeAny() {
            return this._includeAny;
        }

        public Short getSetupPriority() {
            return this._setupPriority;
        }

        @Override
        public Tlvs getTlvs() {
            return this._tlvs;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        public Boolean isLocalProtectionDesired() {
            return this._localProtectionDesired;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        public <E extends Augmentation<Lspa>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._excludeAny == null ? 0 : this._excludeAny.hashCode());
            result = 31 * result + (this._holdPriority == null ? 0 : this._holdPriority.hashCode());
            result = 31 * result + (this._includeAll == null ? 0 : this._includeAll.hashCode());
            result = 31 * result + (this._includeAny == null ? 0 : this._includeAny.hashCode());
            result = 31 * result + (this._setupPriority == null ? 0 : this._setupPriority.hashCode());
            result = 31 * result + (this._tlvs == null ? 0 : this._tlvs.hashCode());
            result = 31 * result + (this._ignore == null ? 0 : this._ignore.hashCode());
            result = 31 * result + (this._localProtectionDesired == null ? 0 : this._localProtectionDesired.hashCode());
            result = 31 * result + (this._processingRule == null ? 0 : this._processingRule.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Lspa.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Lspa other = (Lspa)obj;
            if (this._excludeAny == null ? other.getExcludeAny() != null : !this._excludeAny.equals((Object)other.getExcludeAny())) {
                return false;
            }
            if (this._holdPriority == null ? other.getHoldPriority() != null : !this._holdPriority.equals(other.getHoldPriority())) {
                return false;
            }
            if (this._includeAll == null ? other.getIncludeAll() != null : !this._includeAll.equals((Object)other.getIncludeAll())) {
                return false;
            }
            if (this._includeAny == null ? other.getIncludeAny() != null : !this._includeAny.equals((Object)other.getIncludeAny())) {
                return false;
            }
            if (this._setupPriority == null ? other.getSetupPriority() != null : !this._setupPriority.equals(other.getSetupPriority())) {
                return false;
            }
            if (this._tlvs == null ? other.getTlvs() != null : !this._tlvs.equals(other.getTlvs())) {
                return false;
            }
            if (this._ignore == null ? other.isIgnore() != null : !this._ignore.equals(other.isIgnore())) {
                return false;
            }
            if (this._localProtectionDesired == null ? other.isLocalProtectionDesired() != null : !this._localProtectionDesired.equals(other.isLocalProtectionDesired())) {
                return false;
            }
            if (this._processingRule == null ? other.isProcessingRule() != null : !this._processingRule.equals(other.isProcessingRule())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                LspaImpl otherImpl = (LspaImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Lspa>>, Augmentation<Lspa>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Lspa [");
            boolean first = true;
            if (this._excludeAny != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_excludeAny=");
                builder.append(this._excludeAny);
            }
            if (this._holdPriority != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_holdPriority=");
                builder.append(this._holdPriority);
            }
            if (this._includeAll != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_includeAll=");
                builder.append(this._includeAll);
            }
            if (this._includeAny != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_includeAny=");
                builder.append(this._includeAny);
            }
            if (this._setupPriority != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_setupPriority=");
                builder.append(this._setupPriority);
            }
            if (this._tlvs != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tlvs=");
                builder.append(this._tlvs);
            }
            if (this._ignore != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ignore=");
                builder.append(this._ignore);
            }
            if (this._localProtectionDesired != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_localProtectionDesired=");
                builder.append(this._localProtectionDesired);
            }
            if (this._processingRule != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_processingRule=");
                builder.append(this._processingRule);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

