/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.metric.object;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819.Float32;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.metric.object.Metric;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MetricBuilder {
    private Short _metricType;
    private static List<Range<BigInteger>> _metricType_range;
    private Float32 _value;
    private static List<Range<BigInteger>> _value_length;
    private Boolean _bound;
    private Boolean _computed;
    private Boolean _ignore;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<Metric>>, Augmentation<Metric>> augmentation = new HashMap<Class<? extends Augmentation<Metric>>, Augmentation<Metric>>();

    public MetricBuilder() {
    }

    public MetricBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public MetricBuilder(Metric base) {
        this._metricType = base.getMetricType();
        this._value = base.getValue();
        this._bound = base.isBound();
        this._computed = base.isComputed();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
        if (base instanceof MetricImpl) {
            MetricImpl _impl = (MetricImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<Metric>>, Augmentation<Metric>>(_impl.augmentation);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader] \nbut was: " + arg);
        }
    }

    public Short getMetricType() {
        return this._metricType;
    }

    public Float32 getValue() {
        return this._value;
    }

    public Boolean isBound() {
        return this._bound;
    }

    public Boolean isComputed() {
        return this._computed;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public <E extends Augmentation<Metric>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MetricBuilder setMetricType(Short value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.shortValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : MetricBuilder._metricType_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _metricType_range));
            }
        }
        this._metricType = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _metricType_range() {
        if (_metricType_range != null) return _metricType_range;
        Class<MetricBuilder> clazz = MetricBuilder.class;
        synchronized (MetricBuilder.class) {
            if (_metricType_range != null) return _metricType_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
            _metricType_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _metricType_range;
        }
    }

    public MetricBuilder setValue(Float32 value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.getValue().length);
            boolean isValidLength = false;
            for (Range<BigInteger> r : MetricBuilder._value_length()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidLength = true;
            }
            if (!isValidLength) {
                throw new IllegalArgumentException(String.format("Invalid length: %s, expected: %s.", value, _value_length));
            }
        }
        this._value = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _value_length() {
        if (_value_length != null) return _value_length;
        Class<MetricBuilder> clazz = MetricBuilder.class;
        synchronized (MetricBuilder.class) {
            if (_value_length != null) return _value_length;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.valueOf(4L), (Comparable)BigInteger.valueOf(4L)));
            _value_length = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _value_length;
        }
    }

    public MetricBuilder setBound(Boolean value) {
        this._bound = value;
        return this;
    }

    public MetricBuilder setComputed(Boolean value) {
        this._computed = value;
        return this;
    }

    public MetricBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public MetricBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public MetricBuilder addAugmentation(Class<? extends Augmentation<Metric>> augmentationType, Augmentation<Metric> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Metric build() {
        return new MetricImpl(this);
    }

    private static final class MetricImpl
    implements Metric {
        private final Short _metricType;
        private final Float32 _value;
        private final Boolean _bound;
        private final Boolean _computed;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private Map<Class<? extends Augmentation<Metric>>, Augmentation<Metric>> augmentation = new HashMap<Class<? extends Augmentation<Metric>>, Augmentation<Metric>>();

        public Class<Metric> getImplementedInterface() {
            return Metric.class;
        }

        private MetricImpl(MetricBuilder base) {
            this._metricType = base.getMetricType();
            this._value = base.getValue();
            this._bound = base.isBound();
            this._computed = base.isComputed();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Metric>>, Augmentation<Metric>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Metric>>, Augmentation<Metric>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getMetricType() {
            return this._metricType;
        }

        @Override
        public Float32 getValue() {
            return this._value;
        }

        @Override
        public Boolean isBound() {
            return this._bound;
        }

        @Override
        public Boolean isComputed() {
            return this._computed;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        public <E extends Augmentation<Metric>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._metricType == null ? 0 : this._metricType.hashCode());
            result = 31 * result + (this._value == null ? 0 : this._value.hashCode());
            result = 31 * result + (this._bound == null ? 0 : this._bound.hashCode());
            result = 31 * result + (this._computed == null ? 0 : this._computed.hashCode());
            result = 31 * result + (this._ignore == null ? 0 : this._ignore.hashCode());
            result = 31 * result + (this._processingRule == null ? 0 : this._processingRule.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Metric.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Metric other = (Metric)obj;
            if (this._metricType == null ? other.getMetricType() != null : !this._metricType.equals(other.getMetricType())) {
                return false;
            }
            if (this._value == null ? other.getValue() != null : !this._value.equals((Object)other.getValue())) {
                return false;
            }
            if (this._bound == null ? other.isBound() != null : !this._bound.equals(other.isBound())) {
                return false;
            }
            if (this._computed == null ? other.isComputed() != null : !this._computed.equals(other.isComputed())) {
                return false;
            }
            if (this._ignore == null ? other.isIgnore() != null : !this._ignore.equals(other.isIgnore())) {
                return false;
            }
            if (this._processingRule == null ? other.isProcessingRule() != null : !this._processingRule.equals(other.isProcessingRule())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MetricImpl otherImpl = (MetricImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Metric>>, Augmentation<Metric>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Metric [");
            boolean first = true;
            if (this._metricType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_metricType=");
                builder.append(this._metricType);
            }
            if (this._value != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_value=");
                builder.append(this._value);
            }
            if (this._bound != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_bound=");
                builder.append(this._bound);
            }
            if (this._computed != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_computed=");
                builder.append(this._computed);
            }
            if (this._ignore != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ignore=");
                builder.append(this._ignore);
            }
            if (this._processingRule != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_processingRule=");
                builder.append(this._processingRule);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

