/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.notification.object;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.notification.object.CNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.notification.object.c.notification.Tlvs;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class CNotificationBuilder {
    private Tlvs _tlvs;
    private Short _type;
    private static List<Range<BigInteger>> _type_range;
    private Short _value;
    private static List<Range<BigInteger>> _value_range;
    private Boolean _ignore;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<CNotification>>, Augmentation<CNotification>> augmentation = new HashMap<Class<? extends Augmentation<CNotification>>, Augmentation<CNotification>>();

    public CNotificationBuilder() {
    }

    public CNotificationBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public CNotificationBuilder(CNotification base) {
        this._tlvs = base.getTlvs();
        this._type = base.getType();
        this._value = base.getValue();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
        if (base instanceof CNotificationImpl) {
            CNotificationImpl _impl = (CNotificationImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<CNotification>>, Augmentation<CNotification>>(_impl.augmentation);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader] \nbut was: " + arg);
        }
    }

    public Tlvs getTlvs() {
        return this._tlvs;
    }

    public Short getType() {
        return this._type;
    }

    public Short getValue() {
        return this._value;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public <E extends Augmentation<CNotification>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public CNotificationBuilder setTlvs(Tlvs value) {
        this._tlvs = value;
        return this;
    }

    public CNotificationBuilder setType(Short value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.shortValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : CNotificationBuilder._type_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _type_range));
            }
        }
        this._type = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _type_range() {
        if (_type_range != null) return _type_range;
        Class<CNotificationBuilder> clazz = CNotificationBuilder.class;
        synchronized (CNotificationBuilder.class) {
            if (_type_range != null) return _type_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
            _type_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _type_range;
        }
    }

    public CNotificationBuilder setValue(Short value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.shortValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : CNotificationBuilder._value_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _value_range));
            }
        }
        this._value = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _value_range() {
        if (_value_range != null) return _value_range;
        Class<CNotificationBuilder> clazz = CNotificationBuilder.class;
        synchronized (CNotificationBuilder.class) {
            if (_value_range != null) return _value_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
            _value_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _value_range;
        }
    }

    public CNotificationBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public CNotificationBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public CNotificationBuilder addAugmentation(Class<? extends Augmentation<CNotification>> augmentationType, Augmentation<CNotification> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public CNotification build() {
        return new CNotificationImpl(this);
    }

    private static final class CNotificationImpl
    implements CNotification {
        private final Tlvs _tlvs;
        private final Short _type;
        private final Short _value;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private Map<Class<? extends Augmentation<CNotification>>, Augmentation<CNotification>> augmentation = new HashMap<Class<? extends Augmentation<CNotification>>, Augmentation<CNotification>>();

        public Class<CNotification> getImplementedInterface() {
            return CNotification.class;
        }

        private CNotificationImpl(CNotificationBuilder base) {
            this._tlvs = base.getTlvs();
            this._type = base.getType();
            this._value = base.getValue();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<CNotification>>, Augmentation<CNotification>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<CNotification>>, Augmentation<CNotification>>(base.augmentation);
                }
            }
        }

        @Override
        public Tlvs getTlvs() {
            return this._tlvs;
        }

        @Override
        public Short getType() {
            return this._type;
        }

        @Override
        public Short getValue() {
            return this._value;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        public <E extends Augmentation<CNotification>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._tlvs == null ? 0 : this._tlvs.hashCode());
            result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
            result = 31 * result + (this._value == null ? 0 : this._value.hashCode());
            result = 31 * result + (this._ignore == null ? 0 : this._ignore.hashCode());
            result = 31 * result + (this._processingRule == null ? 0 : this._processingRule.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!CNotification.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            CNotification other = (CNotification)obj;
            if (this._tlvs == null ? other.getTlvs() != null : !this._tlvs.equals(other.getTlvs())) {
                return false;
            }
            if (this._type == null ? other.getType() != null : !this._type.equals(other.getType())) {
                return false;
            }
            if (this._value == null ? other.getValue() != null : !this._value.equals(other.getValue())) {
                return false;
            }
            if (this._ignore == null ? other.isIgnore() != null : !this._ignore.equals(other.isIgnore())) {
                return false;
            }
            if (this._processingRule == null ? other.isProcessingRule() != null : !this._processingRule.equals(other.isProcessingRule())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                CNotificationImpl otherImpl = (CNotificationImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<CNotification>>, Augmentation<CNotification>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("CNotification [");
            boolean first = true;
            if (this._tlvs != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tlvs=");
                builder.append(this._tlvs);
            }
            if (this._type != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_type=");
                builder.append(this._type);
            }
            if (this._value != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_value=");
                builder.append(this._value);
            }
            if (this._ignore != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ignore=");
                builder.append(this._ignore);
            }
            if (this._processingRule != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_processingRule=");
                builder.append(this._processingRule);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

