/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.message;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MessageHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OpenObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.message.OpenMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.Open;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OpenMessageBuilder {
    private Open _open;
    private ProtocolVersion _version;
    private static List<Range<BigInteger>> _version_range;
    Map<Class<? extends Augmentation<OpenMessage>>, Augmentation<OpenMessage>> augmentation = new HashMap<Class<? extends Augmentation<OpenMessage>>, Augmentation<OpenMessage>>();

    public OpenMessageBuilder() {
    }

    public OpenMessageBuilder(MessageHeader arg) {
        this._version = arg.getVersion();
    }

    public OpenMessageBuilder(OpenObject arg) {
        this._open = arg.getOpen();
    }

    public OpenMessageBuilder(OpenMessage base) {
        this._open = base.getOpen();
        this._version = base.getVersion();
        if (base instanceof OpenMessageImpl) {
            OpenMessageImpl _impl = (OpenMessageImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<OpenMessage>>, Augmentation<OpenMessage>>(_impl.augmentation);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OpenObject) {
            this._open = ((OpenObject)arg).getOpen();
            isValidArg = true;
        }
        if (arg instanceof MessageHeader) {
            this._version = ((MessageHeader)arg).getVersion();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OpenObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MessageHeader] \nbut was: " + arg);
        }
    }

    public Open getOpen() {
        return this._open;
    }

    public ProtocolVersion getVersion() {
        return this._version;
    }

    public <E extends Augmentation<OpenMessage>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public OpenMessageBuilder setOpen(Open value) {
        this._open = value;
        return this;
    }

    public OpenMessageBuilder setVersion(ProtocolVersion value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.getValue().shortValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : OpenMessageBuilder._version_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _version_range));
            }
        }
        this._version = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _version_range() {
        if (_version_range != null) return _version_range;
        Class<OpenMessageBuilder> clazz = OpenMessageBuilder.class;
        synchronized (OpenMessageBuilder.class) {
            if (_version_range != null) return _version_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ONE, (Comparable)BigInteger.valueOf(7L)));
            _version_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _version_range;
        }
    }

    public OpenMessageBuilder addAugmentation(Class<? extends Augmentation<OpenMessage>> augmentationType, Augmentation<OpenMessage> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public OpenMessage build() {
        return new OpenMessageImpl(this);
    }

    private static final class OpenMessageImpl
    implements OpenMessage {
        private final Open _open;
        private final ProtocolVersion _version;
        private Map<Class<? extends Augmentation<OpenMessage>>, Augmentation<OpenMessage>> augmentation = new HashMap<Class<? extends Augmentation<OpenMessage>>, Augmentation<OpenMessage>>();

        public Class<OpenMessage> getImplementedInterface() {
            return OpenMessage.class;
        }

        private OpenMessageImpl(OpenMessageBuilder base) {
            this._open = base.getOpen();
            this._version = base.getVersion();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<OpenMessage>>, Augmentation<OpenMessage>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<OpenMessage>>, Augmentation<OpenMessage>>(base.augmentation);
                }
            }
        }

        @Override
        public Open getOpen() {
            return this._open;
        }

        @Override
        public ProtocolVersion getVersion() {
            return this._version;
        }

        public <E extends Augmentation<OpenMessage>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._open == null ? 0 : this._open.hashCode());
            result = 31 * result + (this._version == null ? 0 : this._version.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!OpenMessage.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            OpenMessage other = (OpenMessage)obj;
            if (this._open == null ? other.getOpen() != null : !this._open.equals(other.getOpen())) {
                return false;
            }
            if (this._version == null ? other.getVersion() != null : !this._version.equals(other.getVersion())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                OpenMessageImpl otherImpl = (OpenMessageImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<OpenMessage>>, Augmentation<OpenMessage>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("OpenMessage [");
            boolean first = true;
            if (this._open != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_open=");
                builder.append(this._open);
            }
            if (this._version != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_version=");
                builder.append(this._version);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

