/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.open.Tlvs;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OpenBuilder {
    private Short _deadTimer;
    private static List<Range<BigInteger>> _deadTimer_range;
    private Short _keepalive;
    private static List<Range<BigInteger>> _keepalive_range;
    private Short _sessionId;
    private static List<Range<BigInteger>> _sessionId_range;
    private Tlvs _tlvs;
    private ProtocolVersion _version;
    private static List<Range<BigInteger>> _version_range;
    private Boolean _ignore;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<Open>>, Augmentation<Open>> augmentation = new HashMap<Class<? extends Augmentation<Open>>, Augmentation<Open>>();

    public OpenBuilder() {
    }

    public OpenBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public OpenBuilder(Open base) {
        this._deadTimer = base.getDeadTimer();
        this._keepalive = base.getKeepalive();
        this._sessionId = base.getSessionId();
        this._tlvs = base.getTlvs();
        this._version = base.getVersion();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
        if (base instanceof OpenImpl) {
            OpenImpl _impl = (OpenImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<Open>>, Augmentation<Open>>(_impl.augmentation);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader] \nbut was: " + arg);
        }
    }

    public Short getDeadTimer() {
        return this._deadTimer;
    }

    public Short getKeepalive() {
        return this._keepalive;
    }

    public Short getSessionId() {
        return this._sessionId;
    }

    public Tlvs getTlvs() {
        return this._tlvs;
    }

    public ProtocolVersion getVersion() {
        return this._version;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public <E extends Augmentation<Open>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public OpenBuilder setDeadTimer(Short value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.shortValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : OpenBuilder._deadTimer_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _deadTimer_range));
            }
        }
        this._deadTimer = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _deadTimer_range() {
        if (_deadTimer_range != null) return _deadTimer_range;
        Class<OpenBuilder> clazz = OpenBuilder.class;
        synchronized (OpenBuilder.class) {
            if (_deadTimer_range != null) return _deadTimer_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
            _deadTimer_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _deadTimer_range;
        }
    }

    public OpenBuilder setKeepalive(Short value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.shortValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : OpenBuilder._keepalive_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _keepalive_range));
            }
        }
        this._keepalive = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _keepalive_range() {
        if (_keepalive_range != null) return _keepalive_range;
        Class<OpenBuilder> clazz = OpenBuilder.class;
        synchronized (OpenBuilder.class) {
            if (_keepalive_range != null) return _keepalive_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
            _keepalive_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _keepalive_range;
        }
    }

    public OpenBuilder setSessionId(Short value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.shortValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : OpenBuilder._sessionId_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _sessionId_range));
            }
        }
        this._sessionId = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _sessionId_range() {
        if (_sessionId_range != null) return _sessionId_range;
        Class<OpenBuilder> clazz = OpenBuilder.class;
        synchronized (OpenBuilder.class) {
            if (_sessionId_range != null) return _sessionId_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
            _sessionId_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _sessionId_range;
        }
    }

    public OpenBuilder setTlvs(Tlvs value) {
        this._tlvs = value;
        return this;
    }

    public OpenBuilder setVersion(ProtocolVersion value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.getValue().shortValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : OpenBuilder._version_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _version_range));
            }
        }
        this._version = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _version_range() {
        if (_version_range != null) return _version_range;
        Class<OpenBuilder> clazz = OpenBuilder.class;
        synchronized (OpenBuilder.class) {
            if (_version_range != null) return _version_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ONE, (Comparable)BigInteger.valueOf(7L)));
            _version_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _version_range;
        }
    }

    public OpenBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public OpenBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public OpenBuilder addAugmentation(Class<? extends Augmentation<Open>> augmentationType, Augmentation<Open> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Open build() {
        return new OpenImpl(this);
    }

    private static final class OpenImpl
    implements Open {
        private final Short _deadTimer;
        private final Short _keepalive;
        private final Short _sessionId;
        private final Tlvs _tlvs;
        private final ProtocolVersion _version;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private Map<Class<? extends Augmentation<Open>>, Augmentation<Open>> augmentation = new HashMap<Class<? extends Augmentation<Open>>, Augmentation<Open>>();

        public Class<Open> getImplementedInterface() {
            return Open.class;
        }

        private OpenImpl(OpenBuilder base) {
            this._deadTimer = base.getDeadTimer();
            this._keepalive = base.getKeepalive();
            this._sessionId = base.getSessionId();
            this._tlvs = base.getTlvs();
            this._version = base.getVersion();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Open>>, Augmentation<Open>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Open>>, Augmentation<Open>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getDeadTimer() {
            return this._deadTimer;
        }

        @Override
        public Short getKeepalive() {
            return this._keepalive;
        }

        @Override
        public Short getSessionId() {
            return this._sessionId;
        }

        @Override
        public Tlvs getTlvs() {
            return this._tlvs;
        }

        @Override
        public ProtocolVersion getVersion() {
            return this._version;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        public <E extends Augmentation<Open>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._deadTimer == null ? 0 : this._deadTimer.hashCode());
            result = 31 * result + (this._keepalive == null ? 0 : this._keepalive.hashCode());
            result = 31 * result + (this._sessionId == null ? 0 : this._sessionId.hashCode());
            result = 31 * result + (this._tlvs == null ? 0 : this._tlvs.hashCode());
            result = 31 * result + (this._version == null ? 0 : this._version.hashCode());
            result = 31 * result + (this._ignore == null ? 0 : this._ignore.hashCode());
            result = 31 * result + (this._processingRule == null ? 0 : this._processingRule.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Open.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Open other = (Open)obj;
            if (this._deadTimer == null ? other.getDeadTimer() != null : !this._deadTimer.equals(other.getDeadTimer())) {
                return false;
            }
            if (this._keepalive == null ? other.getKeepalive() != null : !this._keepalive.equals(other.getKeepalive())) {
                return false;
            }
            if (this._sessionId == null ? other.getSessionId() != null : !this._sessionId.equals(other.getSessionId())) {
                return false;
            }
            if (this._tlvs == null ? other.getTlvs() != null : !this._tlvs.equals(other.getTlvs())) {
                return false;
            }
            if (this._version == null ? other.getVersion() != null : !this._version.equals(other.getVersion())) {
                return false;
            }
            if (this._ignore == null ? other.isIgnore() != null : !this._ignore.equals(other.isIgnore())) {
                return false;
            }
            if (this._processingRule == null ? other.isProcessingRule() != null : !this._processingRule.equals(other.isProcessingRule())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                OpenImpl otherImpl = (OpenImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Open>>, Augmentation<Open>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Open [");
            boolean first = true;
            if (this._deadTimer != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_deadTimer=");
                builder.append(this._deadTimer);
            }
            if (this._keepalive != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_keepalive=");
                builder.append(this._keepalive);
            }
            if (this._sessionId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_sessionId=");
                builder.append(this._sessionId);
            }
            if (this._tlvs != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tlvs=");
                builder.append(this._tlvs);
            }
            if (this._version != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_version=");
                builder.append(this._version);
            }
            if (this._ignore != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ignore=");
                builder.append(this._ignore);
            }
            if (this._processingRule != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_processingRule=");
                builder.append(this._processingRule);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

