/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.order.tlv;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.order.tlv.Order;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OrderBuilder {
    private Long _delete;
    private static List<Range<BigInteger>> _delete_range;
    private Long _setup;
    private static List<Range<BigInteger>> _setup_range;
    Map<Class<? extends Augmentation<Order>>, Augmentation<Order>> augmentation = new HashMap<Class<? extends Augmentation<Order>>, Augmentation<Order>>();

    public OrderBuilder() {
    }

    public OrderBuilder(Order base) {
        this._delete = base.getDelete();
        this._setup = base.getSetup();
        if (base instanceof OrderImpl) {
            OrderImpl _impl = (OrderImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<Order>>, Augmentation<Order>>(_impl.augmentation);
        }
    }

    public Long getDelete() {
        return this._delete;
    }

    public Long getSetup() {
        return this._setup;
    }

    public <E extends Augmentation<Order>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public OrderBuilder setDelete(Long value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value);
            boolean isValidRange = false;
            for (Range<BigInteger> r : OrderBuilder._delete_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _delete_range));
            }
        }
        this._delete = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _delete_range() {
        if (_delete_range != null) return _delete_range;
        Class<OrderBuilder> clazz = OrderBuilder.class;
        synchronized (OrderBuilder.class) {
            if (_delete_range != null) return _delete_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
            _delete_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _delete_range;
        }
    }

    public OrderBuilder setSetup(Long value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value);
            boolean isValidRange = false;
            for (Range<BigInteger> r : OrderBuilder._setup_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _setup_range));
            }
        }
        this._setup = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _setup_range() {
        if (_setup_range != null) return _setup_range;
        Class<OrderBuilder> clazz = OrderBuilder.class;
        synchronized (OrderBuilder.class) {
            if (_setup_range != null) return _setup_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
            _setup_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _setup_range;
        }
    }

    public OrderBuilder addAugmentation(Class<? extends Augmentation<Order>> augmentationType, Augmentation<Order> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Order build() {
        return new OrderImpl(this);
    }

    private static final class OrderImpl
    implements Order {
        private final Long _delete;
        private final Long _setup;
        private Map<Class<? extends Augmentation<Order>>, Augmentation<Order>> augmentation = new HashMap<Class<? extends Augmentation<Order>>, Augmentation<Order>>();

        public Class<Order> getImplementedInterface() {
            return Order.class;
        }

        private OrderImpl(OrderBuilder base) {
            this._delete = base.getDelete();
            this._setup = base.getSetup();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Order>>, Augmentation<Order>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Order>>, Augmentation<Order>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getDelete() {
            return this._delete;
        }

        @Override
        public Long getSetup() {
            return this._setup;
        }

        public <E extends Augmentation<Order>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._delete == null ? 0 : this._delete.hashCode());
            result = 31 * result + (this._setup == null ? 0 : this._setup.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Order.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Order other = (Order)obj;
            if (this._delete == null ? other.getDelete() != null : !this._delete.equals(other.getDelete())) {
                return false;
            }
            if (this._setup == null ? other.getSetup() != null : !this._setup.equals(other.getSetup())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                OrderImpl otherImpl = (OrderImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Order>>, Augmentation<Order>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Order [");
            boolean first = true;
            if (this._delete != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_delete=");
                builder.append(this._delete);
            }
            if (this._setup != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_setup=");
                builder.append(this._setup);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

