/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.key.object;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.key.object.PathKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.key.object.path.key.PathKeys;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PathKeyBuilder {
    private List<PathKeys> _pathKeys;
    private Boolean _ignore;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<PathKey>>, Augmentation<PathKey>> augmentation = new HashMap<Class<? extends Augmentation<PathKey>>, Augmentation<PathKey>>();

    public PathKeyBuilder() {
    }

    public PathKeyBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public PathKeyBuilder(PathKey base) {
        this._pathKeys = base.getPathKeys();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
        if (base instanceof PathKeyImpl) {
            PathKeyImpl _impl = (PathKeyImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<PathKey>>, Augmentation<PathKey>>(_impl.augmentation);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader] \nbut was: " + arg);
        }
    }

    public List<PathKeys> getPathKeys() {
        return this._pathKeys;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public <E extends Augmentation<PathKey>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PathKeyBuilder setPathKeys(List<PathKeys> value) {
        this._pathKeys = value;
        return this;
    }

    public PathKeyBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public PathKeyBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public PathKeyBuilder addAugmentation(Class<? extends Augmentation<PathKey>> augmentationType, Augmentation<PathKey> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PathKey build() {
        return new PathKeyImpl(this);
    }

    private static final class PathKeyImpl
    implements PathKey {
        private final List<PathKeys> _pathKeys;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private Map<Class<? extends Augmentation<PathKey>>, Augmentation<PathKey>> augmentation = new HashMap<Class<? extends Augmentation<PathKey>>, Augmentation<PathKey>>();

        public Class<PathKey> getImplementedInterface() {
            return PathKey.class;
        }

        private PathKeyImpl(PathKeyBuilder base) {
            this._pathKeys = base.getPathKeys();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PathKey>>, Augmentation<PathKey>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PathKey>>, Augmentation<PathKey>>(base.augmentation);
                }
            }
        }

        @Override
        public List<PathKeys> getPathKeys() {
            return this._pathKeys;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        public <E extends Augmentation<PathKey>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._pathKeys == null ? 0 : this._pathKeys.hashCode());
            result = 31 * result + (this._ignore == null ? 0 : this._ignore.hashCode());
            result = 31 * result + (this._processingRule == null ? 0 : this._processingRule.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PathKey.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PathKey other = (PathKey)obj;
            if (this._pathKeys == null ? other.getPathKeys() != null : !this._pathKeys.equals(other.getPathKeys())) {
                return false;
            }
            if (this._ignore == null ? other.isIgnore() != null : !this._ignore.equals(other.isIgnore())) {
                return false;
            }
            if (this._processingRule == null ? other.isProcessingRule() != null : !this._processingRule.equals(other.isProcessingRule())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PathKeyImpl otherImpl = (PathKeyImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PathKey>>, Augmentation<PathKey>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("PathKey [");
            boolean first = true;
            if (this._pathKeys != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_pathKeys=");
                builder.append(this._pathKeys);
            }
            if (this._ignore != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ignore=");
                builder.append(this._ignore);
            }
            if (this._processingRule != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_processingRule=");
                builder.append(this._processingRule);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

