/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.key.object.path.key;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.PathKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.PathKeySubobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.PceId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.key.object.path.key.PathKeys;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PathKeysBuilder {
    private PathKey _pathKey;
    private static List<Range<BigInteger>> _pathKey_range;
    private PceId _pceId;
    private Boolean _loose;
    Map<Class<? extends Augmentation<PathKeys>>, Augmentation<PathKeys>> augmentation = new HashMap<Class<? extends Augmentation<PathKeys>>, Augmentation<PathKeys>>();

    public PathKeysBuilder() {
    }

    public PathKeysBuilder(PathKeySubobject arg) {
        this._pceId = arg.getPceId();
        this._pathKey = arg.getPathKey();
    }

    public PathKeysBuilder(PathKeys base) {
        this._pathKey = base.getPathKey();
        this._pceId = base.getPceId();
        this._loose = base.isLoose();
        if (base instanceof PathKeysImpl) {
            PathKeysImpl _impl = (PathKeysImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<PathKeys>>, Augmentation<PathKeys>>(_impl.augmentation);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PathKeySubobject) {
            this._pceId = ((PathKeySubobject)arg).getPceId();
            this._pathKey = ((PathKeySubobject)arg).getPathKey();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.PathKeySubobject] \nbut was: " + arg);
        }
    }

    public PathKey getPathKey() {
        return this._pathKey;
    }

    public PceId getPceId() {
        return this._pceId;
    }

    public Boolean isLoose() {
        return this._loose;
    }

    public <E extends Augmentation<PathKeys>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PathKeysBuilder setPathKey(PathKey value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.getValue().intValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : PathKeysBuilder._pathKey_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _pathKey_range));
            }
        }
        this._pathKey = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _pathKey_range() {
        if (_pathKey_range != null) return _pathKey_range;
        Class<PathKeysBuilder> clazz = PathKeysBuilder.class;
        synchronized (PathKeysBuilder.class) {
            if (_pathKey_range != null) return _pathKey_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
            _pathKey_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _pathKey_range;
        }
    }

    public PathKeysBuilder setPceId(PceId value) {
        this._pceId = value;
        return this;
    }

    public PathKeysBuilder setLoose(Boolean value) {
        this._loose = value;
        return this;
    }

    public PathKeysBuilder addAugmentation(Class<? extends Augmentation<PathKeys>> augmentationType, Augmentation<PathKeys> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PathKeys build() {
        return new PathKeysImpl(this);
    }

    private static final class PathKeysImpl
    implements PathKeys {
        private final PathKey _pathKey;
        private final PceId _pceId;
        private final Boolean _loose;
        private Map<Class<? extends Augmentation<PathKeys>>, Augmentation<PathKeys>> augmentation = new HashMap<Class<? extends Augmentation<PathKeys>>, Augmentation<PathKeys>>();

        public Class<PathKeys> getImplementedInterface() {
            return PathKeys.class;
        }

        private PathKeysImpl(PathKeysBuilder base) {
            this._pathKey = base.getPathKey();
            this._pceId = base.getPceId();
            this._loose = base.isLoose();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PathKeys>>, Augmentation<PathKeys>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PathKeys>>, Augmentation<PathKeys>>(base.augmentation);
                }
            }
        }

        @Override
        public PathKey getPathKey() {
            return this._pathKey;
        }

        @Override
        public PceId getPceId() {
            return this._pceId;
        }

        @Override
        public Boolean isLoose() {
            return this._loose;
        }

        public <E extends Augmentation<PathKeys>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._pathKey == null ? 0 : this._pathKey.hashCode());
            result = 31 * result + (this._pceId == null ? 0 : this._pceId.hashCode());
            result = 31 * result + (this._loose == null ? 0 : this._loose.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PathKeys.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PathKeys other = (PathKeys)obj;
            if (this._pathKey == null ? other.getPathKey() != null : !this._pathKey.equals(other.getPathKey())) {
                return false;
            }
            if (this._pceId == null ? other.getPceId() != null : !this._pceId.equals(other.getPceId())) {
                return false;
            }
            if (this._loose == null ? other.isLoose() != null : !this._loose.equals(other.isLoose())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PathKeysImpl otherImpl = (PathKeysImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PathKeys>>, Augmentation<PathKeys>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("PathKeys [");
            boolean first = true;
            if (this._pathKey != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_pathKey=");
                builder.append(this._pathKey);
            }
            if (this._pceId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_pceId=");
                builder.append(this._pceId);
            }
            if (this._loose != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_loose=");
                builder.append(this._loose);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

