/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MessageHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.PcerrMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.ErrorType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.Errors;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PcerrMessageBuilder {
    private ErrorType _errorType;
    private List<Errors> _errors;
    private ProtocolVersion _version;
    private static List<Range<BigInteger>> _version_range;
    Map<Class<? extends Augmentation<PcerrMessage>>, Augmentation<PcerrMessage>> augmentation = new HashMap<Class<? extends Augmentation<PcerrMessage>>, Augmentation<PcerrMessage>>();

    public PcerrMessageBuilder() {
    }

    public PcerrMessageBuilder(MessageHeader arg) {
        this._version = arg.getVersion();
    }

    public PcerrMessageBuilder(PcerrMessage base) {
        this._errorType = base.getErrorType();
        this._errors = base.getErrors();
        this._version = base.getVersion();
        if (base instanceof PcerrMessageImpl) {
            PcerrMessageImpl _impl = (PcerrMessageImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<PcerrMessage>>, Augmentation<PcerrMessage>>(_impl.augmentation);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MessageHeader) {
            this._version = ((MessageHeader)arg).getVersion();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MessageHeader] \nbut was: " + arg);
        }
    }

    public ErrorType getErrorType() {
        return this._errorType;
    }

    public List<Errors> getErrors() {
        return this._errors;
    }

    public ProtocolVersion getVersion() {
        return this._version;
    }

    public <E extends Augmentation<PcerrMessage>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PcerrMessageBuilder setErrorType(ErrorType value) {
        this._errorType = value;
        return this;
    }

    public PcerrMessageBuilder setErrors(List<Errors> value) {
        this._errors = value;
        return this;
    }

    public PcerrMessageBuilder setVersion(ProtocolVersion value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.getValue().shortValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : PcerrMessageBuilder._version_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _version_range));
            }
        }
        this._version = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _version_range() {
        if (_version_range != null) return _version_range;
        Class<PcerrMessageBuilder> clazz = PcerrMessageBuilder.class;
        synchronized (PcerrMessageBuilder.class) {
            if (_version_range != null) return _version_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ONE, (Comparable)BigInteger.valueOf(7L)));
            _version_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _version_range;
        }
    }

    public PcerrMessageBuilder addAugmentation(Class<? extends Augmentation<PcerrMessage>> augmentationType, Augmentation<PcerrMessage> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PcerrMessage build() {
        return new PcerrMessageImpl(this);
    }

    private static final class PcerrMessageImpl
    implements PcerrMessage {
        private final ErrorType _errorType;
        private final List<Errors> _errors;
        private final ProtocolVersion _version;
        private Map<Class<? extends Augmentation<PcerrMessage>>, Augmentation<PcerrMessage>> augmentation = new HashMap<Class<? extends Augmentation<PcerrMessage>>, Augmentation<PcerrMessage>>();

        public Class<PcerrMessage> getImplementedInterface() {
            return PcerrMessage.class;
        }

        private PcerrMessageImpl(PcerrMessageBuilder base) {
            this._errorType = base.getErrorType();
            this._errors = base.getErrors();
            this._version = base.getVersion();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PcerrMessage>>, Augmentation<PcerrMessage>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PcerrMessage>>, Augmentation<PcerrMessage>>(base.augmentation);
                }
            }
        }

        @Override
        public ErrorType getErrorType() {
            return this._errorType;
        }

        @Override
        public List<Errors> getErrors() {
            return this._errors;
        }

        @Override
        public ProtocolVersion getVersion() {
            return this._version;
        }

        public <E extends Augmentation<PcerrMessage>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._errorType == null ? 0 : this._errorType.hashCode());
            result = 31 * result + (this._errors == null ? 0 : this._errors.hashCode());
            result = 31 * result + (this._version == null ? 0 : this._version.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PcerrMessage.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PcerrMessage other = (PcerrMessage)obj;
            if (this._errorType == null ? other.getErrorType() != null : !this._errorType.equals(other.getErrorType())) {
                return false;
            }
            if (this._errors == null ? other.getErrors() != null : !this._errors.equals(other.getErrors())) {
                return false;
            }
            if (this._version == null ? other.getVersion() != null : !this._version.equals(other.getVersion())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PcerrMessageImpl otherImpl = (PcerrMessageImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PcerrMessage>>, Augmentation<PcerrMessage>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("PcerrMessage [");
            boolean first = true;
            if (this._errorType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_errorType=");
                builder.append(this._errorType);
            }
            if (this._errors != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_errors=");
                builder.append(this._errors);
            }
            if (this._version != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_version=");
                builder.append(this._version);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

