/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MessageHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.PcntfMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.pcntf.message.Notifications;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PcntfMessageBuilder {
    private List<Notifications> _notifications;
    private ProtocolVersion _version;
    private static List<Range<BigInteger>> _version_range;
    Map<Class<? extends Augmentation<PcntfMessage>>, Augmentation<PcntfMessage>> augmentation = new HashMap<Class<? extends Augmentation<PcntfMessage>>, Augmentation<PcntfMessage>>();

    public PcntfMessageBuilder() {
    }

    public PcntfMessageBuilder(MessageHeader arg) {
        this._version = arg.getVersion();
    }

    public PcntfMessageBuilder(PcntfMessage base) {
        this._notifications = base.getNotifications();
        this._version = base.getVersion();
        if (base instanceof PcntfMessageImpl) {
            PcntfMessageImpl _impl = (PcntfMessageImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<PcntfMessage>>, Augmentation<PcntfMessage>>(_impl.augmentation);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MessageHeader) {
            this._version = ((MessageHeader)arg).getVersion();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MessageHeader] \nbut was: " + arg);
        }
    }

    public List<Notifications> getNotifications() {
        return this._notifications;
    }

    public ProtocolVersion getVersion() {
        return this._version;
    }

    public <E extends Augmentation<PcntfMessage>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PcntfMessageBuilder setNotifications(List<Notifications> value) {
        this._notifications = value;
        return this;
    }

    public PcntfMessageBuilder setVersion(ProtocolVersion value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.getValue().shortValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : PcntfMessageBuilder._version_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _version_range));
            }
        }
        this._version = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _version_range() {
        if (_version_range != null) return _version_range;
        Class<PcntfMessageBuilder> clazz = PcntfMessageBuilder.class;
        synchronized (PcntfMessageBuilder.class) {
            if (_version_range != null) return _version_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ONE, (Comparable)BigInteger.valueOf(7L)));
            _version_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _version_range;
        }
    }

    public PcntfMessageBuilder addAugmentation(Class<? extends Augmentation<PcntfMessage>> augmentationType, Augmentation<PcntfMessage> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PcntfMessage build() {
        return new PcntfMessageImpl(this);
    }

    private static final class PcntfMessageImpl
    implements PcntfMessage {
        private final List<Notifications> _notifications;
        private final ProtocolVersion _version;
        private Map<Class<? extends Augmentation<PcntfMessage>>, Augmentation<PcntfMessage>> augmentation = new HashMap<Class<? extends Augmentation<PcntfMessage>>, Augmentation<PcntfMessage>>();

        public Class<PcntfMessage> getImplementedInterface() {
            return PcntfMessage.class;
        }

        private PcntfMessageImpl(PcntfMessageBuilder base) {
            this._notifications = base.getNotifications();
            this._version = base.getVersion();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PcntfMessage>>, Augmentation<PcntfMessage>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PcntfMessage>>, Augmentation<PcntfMessage>>(base.augmentation);
                }
            }
        }

        @Override
        public List<Notifications> getNotifications() {
            return this._notifications;
        }

        @Override
        public ProtocolVersion getVersion() {
            return this._version;
        }

        public <E extends Augmentation<PcntfMessage>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._notifications == null ? 0 : this._notifications.hashCode());
            result = 31 * result + (this._version == null ? 0 : this._version.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PcntfMessage.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PcntfMessage other = (PcntfMessage)obj;
            if (this._notifications == null ? other.getNotifications() != null : !this._notifications.equals(other.getNotifications())) {
                return false;
            }
            if (this._version == null ? other.getVersion() != null : !this._version.equals(other.getVersion())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PcntfMessageImpl otherImpl = (PcntfMessageImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PcntfMessage>>, Augmentation<PcntfMessage>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("PcntfMessage [");
            boolean first = true;
            if (this._notifications != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_notifications=");
                builder.append(this._notifications);
            }
            if (this._version != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_version=");
                builder.append(this._version);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

