/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.failure._case;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.NoPathObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.failure._case.NoPath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.failure._case.no.path.Tlvs;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NoPathBuilder {
    private Short _natureOfIssue;
    private static List<Range<BigInteger>> _natureOfIssue_range;
    private Tlvs _tlvs;
    private Boolean _ignore;
    private Boolean _processingRule;
    private Boolean _unsatisfiedConstraints;
    Map<Class<? extends Augmentation<NoPath>>, Augmentation<NoPath>> augmentation = new HashMap<Class<? extends Augmentation<NoPath>>, Augmentation<NoPath>>();

    public NoPathBuilder() {
    }

    public NoPathBuilder(NoPathObject arg) {
        this._natureOfIssue = arg.getNatureOfIssue();
        this._unsatisfiedConstraints = arg.isUnsatisfiedConstraints();
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public NoPathBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public NoPathBuilder(NoPath base) {
        this._natureOfIssue = base.getNatureOfIssue();
        this._tlvs = base.getTlvs();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
        this._unsatisfiedConstraints = base.isUnsatisfiedConstraints();
        if (base instanceof NoPathImpl) {
            NoPathImpl _impl = (NoPathImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<NoPath>>, Augmentation<NoPath>>(_impl.augmentation);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (arg instanceof NoPathObject) {
            this._natureOfIssue = ((NoPathObject)arg).getNatureOfIssue();
            this._unsatisfiedConstraints = ((NoPathObject)arg).isUnsatisfiedConstraints();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.NoPathObject] \nbut was: " + arg);
        }
    }

    public Short getNatureOfIssue() {
        return this._natureOfIssue;
    }

    public Tlvs getTlvs() {
        return this._tlvs;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public Boolean isUnsatisfiedConstraints() {
        return this._unsatisfiedConstraints;
    }

    public <E extends Augmentation<NoPath>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NoPathBuilder setNatureOfIssue(Short value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.shortValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : NoPathBuilder._natureOfIssue_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _natureOfIssue_range));
            }
        }
        this._natureOfIssue = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _natureOfIssue_range() {
        if (_natureOfIssue_range != null) return _natureOfIssue_range;
        Class<NoPathBuilder> clazz = NoPathBuilder.class;
        synchronized (NoPathBuilder.class) {
            if (_natureOfIssue_range != null) return _natureOfIssue_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
            _natureOfIssue_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _natureOfIssue_range;
        }
    }

    public NoPathBuilder setTlvs(Tlvs value) {
        this._tlvs = value;
        return this;
    }

    public NoPathBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public NoPathBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public NoPathBuilder setUnsatisfiedConstraints(Boolean value) {
        this._unsatisfiedConstraints = value;
        return this;
    }

    public NoPathBuilder addAugmentation(Class<? extends Augmentation<NoPath>> augmentationType, Augmentation<NoPath> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NoPath build() {
        return new NoPathImpl(this);
    }

    private static final class NoPathImpl
    implements NoPath {
        private final Short _natureOfIssue;
        private final Tlvs _tlvs;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private final Boolean _unsatisfiedConstraints;
        private Map<Class<? extends Augmentation<NoPath>>, Augmentation<NoPath>> augmentation = new HashMap<Class<? extends Augmentation<NoPath>>, Augmentation<NoPath>>();

        public Class<NoPath> getImplementedInterface() {
            return NoPath.class;
        }

        private NoPathImpl(NoPathBuilder base) {
            this._natureOfIssue = base.getNatureOfIssue();
            this._tlvs = base.getTlvs();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
            this._unsatisfiedConstraints = base.isUnsatisfiedConstraints();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NoPath>>, Augmentation<NoPath>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NoPath>>, Augmentation<NoPath>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getNatureOfIssue() {
            return this._natureOfIssue;
        }

        @Override
        public Tlvs getTlvs() {
            return this._tlvs;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        @Override
        public Boolean isUnsatisfiedConstraints() {
            return this._unsatisfiedConstraints;
        }

        public <E extends Augmentation<NoPath>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._natureOfIssue == null ? 0 : this._natureOfIssue.hashCode());
            result = 31 * result + (this._tlvs == null ? 0 : this._tlvs.hashCode());
            result = 31 * result + (this._ignore == null ? 0 : this._ignore.hashCode());
            result = 31 * result + (this._processingRule == null ? 0 : this._processingRule.hashCode());
            result = 31 * result + (this._unsatisfiedConstraints == null ? 0 : this._unsatisfiedConstraints.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NoPath.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NoPath other = (NoPath)obj;
            if (this._natureOfIssue == null ? other.getNatureOfIssue() != null : !this._natureOfIssue.equals(other.getNatureOfIssue())) {
                return false;
            }
            if (this._tlvs == null ? other.getTlvs() != null : !this._tlvs.equals(other.getTlvs())) {
                return false;
            }
            if (this._ignore == null ? other.isIgnore() != null : !this._ignore.equals(other.isIgnore())) {
                return false;
            }
            if (this._processingRule == null ? other.isProcessingRule() != null : !this._processingRule.equals(other.isProcessingRule())) {
                return false;
            }
            if (this._unsatisfiedConstraints == null ? other.isUnsatisfiedConstraints() != null : !this._unsatisfiedConstraints.equals(other.isUnsatisfiedConstraints())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NoPathImpl otherImpl = (NoPathImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NoPath>>, Augmentation<NoPath>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("NoPath [");
            boolean first = true;
            if (this._natureOfIssue != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_natureOfIssue=");
                builder.append(this._natureOfIssue);
            }
            if (this._tlvs != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tlvs=");
                builder.append(this._tlvs);
            }
            if (this._ignore != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ignore=");
                builder.append(this._ignore);
            }
            if (this._processingRule != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_processingRule=");
                builder.append(this._processingRule);
            }
            if (this._unsatisfiedConstraints != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_unsatisfiedConstraints=");
                builder.append(this._unsatisfiedConstraints);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

